/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.symtab;

import bluej.parser.JavaToken;
import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.Definition;
import bluej.parser.symtab.JavaHashtable;
import bluej.parser.symtab.JavaVector;
import bluej.parser.symtab.MethodDef;
import bluej.parser.symtab.MultiDef;
import bluej.parser.symtab.Occurrence;
import bluej.parser.symtab.SymbolTable;
import java.util.Enumeration;

abstract class ScopedDef
extends Definition {
    private JavaHashtable elements = new JavaHashtable();
    private JavaVector unresolvedStuff;
    private boolean iAmDefaultOrBaseScope = false;

    void add(Definition definition) {
        Definition definition2 = (Definition)this.elements.get(definition.getName());
        if (definition2 != null) {
            if (!(definition2 instanceof MultiDef)) {
                this.elements.remove(definition2);
                MultiDef multiDef = new MultiDef(definition.getName(), definition2);
                multiDef.addDef(definition2);
                definition2 = multiDef;
                this.elements.put(definition.getName(), definition2);
            }
            ((MultiDef)definition2).addDef(definition);
        } else {
            this.elements.put(definition.getName(), definition);
            definition.setParentScope(this);
        }
    }

    void addUnresolved(JavaToken javaToken) {
        if (this.unresolvedStuff == null) {
            this.unresolvedStuff = new JavaVector();
        }
        this.unresolvedStuff.addElement(javaToken);
    }

    boolean hasElements() {
        return !this.elements.isEmpty();
    }

    boolean isDefaultOrBaseScope() {
        return this.iAmDefaultOrBaseScope;
    }

    Definition lookup(String string, int n) {
        Definition definition = (Definition)this.elements.get(string);
        if (definition instanceof MultiDef) {
            return definition.lookup(string, n);
        }
        if (definition instanceof MethodDef) {
            if (((MethodDef)definition).getParamCount() == n) {
                return definition;
            }
            return null;
        }
        return definition;
    }

    void getElementInfo(ClassInfo classInfo, SymbolTable symbolTable) {
        Enumeration enumeration = this.elements.elements();
        while (enumeration.hasMoreElements()) {
            Definition definition = (Definition)enumeration.nextElement();
            definition.getInfo(classInfo, symbolTable);
        }
    }

    public void getInfo(ClassInfo classInfo, SymbolTable symbolTable) {
        symbolTable.pushScope(this);
        this.getElementInfo(classInfo, symbolTable);
        if (this.unresolvedStuff != null) {
            this.unresolvedStuff.getUnresolvedInfo(classInfo, symbolTable);
        }
        symbolTable.popScope();
    }

    void resolveTypes(SymbolTable symbolTable) {
        symbolTable.pushScope(this);
        this.elements.resolveTypes(symbolTable);
        if (this.unresolvedStuff != null) {
            this.unresolvedStuff.resolveRefs(symbolTable);
            this.unresolvedStuff = null;
        }
        symbolTable.popScope();
        super.resolveTypes(symbolTable);
    }

    void setDefaultOrBaseScope(boolean bl) {
        this.iAmDefaultOrBaseScope = bl;
    }

    ScopedDef(String string, Occurrence occurrence, ScopedDef scopedDef) {
        super(string, occurrence, scopedDef);
    }
}

