/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.symtab;

import bluej.parser.JavaToken;
import bluej.parser.symtab.BlockDef;
import bluej.parser.symtab.ClassDef;
import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.Definition;
import bluej.parser.symtab.DummyClass;
import bluej.parser.symtab.JavaHashtable;
import bluej.parser.symtab.JavaStack;
import bluej.parser.symtab.JavaVector;
import bluej.parser.symtab.LabelDef;
import bluej.parser.symtab.MethodDef;
import bluej.parser.symtab.Occurrence;
import bluej.parser.symtab.PackageDef;
import bluej.parser.symtab.PrimitiveDef;
import bluej.parser.symtab.ScopedDef;
import bluej.parser.symtab.Selection;
import bluej.parser.symtab.StringTable;
import bluej.parser.symtab.TypedDef;
import bluej.parser.symtab.VariableDef;
import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class SymbolTable {
    private static Vector predefined;
    private BlockDef baseScope = null;
    private PackageDef defaultPackage = null;
    private StringTable names = new StringTable();
    private JavaStack activeScopes;
    private JavaHashtable packages = new JavaHashtable();
    private Definition qualifiedScope;
    private File currentFile;
    private MethodDef currentMethod;
    private String currentIndent = "";
    private JavaVector demand;
    private JavaHashtable importedClasses;
    private PackageDef javaLang;
    private ClassDef object;

    public static Vector getPredefined() {
        return predefined;
    }

    public void addClasses(Vector vector) {
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ClassDef classDef = new ClassDef((String)enumeration.nextElement());
                this.getCurrentScope().add(classDef);
                classDef.setParentScope(this.getCurrentScope());
            }
        }
    }

    void addDemand(PackageDef packageDef) {
        this.demand.addElement(packageDef);
    }

    public void addImport(JavaToken javaToken, String string, String string2) {
        if (this.importedClasses == null) {
            this.importedClasses = new JavaHashtable();
        }
        if (string2.equals(".") || string2.equals("")) {
            this.importedClasses.put(this.getUniqueName("~default~"), this.getDefaultPackage());
            return;
        }
        string2 = string2.substring(1);
        if (string == null) {
            Definition definition = (Definition)this.packages.get(string2);
            if (definition == null) {
                definition = new PackageDef(this.getUniqueName(string2), new Occurrence(this.currentFile, javaToken.getLine(), javaToken.getColumn()), null);
                this.packages.put(string2, definition);
            }
            this.importedClasses.put(definition.getName(), definition);
            this.reference(javaToken);
        } else {
            this.importedClasses.put(this.getUniqueName(string), new DummyClass(this.getUniqueName(string), new Occurrence(this.currentFile, javaToken.getLine(), javaToken.getColumn()), this.getUniqueName(string2)));
            this.reference(javaToken);
        }
    }

    void addToCurrentScope(Definition definition) {
        this.getCurrentScope().add(definition);
        definition.setParentScope(this.getCurrentScope());
    }

    void closeImports() {
        this.demand = null;
        this.importedClasses = null;
    }

    public Definition defineBlock(JavaToken javaToken) {
        BlockDef blockDef = new BlockDef(null, this.getOccurrence(javaToken), this.getCurrentScope());
        this.addToCurrentScope(blockDef);
        return this.pushScope(blockDef);
    }

    public void defineClass(JavaToken javaToken, JavaToken javaToken2, JavaVector javaVector, boolean bl, boolean bl2, JavaToken javaToken3, Selection selection, Selection selection2, Selection selection3, Selection selection4, Vector vector) {
        ClassDef classDef = new ClassDef(this.getUniqueName(javaToken), bl, bl2, this.getOccurrence(javaToken), javaToken2 == null ? null : this.getDummyClass(javaToken2), javaVector, this.getCurrentScope());
        classDef.setType(0);
        classDef.setExtendsInsert(selection);
        classDef.setImplementsInsert(selection2);
        classDef.setExtendsReplace(selection3);
        classDef.setSuperReplace(selection4);
        classDef.setInterfaceSelections(vector);
        classDef.setImports(this.importedClasses);
        if (javaToken3 != null) {
            classDef.setComment(javaToken3.getText());
        }
        this.addToCurrentScope(classDef);
        this.pushScope(classDef);
    }

    public void defineInterface(JavaToken javaToken, JavaVector javaVector, boolean bl, JavaToken javaToken2, Selection selection, Vector vector) {
        ClassDef classDef = new ClassDef(this.getUniqueName(javaToken), false, true, this.getOccurrence(javaToken), null, javaVector, this.getCurrentScope());
        classDef.setType(1);
        classDef.setExtendsInsert(selection);
        classDef.setInterfaceSelections(vector);
        if (javaToken2 != null) {
            classDef.setComment(javaToken2.getText());
        }
        this.addToCurrentScope(classDef);
        this.pushScope(classDef);
    }

    public void defineLabel(JavaToken javaToken) {
        this.addToCurrentScope(new LabelDef(this.getUniqueName(javaToken), this.getOccurrence(javaToken), this.getCurrentScope()));
    }

    public void defineMethod(JavaToken javaToken, JavaToken javaToken2, JavaToken javaToken3) {
        String string;
        if (javaToken2 == null) {
            string = javaToken.getText();
        } else {
            if (javaToken == null) {
                javaToken = javaToken2;
                javaToken2 = null;
            }
            string = javaToken.getText();
        }
        this.currentMethod = new MethodDef(this.getUniqueName(string), this.getOccurrence(javaToken), this.getDummyClass(javaToken2), this.getCurrentScope());
        if (javaToken3 != null) {
            this.currentMethod.setComment(javaToken3.getText());
        }
        this.addToCurrentScope(this.currentMethod);
        this.pushScope(this.currentMethod);
    }

    public void definePackage(JavaToken javaToken) {
        this.definePackage(this.getUniqueName(javaToken));
    }

    PackageDef definePackage(String string) {
        PackageDef packageDef = (PackageDef)this.packages.get(string);
        if (packageDef == null) {
            packageDef = new PackageDef(this.getUniqueName(string), null, null);
            this.packages.put(string, packageDef);
        }
        this.pushScope(packageDef);
        return packageDef;
    }

    public void defineVar(JavaToken javaToken, JavaToken javaToken2, JavaToken javaToken3) {
        String string = javaToken2.getText();
        int n = 0;
        while (string.endsWith("[]")) {
            ++n;
            string = string.substring(0, string.length() - 2);
        }
        javaToken2.setText(string);
        VariableDef variableDef = new VariableDef(this.getUniqueName(javaToken), this.getOccurrence(javaToken), this.getDummyClass(javaToken2), n, this.getCurrentScope());
        if (javaToken3 != null) {
            variableDef.setComment(javaToken3.getText());
        }
        if (this.currentMethod != null) {
            this.currentMethod.add(variableDef);
        } else {
            this.addToCurrentScope(variableDef);
        }
    }

    public void endMethodHead(JavaVector javaVector) {
        this.currentMethod.setExceptions(javaVector);
        this.currentMethod = null;
    }

    Definition findInImports(String string) {
        Definition definition = null;
        if (this.importedClasses != null) {
            definition = (Definition)this.importedClasses.get(string);
        }
        if (definition == null && this.demand != null && string.charAt(0) != '~') {
            Enumeration enumeration = this.demand.elements();
            while (definition == null && enumeration.hasMoreElements()) {
                definition = ((PackageDef)enumeration.nextElement()).lookup(string);
            }
        }
        return definition;
    }

    Definition findPackage(String string) {
        return (Definition)this.packages.get(string);
    }

    ScopedDef getCurrentScope() {
        if (this.activeScopes.empty()) {
            return null;
        }
        return (ScopedDef)this.activeScopes.peek();
    }

    PackageDef getDefaultPackage() {
        if (this.defaultPackage == null) {
            this.defaultPackage = new PackageDef(this.getUniqueName("~default~"), null, null);
            this.packages.put(this.getUniqueName("~default~"), this.defaultPackage);
            this.defaultPackage.setDefaultOrBaseScope(true);
        }
        return this.defaultPackage;
    }

    public DummyClass getDummyClass(JavaToken javaToken) {
        if (javaToken == null) {
            return null;
        }
        return new DummyClass(this.getUniqueName(javaToken), this.getOccurrence(javaToken));
    }

    String getIndent() {
        return this.currentIndent;
    }

    ClassDef getObject() {
        if (this.object == null) {
            this.object = new DummyClass();
            this.object.setType(0);
            this.javaLang.add(this.object);
        }
        return this.object;
    }

    Occurrence getOccurrence(JavaToken javaToken) {
        if (javaToken == null) {
            return new Occurrence(null, 0, 0);
        }
        return new Occurrence(this.currentFile, javaToken.getLine(), javaToken.getColumn());
    }

    Definition getScope() {
        return this.qualifiedScope;
    }

    String getUniqueName(JavaToken javaToken) {
        return this.getUniqueName(javaToken.getText());
    }

    String getUniqueName(String string) {
        return this.names.getName(string);
    }

    Definition lookup(String string) {
        return this.lookup(string, -1);
    }

    Definition lookup(String string, int n) {
        String string2;
        Definition definition = null;
        StringTokenizer stringTokenizer = null;
        String string3 = null;
        if (string.indexOf(46) > 0) {
            string2 = null;
            stringTokenizer = new StringTokenizer(string, ".");
            boolean bl = false;
            while (stringTokenizer.hasMoreElements()) {
                String string4 = (String)stringTokenizer.nextElement();
                PackageDef packageDef = null;
                if (string2 == null) {
                    string2 = string4;
                    definition = this.findInImports(string2);
                    if (definition != null) {
                        bl = true;
                        string4 = (String)stringTokenizer.nextElement();
                    }
                } else {
                    string2 = string2 + "." + string4;
                }
                if (!bl && (packageDef = (PackageDef)this.packages.get(string)) != null) {
                    definition = packageDef;
                    string3 = null;
                    continue;
                }
                string3 = string3 == null ? string4 : string3 + "." + string4;
            }
        } else if (n == -1 && (definition = this.findInImports(string)) != null) {
            return definition;
        }
        if (definition != null && string3 != null) {
            this.setScope(definition);
        } else {
            string3 = string;
        }
        if (string3 != null) {
            stringTokenizer = new StringTokenizer(string3, ".");
            while (stringTokenizer.hasMoreElements()) {
                string2 = (String)stringTokenizer.nextElement();
                if (this.qualifiedScope != null) {
                    definition = this.qualifiedScope.lookup(string2, n);
                    this.resetScope();
                } else {
                    definition = this.activeScopes.lookup(string2, n);
                }
                if (definition == null) break;
                if (!stringTokenizer.hasMoreElements()) continue;
                this.setScope(definition);
            }
        }
        return definition;
    }

    Definition lookupDummy(Definition definition) {
        String string = ((DummyClass)definition).getPackage();
        return this.lookup((string == null ? "" : string + ".") + definition.getName());
    }

    void openImports(JavaHashtable javaHashtable) {
        this.demand = new JavaVector();
        this.demand.addElement(this.javaLang);
        this.importedClasses = new JavaHashtable();
        if (javaHashtable != null) {
            Enumeration enumeration = javaHashtable.elements();
            while (enumeration.hasMoreElements()) {
                Definition definition;
                Definition definition2 = (Definition)enumeration.nextElement();
                if (definition2 instanceof PackageDef) {
                    this.addDemand((PackageDef)definition2);
                    continue;
                }
                if (definition2 instanceof DummyClass && (definition = this.lookupDummy(definition2)) != null) {
                    definition2 = definition;
                }
                this.importedClasses.put(definition2.getName(), definition2);
            }
        }
    }

    public void popAllScopes() {
        while (this.activeScopes.peek() != this.baseScope) {
            this.activeScopes.pop();
        }
        this.importedClasses = null;
    }

    public void popScope() {
        this.activeScopes.pop();
    }

    Definition pushScope(Definition definition) {
        if (!(definition instanceof ScopedDef)) {
            throw new RuntimeException("Not a ScopedDef");
        }
        this.activeScopes.push(definition);
        return definition;
    }

    public void reference(JavaToken javaToken) {
        javaToken.setFile(this.currentFile);
        this.getCurrentScope().addUnresolved(javaToken);
    }

    public void getInfo(ClassInfo classInfo) {
        Enumeration enumeration = this.packages.elements();
        while (enumeration.hasMoreElements()) {
            PackageDef packageDef = (PackageDef)enumeration.nextElement();
            packageDef.getInfo(classInfo, this);
        }
    }

    void resetScope() {
        this.setScope((Definition)null);
    }

    public void resolveTypes() {
        if (this.defaultPackage != null) {
            this.defaultPackage.resolveTypes(this);
        }
        this.packages.resolveTypes(this);
    }

    public void setFile(File file) {
        this.currentFile = file;
    }

    public File getFile() {
        return this.currentFile;
    }

    public void setNearestClassScope() {
        this.setScope(this.activeScopes.findTopmostClass());
    }

    void setScope(JavaToken javaToken) {
        Definition definition = this.lookup(javaToken.getText());
        System.out.println("   using class (scope): " + definition.getName());
        if (definition != null) {
            definition.addReference(this.getOccurrence(javaToken));
            this.setScope(definition);
        }
    }

    void setScope(Definition definition) {
        while (definition != null && definition instanceof TypedDef) {
            definition = ((TypedDef)((Object)definition)).getType();
        }
        if (definition == null || definition instanceof ScopedDef) {
            this.qualifiedScope = definition;
        }
    }

    void setScope(String string) {
        System.out.println("   setting scope: " + string);
        Definition definition = this.lookup(string);
        if (definition != null) {
            this.setScope(definition);
        }
    }

    public String toString() {
        return "Symbol Table";
    }

    public void useDefaultPackage() {
        this.pushScope(this.getDefaultPackage());
    }

    public SymbolTable() {
        this.activeScopes = new JavaStack();
        Occurrence occurrence = new Occurrence(null, 0, 0);
        this.javaLang = new PackageDef(this.getUniqueName("java.lang"), new Occurrence(null, 0, 0), null);
        this.baseScope = new BlockDef(null, null, null);
        this.pushScope(this.baseScope);
        this.baseScope.setDefaultOrBaseScope(true);
        PrimitiveDef primitiveDef = new PrimitiveDef(this.getUniqueName("boolean"), this.getObject(), (ScopedDef)this.baseScope);
        PrimitiveDef primitiveDef2 = new PrimitiveDef(this.getUniqueName("double"), this.getObject(), (ScopedDef)this.baseScope);
        PrimitiveDef primitiveDef3 = new PrimitiveDef(this.getUniqueName("float"), primitiveDef2, (ScopedDef)this.baseScope);
        PrimitiveDef primitiveDef4 = new PrimitiveDef(this.getUniqueName("long"), primitiveDef3, (ScopedDef)this.baseScope);
        PrimitiveDef primitiveDef5 = new PrimitiveDef(this.getUniqueName("int"), primitiveDef4, (ScopedDef)this.baseScope);
        PrimitiveDef primitiveDef6 = new PrimitiveDef(this.getUniqueName("short"), primitiveDef5, (ScopedDef)this.baseScope);
        PrimitiveDef primitiveDef7 = new PrimitiveDef(this.getUniqueName("byte"), primitiveDef6, (ScopedDef)this.baseScope);
        PrimitiveDef primitiveDef8 = new PrimitiveDef(this.getUniqueName("char"), primitiveDef5, (ScopedDef)this.baseScope);
        PrimitiveDef primitiveDef9 = new PrimitiveDef(this.getUniqueName("void"), this.getObject(), (ScopedDef)this.baseScope);
        this.baseScope.add(primitiveDef);
        this.baseScope.add(primitiveDef2);
        this.baseScope.add(primitiveDef3);
        this.baseScope.add(primitiveDef4);
        this.baseScope.add(primitiveDef5);
        this.baseScope.add(primitiveDef6);
        this.baseScope.add(primitiveDef7);
        this.baseScope.add(primitiveDef8);
        this.baseScope.add(primitiveDef9);
        predefined = new Vector(9);
        predefined.addElement("boolean");
        predefined.addElement("double");
        predefined.addElement("float");
        predefined.addElement("long");
        predefined.addElement("int");
        predefined.addElement("short");
        predefined.addElement("byte");
        predefined.addElement("char");
        predefined.addElement("void");
        predefined.addElement("String");
    }
}

