/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.pkgmgr.ClassRole;
import bluej.pkgmgr.ClassTarget;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.RunAppletDialog;
import bluej.prefmgr.PrefMgr;
import bluej.utility.BlueJFileReader;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.Utility;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;

public class AppletClassRole
extends ClassRole {
    static final String runAppletStr = Config.getString("pkgmgr.classmenu.runApplet");
    static final String htmlComment = Config.getString("pkgmgr.runApplet.htmlComment");
    static final String APPLETVIEWER_COMMAND = Config.getPropString("appletViewer.command");
    static final String THIS_DIRECTORY = ".";
    static final String URL_PREFIX = "file://localhost/";
    static final int DEFAULT_APPLET_WIDTH = 500;
    static final int DEFAULT_APPLET_HEIGHT = 500;
    private RunAppletDialog dialog;
    private String[] appletParams;
    private int appletHeight = 500;
    private int appletWidth = 500;

    public void save(Properties properties, int n, String string) {
        super.save(properties, n, string);
        ((Hashtable)properties).put(string + ".type", "AppletTarget");
        if (this.dialog != null) {
            this.appletParams = this.dialog.getAppletParameters();
            ((Hashtable)properties).put(string + ".numberAppletParameters", String.valueOf(this.appletParams.length));
            int n2 = 0;
            while (n2 < this.appletParams.length) {
                ((Hashtable)properties).put(string + ".appletParameter" + (n2 + 1), this.appletParams[n2]);
                ++n2;
            }
        } else {
            ((Hashtable)properties).put(string + ".numberAppletParameters", String.valueOf(0));
        }
        ((Hashtable)properties).put(string + ".appletHeight", String.valueOf(this.appletHeight));
        ((Hashtable)properties).put(string + ".appletWidth", String.valueOf(this.appletWidth));
    }

    public void load(Properties properties, String string) throws NumberFormatException {
        String string2 = properties.getProperty(string + ".numberAppletParameters");
        int n = 0;
        if (string2 != null) {
            n = Integer.parseInt(string2);
        }
        if (n > 0) {
            this.appletParams = new String[n];
            int n2 = 0;
            while (n2 < n) {
                this.appletParams[n2] = properties.getProperty(string + ".appletParameter" + (n2 + 1));
                ++n2;
            }
        }
        if ((string2 = properties.getProperty(string + ".appletHeight")) != null) {
            this.appletHeight = Integer.parseInt(string2);
        }
        if ((string2 = properties.getProperty(string + ".appletWidth")) != null) {
            this.appletWidth = Integer.parseInt(string2);
        }
    }

    protected void createMenu(JPopupMenu jPopupMenu, ClassTarget classTarget, int n) {
        classTarget.addMenuItem(jPopupMenu, runAppletStr, n == 0);
        jPopupMenu.addSeparator();
    }

    public void actionPerformed(ActionEvent actionEvent, ClassTarget classTarget) {
        String string = actionEvent.getActionCommand();
        if (runAppletStr.equals(string)) {
            classTarget.getPackage().getEditor().raiseRunTargetEvent(classTarget);
        }
    }

    void runApplet(PkgMgrFrame pkgMgrFrame, ClassTarget classTarget) {
        String string = classTarget.getBaseName();
        Package package_ = classTarget.getPackage();
        if (this.dialog == null) {
            this.dialog = new RunAppletDialog(pkgMgrFrame, string);
            if (this.appletParams != null) {
                this.dialog.setAppletParameters(this.appletParams);
            }
            this.dialog.setAppletHeight(this.appletHeight);
            this.dialog.setAppletWidth(this.appletWidth);
        }
        if (this.dialog.display()) {
            int n = this.dialog.getAppletExecutionOption();
            if (n == 2) {
                String string2 = this.chooseWebPage(pkgMgrFrame);
                if (string2 != null) {
                    this.createWebPage(string, URL_PREFIX + package_.getPath().getPath(), string2);
                }
            } else {
                String string3 = package_.getPath().getAbsolutePath();
                String string4 = new File(string3, string + ".html").getPath();
                this.createWebPage(string, THIS_DIRECTORY, string4);
                String string5 = URL_PREFIX + string4;
                if (n == 0) {
                    try {
                        String[] stringArray = new String[]{APPLETVIEWER_COMMAND, string5};
                        PkgMgrFrame.displayMessage(Config.getString("pkgmgr.appletInViewer"));
                        Process process = Runtime.getRuntime().exec(stringArray);
                    }
                    catch (Exception exception) {
                        package_.showError("appletviewer-error");
                        Debug.reportError("Exception thrown in execution of appletviewer");
                        exception.printStackTrace();
                    }
                } else {
                    PkgMgrFrame.displayMessage(Config.getString("pkgmgr.appletInBrowser"));
                    Utility.openWebBrowser(string4);
                }
            }
        }
    }

    private String chooseWebPage(JFrame jFrame) {
        String string = FileUtility.getFileName(jFrame, Config.getString("pkgmgr.chooseWebPage.title"), Config.getString("pkgmgr.chooseWebPage.buttonLabel"), false);
        if (string == null) {
            DialogManager.showError(jFrame, "error-no-name");
        }
        return string;
    }

    private void updateAppletProperties() {
        try {
            this.appletHeight = Integer.parseInt(this.dialog.getAppletHeight());
            this.appletWidth = Integer.parseInt(this.dialog.getAppletWidth());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.appletParams = this.dialog.getAppletParameters();
    }

    private void createWebPage(String string, String string2, String string3) {
        this.updateAppletProperties();
        this.generateHTMLSkeleton(string, string3, string2, this.dialog.getAppletWidth(), this.dialog.getAppletHeight(), this.appletParams);
    }

    private void generateHTMLSkeleton(String string, String string2, String string3, String string4, String string5, String[] stringArray) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("TITLE", string);
        hashtable.put("COMMENT", htmlComment);
        hashtable.put("CLASSFILE", string + ".class");
        if (string3 != null) {
            hashtable.put("CODEBASE", string3);
        }
        hashtable.put("APPLETWIDTH", string4);
        hashtable.put("APPLETHEIGHT", string5);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append("\t" + stringArray[n] + "\n");
            ++n;
        }
        hashtable.put("PARAMETERS", stringBuffer.toString());
        String string6 = Config.getTemplateFile("html").getPath();
        try {
            BlueJFileReader.translateFile(string6, string2, hashtable);
        }
        catch (IOException iOException) {
            Debug.reportError("Exception during file translation from " + string6 + " to " + string2);
            iOException.printStackTrace();
        }
    }

    public void prepareFilesForRemoval(String string, String string2, String string3) {
        super.prepareFilesForRemoval(string, string2, string3);
        File file = new File(string2 + ".html");
        if (file.exists()) {
            file.delete();
        }
    }

    public void draw(Graphics2D graphics2D, ClassTarget classTarget, int n, int n2, int n3, int n4) {
        if (!PrefMgr.isUML()) {
            graphics2D.setColor(classTarget.getTextColour());
            Utility.drawCentredText(graphics2D, "www", 8, 24, n3 - 16, n4 - 24);
        }
    }
}

