/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerClassLoader;
import bluej.editor.Editor;
import bluej.editor.EditorWatcher;
import bluej.graph.GraphEditor;
import bluej.parser.ClassParser;
import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.Selection;
import bluej.pkgmgr.AppletClassRole;
import bluej.pkgmgr.ClassRole;
import bluej.pkgmgr.Dependency;
import bluej.pkgmgr.DependentTarget;
import bluej.pkgmgr.EditableTarget;
import bluej.pkgmgr.ExtendsDependency;
import bluej.pkgmgr.ImplementsDependency;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.SourceInfo;
import bluej.pkgmgr.StdClassRole;
import bluej.pkgmgr.Target;
import bluej.pkgmgr.UsesDependency;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileEditor;
import bluej.utility.FileUtility;
import bluej.utility.JavaNames;
import bluej.utility.Utility;
import bluej.views.CallableView;
import bluej.views.MemberView;
import bluej.views.View;
import bluej.views.ViewFilter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ClassTarget
extends EditableTarget
implements ActionListener {
    static final Color defaultbg = Config.getItemColour("colour.class.bg.default");
    static final Color librarybg = Config.getItemColour("colour.class.bg.imported");
    static final Color abstractbg = Config.getItemColour("colour.class.bg.abstract");
    static final Color interfacebg = Config.getItemColour("colour.class.bg.interface");
    static final Color compbg = Config.getItemColour("colour.target.bg.compiling");
    static final Color umldefaultbg = Config.getItemColour("colour.class.bg.uml.default");
    static final Color umlcompbg = Config.getItemColour("colour.target.bg.uml.compiling");
    static final Color umlShadowCol = Config.getItemColour("colour.target.uml.shadow");
    static final Color colBorder = Config.getItemColour("colour.target.border");
    static final Color graphbg = Config.getItemColour("colour.graph.background");
    static final Color textfg = Config.getItemColour("colour.text.fg");
    static final Color envOpColour = Config.getItemColour("colour.menu.environOp");
    static String usesArrowMsg = Config.getString("pkgmgr.usesArrowMsg");
    static final Image brokenImage = Config.getImageAsIcon("image.broken").getImage();
    static final String STEREOTYPE_OPEN = "<<";
    static final String STEREOTYPE_CLOSE = ">>";
    static final String INTERFACE_LABEL = "interface";
    static final String APPLET_LABEL = "applet";
    static final String ABSTRACT_CLASS_LABEL = "abstract";
    static final String HTML_EXTENSION = ".html";
    static String editStr = Config.getString("pkgmgr.classmenu.edit");
    static String openStr = Config.getString("browser.classchooser.classmenu.open");
    static String useStr = Config.getString("browser.classchooser.classmenu.use");
    static String compileStr = Config.getString("pkgmgr.classmenu.compile");
    static String removeStr = Config.getString("pkgmgr.classmenu.remove");
    private ClassRole role;
    private String template = null;
    protected int modifiers;
    protected Vector breakpoints = new Vector();
    protected SourceInfo sourceInfo = new SourceInfo();
    public int dfn;
    public int link;
    private boolean analysing = false;
    protected Class last_class = null;
    protected JPopupMenu menu = null;
    boolean compiledMenu = false;
    protected Hashtable actions;
    int anchor_x = 0;
    int anchor_y = 0;
    int last_x = 0;
    int last_y = 0;
    private static /* synthetic */ Class class$Ljava$applet$Applet;

    public String getQualifiedName() {
        return this.getPackage().getQualifiedName(this.getBaseName());
    }

    public String getBaseName() {
        return this.getIdentifierName();
    }

    public void load(Properties properties, String string) throws NumberFormatException {
        super.load(properties, string);
        String string2 = properties.getProperty(string + ".type");
        if ("AppletTarget".equals(string2) && !(this.role instanceof AppletClassRole)) {
            this.role = new AppletClassRole();
        }
        this.role.load(properties, string);
        String string3 = properties.getProperty(string + ".modifiers", "0");
        this.modifiers = Integer.parseInt(string3, 16);
        this.sourceInfo.load(properties, string);
    }

    public void save(Properties properties, String string) {
        super.save(properties, string);
        this.role.save(properties, this.modifiers, string);
        this.sourceInfo.save(properties, string);
    }

    public boolean copyFiles(String string) {
        boolean bl = true;
        if (!FileUtility.copyFile(this.getSourceFile(), new File(string, this.getBaseName() + ".java"))) {
            bl = false;
        }
        if (this.upToDate()) {
            if (!FileUtility.copyFile(this.getClassFile(), new File(string, this.getBaseName() + ".class"))) {
                bl = false;
            }
            if (!FileUtility.copyFile(this.getContextFile(), new File(string, this.getBaseName() + ".ctxt"))) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean upToDate() {
        try {
            File file = this.getSourceFile();
            File file2 = this.getClassFile();
            if (!file2.exists() || file.exists() && file.lastModified() > file2.lastModified()) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public void invalidate() {
        this.setState(1);
        Enumeration enumeration = this.dependents();
        while (enumeration.hasMoreElements()) {
            Dependency dependency = (Dependency)enumeration.nextElement();
            DependentTarget dependentTarget = dependency.getFrom();
            dependentTarget.setState(1);
        }
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.modifiers);
    }

    public void setInterface(boolean bl) {
        this.modifiers = bl ? (this.modifiers |= 0x200) : (this.modifiers &= 0xFFFFFDFF);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers);
    }

    public void setAbstract(boolean bl) {
        this.modifiers = bl ? (this.modifiers |= 0x400) : (this.modifiers &= 0xFFFFFBFF);
    }

    public boolean isApplet() {
        ClassInfo classInfo = this.sourceInfo.getInfoIfAvailable();
        if (!(this.role instanceof AppletClassRole) && classInfo != null && classInfo.isApplet()) {
            this.role = new AppletClassRole();
        }
        return this.role instanceof AppletClassRole;
    }

    Color getDefaultBackground() {
        if (PrefMgr.isUML()) {
            return umldefaultbg;
        }
        if (this.isInterface()) {
            return interfacebg;
        }
        if (this.isAbstract()) {
            return abstractbg;
        }
        return defaultbg;
    }

    Color getBackgroundColour() {
        if (this.state == 2) {
            return compbg;
        }
        return this.getDefaultBackground();
    }

    Color getBorderColour() {
        return colBorder;
    }

    Color getTextColour() {
        return textfg;
    }

    Font getFont() {
        return PrefMgr.getTargetFont();
    }

    protected boolean isCode() {
        return true;
    }

    public File getSourceFile() {
        return new File(this.getPackage().getPath(), this.getBaseName() + ".java");
    }

    public File getContextFile() {
        return new File(this.getPackage().getPath(), this.getBaseName() + ".ctxt");
    }

    public File getClassFile() {
        return new File(this.getPackage().getPath(), this.getBaseName() + ".class");
    }

    public Editor getEditor() {
        if (this.editor == null) {
            this.getPackage();
            this.editor = Package.editorManager.openClass(this.getSourceFile().getPath(), this.getBaseName(), (EditorWatcher)this, this.isCompiled(), this.breakpoints);
        }
        return this.editor;
    }

    public void modificationEvent(Editor editor) {
        this.invalidate();
        this.sourceInfo.setSourceModified();
    }

    public void saveEvent(Editor editor) {
        this.analyseSource(true);
    }

    public String breakpointToggleEvent(Editor editor, int n, boolean bl) {
        if (this.isCompiled()) {
            DebuggerClassLoader debuggerClassLoader = this.getPackage().getRemoteClassLoader();
            return Debugger.debugger.toggleBreakpoint(this.getQualifiedName(), n, bl, debuggerClassLoader);
        }
        return Config.getString("pkgmgr.breakpointMsg");
    }

    public void compile(Editor editor) {
        this.getPackage().compile(this);
    }

    protected void removeBreakpoints() {
        if (this.editor != null) {
            this.editor.removeBreakpoints();
        }
    }

    protected void removeStepMark() {
        if (this.editor != null) {
            this.editor.removeStepMark();
        }
    }

    protected boolean isCompiled() {
        return this.state == 0;
    }

    public void endCompile() {
        Class clazz = this.getPackage().loadClass(this.getQualifiedName());
        if (clazz != null) {
            if ((class$Ljava$applet$Applet != null ? class$Ljava$applet$Applet : (class$Ljava$applet$Applet = ClassTarget.class$("java.applet.Applet"))).isAssignableFrom(clazz)) {
                if (!(this.role instanceof AppletClassRole)) {
                    this.role = new AppletClassRole();
                }
            } else if (!(this.role instanceof StdClassRole)) {
                this.role = new StdClassRole();
            }
        }
    }

    public void runApplet(PkgMgrFrame pkgMgrFrame) {
        if (this.role instanceof AppletClassRole) {
            AppletClassRole appletClassRole = (AppletClassRole)this.role;
            appletClassRole.runApplet(pkgMgrFrame, this);
        }
    }

    public void generateSkeleton() {
        if (this.template == null) {
            Debug.reportError("generate class skeleton error");
        } else {
            this.role.generateSkeleton(this.template, this.getPackage(), this.getBaseName(), this.getSourceFile().getPath());
            this.setState(1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void enforcePackage(String string) throws IOException {
        Selection selection;
        ClassInfo classInfo;
        if (!JavaNames.isQualifiedIdentifier(string)) {
            throw new IllegalArgumentException();
        }
        try {
            classInfo = ClassParser.parse(this.getSourceFile());
        }
        catch (Exception exception) {
            return;
        }
        if (classInfo == null) {
            return;
        }
        int n = 0;
        if (string.length() == 0) {
            if (!classInfo.hasPackageStatement()) return;
            n = 1;
        } else if (classInfo.hasPackageStatement()) {
            if (classInfo.getPackage().equals(string)) {
                return;
            }
            n = 3;
        } else {
            n = 4;
        }
        FileEditor fileEditor = new FileEditor(this.getSourceFile());
        if (n == 1 || n == 4) {
            selection = classInfo.getPackageSemiSelection();
            if (n == 1) {
                fileEditor.replaceSelection(selection, "");
            } else {
                fileEditor.replaceSelection(selection, ";\n\n");
            }
        }
        selection = classInfo.getPackageNameSelection();
        if (n == 1) {
            fileEditor.replaceSelection(selection, "");
        } else {
            fileEditor.replaceSelection(selection, string);
        }
        if (n == 1 || n == 4) {
            Selection selection2 = classInfo.getPackageStatementSelection();
            if (n == 1) {
                fileEditor.replaceSelection(selection2, "");
            } else {
                fileEditor.replaceSelection(selection2, "package ");
            }
        }
        fileEditor.save();
    }

    public void analyseSource(boolean bl) {
        if (this.analysing) {
            return;
        }
        this.analysing = true;
        ClassInfo classInfo = this.sourceInfo.getInfo(this.getSourceFile().getPath(), this.getPackage().getAllClassnames());
        if (classInfo != null) {
            this.setInterface(classInfo.isInterface());
            this.setAbstract(classInfo.isAbstract());
            this.analyseDependencies(classInfo);
            if (bl) {
                if (this.analyseClassName(classInfo)) {
                    this.doClassNameChange(classInfo.getName());
                }
                if (this.analysePackageName(classInfo)) {
                    this.doPackageNameChange(classInfo.getPackage());
                }
            }
        }
        this.getPackage().repaint();
        this.analysing = false;
    }

    public boolean analyseClassName(ClassInfo classInfo) {
        String string = classInfo.getName();
        if (string == null || string.length() == 0) {
            return false;
        }
        return !this.getBaseName().equals(string);
    }

    public boolean analysePackageName(ClassInfo classInfo) {
        String string = classInfo.getPackage();
        return !this.getPackage().getQualifiedName().equals(string);
    }

    public void analyseDependencies(ClassInfo classInfo) {
        DependentTarget dependentTarget;
        Object object;
        Object object2;
        this.removeInheritDependencies();
        this.unflagAllOutDependencies();
        if (classInfo.getSuperclass() != null && (object2 = (DependentTarget)this.getPackage().getTarget(classInfo.getSuperclass())) != null) {
            this.getPackage().addDependency(new ExtendsDependency(this.getPackage(), this, (DependentTarget)object2), false);
        }
        object2 = classInfo.getImplements();
        Enumeration enumeration = ((Vector)object2).elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            dependentTarget = this.getPackage().getDependentTarget((String)object);
            if (dependentTarget == null) continue;
            this.getPackage().addDependency(new ImplementsDependency(this.getPackage(), this, dependentTarget), false);
        }
        object2 = classInfo.getUsed();
        enumeration = ((Vector)object2).elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            dependentTarget = this.getPackage().getDependentTarget((String)object);
            if (dependentTarget == null) continue;
            this.getPackage().addDependency(new UsesDependency(this.getPackage(), this, dependentTarget), true);
        }
        int n = 0;
        while (n < this.outUses.size()) {
            object = (UsesDependency)this.outUses.elementAt(n);
            if (!((UsesDependency)object).isFlagged()) {
                this.getPackage().setStatus(usesArrowMsg + object);
            }
            ++n;
        }
    }

    private boolean doClassNameChange(String string) {
        if (this.getPackage().getTarget(string) != null) {
            this.getPackage().showError("duplicate-name");
            return false;
        }
        File file = new File(this.getPackage().getPath(), string + ".java");
        File file2 = this.getSourceFile();
        if (FileUtility.copyFile(file2, file)) {
            this.getPackage().updateTargetIdentifier(this, this.getIdentifierName(), string);
            this.getEditor().changeName(string, file.getPath());
            this.role.prepareFilesForRemoval(file2.getPath(), this.getClassFile().getPath(), this.getContextFile().getPath());
            this.setIdentifierName(string);
            this.setDisplayName(string);
            return true;
        }
        return false;
    }

    private void doPackageNameChange(String string) {
        Project project = this.getPackage().getProject();
        Package package_ = project.getPackage(string);
        if (package_ == null) {
            DialogManager.showError(null, "package-name-invalid");
        } else if (DialogManager.askQuestion(null, "package-name-changed") == 0) {
            switch (package_.importFile(this.getSourceFile())) {
                default: 
            }
            this.prepareForRemoval();
            this.getPackage().removeTarget(this);
            this.close();
            return;
        }
        try {
            this.enforcePackage(this.getPackage().getQualifiedName());
            this.getEditor().reloadFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void popupMenu(MouseEvent mouseEvent, int n, int n2, GraphEditor graphEditor) {
        if (this.state == 0) {
            Class clazz = this.getPackage().loadClass(this.getQualifiedName());
            if (clazz != null && this.last_class != clazz) {
                if (this.menu != null) {
                    graphEditor.remove(this.menu);
                }
                this.menu = this.createMenu(clazz);
                graphEditor.add(this.menu);
                this.compiledMenu = true;
            }
            this.last_class = clazz;
        } else if (this.compiledMenu || this.menu == null) {
            this.menu = this.createMenu(null);
            graphEditor.add(this.menu);
            this.compiledMenu = false;
        }
        if (this.menu != null) {
            this.menu.show(graphEditor, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected JPopupMenu createMenu(Class clazz) {
        this.actions = new Hashtable();
        JPopupMenu jPopupMenu = new JPopupMenu(this.getBaseName() + " operations");
        this.role.createMenu(jPopupMenu, this, this.state);
        if (clazz != null) {
            this.createClassMenu(jPopupMenu, clazz);
        }
        this.addMenuItem(jPopupMenu, editStr, true);
        this.addMenuItem(jPopupMenu, compileStr, true);
        this.addMenuItem(jPopupMenu, removeStr, true);
        return jPopupMenu;
    }

    protected void addMenuItem(JPopupMenu jPopupMenu, String string, boolean bl) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem.setFont(PrefMgr.getPopupMenuFont());
        jMenuItem.setForeground(envOpColour);
        if (!bl) {
            jMenuItem.setEnabled(false);
        }
    }

    protected void createClassMenu(JPopupMenu jPopupMenu, Class clazz) {
        CallableView[] callableViewArray;
        ViewFilter viewFilter;
        View view = View.getView(clazz);
        if (!this.isAbstract()) {
            viewFilter = new ViewFilter(196609);
            callableViewArray = view.getConstructors();
            if (this.createMenuItems(jPopupMenu, callableViewArray, viewFilter, 0, callableViewArray.length, "new ")) {
                jPopupMenu.addSeparator();
            }
        }
        viewFilter = new ViewFilter(65549);
        callableViewArray = view.getAllMethods();
        if (this.createMenuItems(jPopupMenu, callableViewArray, viewFilter, 0, callableViewArray.length, "")) {
            jPopupMenu.addSeparator();
        }
    }

    protected boolean createMenuItems(JPopupMenu jPopupMenu, CallableView[] callableViewArray, ViewFilter viewFilter, int n, int n2, String string) {
        boolean bl = false;
        int n3 = n;
        while (n3 < n2) {
            try {
                CallableView callableView = callableViewArray[n2 - n3 - 1];
                if (viewFilter.accept(callableView)) {
                    ClassTarget classTarget = this;
                    if (classTarget == null) {
                        throw null;
                    }
                    CallAction callAction = classTarget.new CallAction(string + callableView.getShortDesc(), this, callableView);
                    JMenuItem jMenuItem = jPopupMenu.add(callAction);
                    jMenuItem.setFont(PrefMgr.getPopupMenuFont());
                    bl = true;
                }
            }
            catch (Exception exception) {
                Debug.reportError("Exception accessing methods: " + exception);
                exception.printStackTrace();
            }
            ++n3;
        }
        return bl;
    }

    public void draw(Graphics2D graphics2D) {
        super.draw(graphics2D);
        if (PrefMgr.isUML()) {
            this.drawUMLStyle(graphics2D);
        } else {
            this.drawBlueStyle(graphics2D);
        }
        graphics2D.setColor(this.getBorderColour());
        this.drawBorders(graphics2D);
        if (!this.sourceInfo.isValid()) {
            graphics2D.drawImage(brokenImage, this.x + 8, this.y + this.height - 22, null);
        }
        this.role.draw(graphics2D, this, this.x, this.y, this.width, this.height);
    }

    public String getStereotype() {
        String string = null;
        if (this.isAbstract()) {
            string = ABSTRACT_CLASS_LABEL;
        } else if (this.isInterface()) {
            string = INTERFACE_LABEL;
        } else if (this.isApplet()) {
            string = APPLET_LABEL;
        }
        return string;
    }

    private void drawUMLStyle(Graphics2D graphics2D) {
        int n;
        String string = this.getStereotype();
        if (this.state != 0) {
            graphics2D.setColor(umlShadowCol);
            n = string == null ? 18 : 32;
            Utility.stripeRect(graphics2D, 0, n, this.width, this.height - n, 8, 3);
        }
        graphics2D.setColor(this.getTextColour());
        n = 2;
        Font font = this.getFont();
        if (string != null) {
            String string2 = STEREOTYPE_OPEN + string + STEREOTYPE_CLOSE;
            Font font2 = font.deriveFont((float)(font.getSize() - 2));
            graphics2D.setFont(font2);
            Utility.drawCentredText(graphics2D, string2, 8, n, this.width - 16, 16);
            n += 14;
        }
        graphics2D.setFont(font);
        Utility.drawCentredText(graphics2D, this.getIdentifierName(), 8, n, this.width - 16, 16);
        graphics2D.drawLine(0, n += 16, this.width, n);
    }

    private void drawBlueStyle(Graphics2D graphics2D) {
        if (this.state != 0) {
            graphics2D.setColor(Target.shadowCol);
            Utility.stripeRect(graphics2D, 0, 0, this.width, this.height, 8, 3);
        }
        graphics2D.setColor(Target.textbg);
        graphics2D.fillRect(8, 8, this.width - 16, 16);
        graphics2D.setColor(this.getBorderColour());
        graphics2D.drawRect(8, 8, this.width - 16, 16);
        graphics2D.setColor(this.getTextColour());
        graphics2D.setFont(this.getFont());
        Utility.drawCentredText(graphics2D, this.getIdentifierName(), 8, 8, this.width - 16, 16);
    }

    void drawShadow(Graphics2D graphics2D) {
        graphics2D.fillRect(4, this.height, this.width, 4);
        graphics2D.fillRect(this.width, 4, 4, this.height);
        if (!PrefMgr.isUML()) {
            Utility.drawThickLine(graphics2D, this.width - 20, this.height, this.width, this.height - 20, 3);
        }
    }

    void drawBorders(Graphics2D graphics2D) {
        int n = (this.flags & 1) == 0 ? 1 : 4;
        Utility.drawThickRect(graphics2D, 0, 0, this.width, this.height, n);
        if (PrefMgr.isUML() && (this.flags & 1) == 0) {
            return;
        }
        graphics2D.drawLine(this.width - 20 - 2, this.height, this.width, this.height - 20 - 2);
        graphics2D.drawLine(this.width - 20 + 2, this.height, this.width, this.height - 20 + 2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        MemberView memberView = (MemberView)this.actions.get(actionEvent.getSource());
        String string = actionEvent.getActionCommand();
        if (memberView == null) {
            if (editStr.equals(string)) {
                this.open();
            } else if (compileStr.equals(string)) {
                this.getPackage().compile(this);
            } else if (removeStr.equals(string)) {
                this.getPackage().getEditor().raiseRemoveTargetEvent(this);
            } else {
                this.role.actionPerformed(actionEvent, this);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent, int n, int n2, GraphEditor graphEditor) {
        super.mousePressed(mouseEvent, n, n2, graphEditor);
        this.anchor_x = this.last_x = n;
        this.anchor_y = this.last_y = n2;
    }

    public void singleClick(MouseEvent mouseEvent, int n, int n2, GraphEditor graphEditor) {
    }

    public void doubleClick(MouseEvent mouseEvent, int n, int n2, GraphEditor graphEditor) {
        this.open();
    }

    public void mouseDragged(MouseEvent mouseEvent, int n, int n2, GraphEditor graphEditor) {
        if (this.getPackage().getState() == 2 || this.getPackage().getState() == 4) {
            Graphics graphics = graphEditor.getGraphics();
            graphics.setColor(colBorder);
            graphics.setXORMode(graphbg);
            graphics.drawLine(this.anchor_x, this.anchor_y, this.last_x, this.last_y);
            graphics.drawLine(this.anchor_x, this.anchor_y, n, n2);
            this.last_x = n;
            this.last_y = n2;
        } else {
            super.mouseDragged(mouseEvent, n, n2, graphEditor);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent, int n, int n2, GraphEditor graphEditor) {
        if (this.getPackage().getState() != 0) {
            Graphics graphics = graphEditor.getGraphics();
            graphics.setColor(colBorder);
            graphics.setXORMode(graphbg);
            graphics.drawLine(this.anchor_x, this.anchor_y, this.last_x, this.last_y);
            graphics.drawLine(this.anchor_x, this.anchor_y, n, n2);
            this.last_x = n;
            this.last_y = n2;
        } else {
            super.mouseMoved(mouseEvent, n, n2, graphEditor);
        }
    }

    public void prepareForRemoval() {
        if (this.editor != null) {
            this.editor.close();
        }
        this.removeAllInDependencies();
        this.removeAllOutDependencies();
        this.prepareFilesForRemoval();
    }

    public void prepareFilesForRemoval() {
        this.role.prepareFilesForRemoval(this.getSourceFile().getPath(), this.getClassFile().getPath(), this.getContextFile().getPath());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ClassTarget(Package package_, String string) {
        this(package_, string, null);
    }

    public ClassTarget(Package package_, String string, String string2) {
        super(package_, string);
        boolean bl = string2 != null && string2.startsWith(APPLET_LABEL);
        boolean bl2 = string2 != null && string2.startsWith(ABSTRACT_CLASS_LABEL);
        boolean bl3 = string2 != null && string2.startsWith(INTERFACE_LABEL);
        this.role = bl ? new AppletClassRole() : new StdClassRole();
        this.setInterface(bl3);
        this.setAbstract(bl2);
        this.template = string2;
    }

    private class CallAction
    extends AbstractAction {
        private CallableView cv;
        private Target t;

        public void actionPerformed(ActionEvent actionEvent) {
            if (ClassTarget.this.state != 0) {
                Debug.reportError("Can't instantiate modified class");
                return;
            }
            ClassTarget.this.getPackage().getEditor().raiseMethodCallEvent(this.t, this.cv);
        }

        public CallAction(String string, Target target, CallableView callableView) {
            super(string);
            this.cv = callableView;
            this.t = target;
        }
    }
}

