/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.graph.Edge;
import bluej.pkgmgr.DependentTarget;
import bluej.pkgmgr.Package;
import bluej.utility.Debug;
import java.awt.Graphics2D;
import java.util.Hashtable;
import java.util.Properties;

public abstract class Dependency
extends Edge {
    Package pkg;

    public boolean equals(Object object) {
        if (!(object instanceof Dependency)) {
            return false;
        }
        Dependency dependency = (Dependency)object;
        return dependency != null && dependency.from == this.from && dependency.to == this.to;
    }

    public int hashCode() {
        return this.to.hashCode() - this.from.hashCode();
    }

    public DependentTarget getFrom() {
        return (DependentTarget)this.from;
    }

    public DependentTarget getTo() {
        return (DependentTarget)this.to;
    }

    public void load(Properties properties, String string) {
        String string2 = properties.getProperty(string + ".from");
        this.from = this.pkg.getTarget(string2);
        if (this.from == null) {
            Debug.reportError("Failed to find 'from' target " + string2);
        }
        String string3 = properties.getProperty(string + ".to");
        this.to = this.pkg.getTarget(string3);
        if (this.to == null) {
            Debug.reportError("Failed to find 'to' target " + string3);
        }
    }

    public void save(Properties properties, String string) {
        ((Hashtable)properties).put(string + ".from", ((DependentTarget)this.from).getIdentifierName());
        ((Hashtable)properties).put(string + ".to", ((DependentTarget)this.to).getIdentifierName());
    }

    public abstract void draw(Graphics2D var1);

    public abstract boolean contains(int var1, int var2);

    public abstract void highlight(Graphics2D var1);

    public String toString() {
        return this.getFrom().getIdentifierName() + " --> " + this.getTo().getIdentifierName();
    }

    public Dependency(Package package_, DependentTarget dependentTarget, DependentTarget dependentTarget2) {
        super(dependentTarget, dependentTarget2);
        this.pkg = package_;
    }

    public Dependency(Package package_) {
        this(package_, null, null);
    }
}

