/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.graph.GraphEditor;
import bluej.pkgmgr.Dependency;
import bluej.pkgmgr.ExtendsDependency;
import bluej.pkgmgr.ImplementsDependency;
import bluej.pkgmgr.LayoutComparer;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Target;
import bluej.pkgmgr.UsesDependency;
import bluej.utility.MultiEnumeration;
import bluej.utility.SortableVector;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;

public abstract class DependentTarget
extends Target {
    protected SortableVector inUses = new SortableVector();
    protected SortableVector outUses = new SortableVector();
    protected Vector parents = new Vector();
    protected Vector children = new Vector();

    public void addDependencyOut(Dependency dependency, boolean bl) {
        if (dependency instanceof UsesDependency) {
            this.outUses.addElement(dependency);
            if (bl) {
                this.recalcOutUses();
            }
        } else if (dependency instanceof ExtendsDependency || dependency instanceof ImplementsDependency) {
            this.parents.addElement(dependency);
        }
        if (bl) {
            this.setState(1);
        }
    }

    public void addDependencyIn(Dependency dependency, boolean bl) {
        if (dependency instanceof UsesDependency) {
            this.inUses.addElement(dependency);
            if (bl) {
                this.recalcInUses();
            }
        } else if (dependency instanceof ExtendsDependency || dependency instanceof ImplementsDependency) {
            this.children.addElement(dependency);
        }
    }

    public void removeDependencyOut(Dependency dependency, boolean bl) {
        if (dependency instanceof UsesDependency) {
            this.outUses.removeElement(dependency);
            if (bl) {
                this.recalcOutUses();
            }
        } else if (dependency instanceof ExtendsDependency || dependency instanceof ImplementsDependency) {
            this.parents.removeElement(dependency);
        }
        if (bl) {
            this.setState(1);
        }
    }

    public void removeDependencyIn(Dependency dependency, boolean bl) {
        if (dependency instanceof UsesDependency) {
            this.inUses.removeElement(dependency);
            if (bl) {
                this.recalcInUses();
            }
        } else if (dependency instanceof ExtendsDependency || dependency instanceof ImplementsDependency) {
            this.children.removeElement(dependency);
        }
    }

    public Enumeration dependencies() {
        Vector vector = new Vector(2);
        vector.addElement(this.parents.elements());
        vector.addElement(this.outUses.elements());
        return new MultiEnumeration(vector);
    }

    public Enumeration dependents() {
        Vector vector = new Vector(2);
        vector.addElement(this.children.elements());
        vector.addElement(this.inUses.elements());
        return new MultiEnumeration(vector);
    }

    protected void removeAllOutDependencies() {
        if (!this.outUses.isEmpty()) {
            Object[] objectArray = new Dependency[this.outUses.size()];
            this.outUses.copyInto(objectArray);
            int n = 0;
            while (n < objectArray.length) {
                this.getPackage().removeDependency((Dependency)objectArray[n], false);
                ++n;
            }
        }
        this.removeInheritDependencies();
    }

    protected void removeInheritDependencies() {
        if (!this.parents.isEmpty()) {
            Object[] objectArray = new Dependency[this.parents.size()];
            this.parents.copyInto(objectArray);
            int n = 0;
            while (n < objectArray.length) {
                this.getPackage().removeDependency((Dependency)objectArray[n], false);
                ++n;
            }
        }
    }

    protected void removeAllInDependencies() {
        int n;
        Object[] objectArray;
        if (!this.inUses.isEmpty()) {
            objectArray = new Dependency[this.inUses.size()];
            this.inUses.copyInto(objectArray);
            n = 0;
            while (n < objectArray.length) {
                this.getPackage().removeDependency((Dependency)objectArray[n], false);
                ++n;
            }
        }
        if (!this.children.isEmpty()) {
            objectArray = new Dependency[this.children.size()];
            this.children.copyInto(objectArray);
            n = 0;
            while (n < objectArray.length) {
                this.getPackage().removeDependency((Dependency)objectArray[n], false);
                ++n;
            }
        }
    }

    public void recalcOutUses() {
        int n;
        this.outUses.sort(new LayoutComparer(this, false));
        int n2 = this.y + this.height / 2;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.outUses.size() - 1;
        while (n5 >= 0) {
            DependentTarget dependentTarget = ((Dependency)this.outUses.elementAt(n5)).getTo();
            n = dependentTarget.y + dependentTarget.height / 2;
            if (n < n2) {
                ++n3;
            } else {
                ++n4;
            }
            --n5;
        }
        n5 = this.x + (this.width - (n3 - 1) * 5) / 2;
        int n6 = this.x + (this.width - (n4 - 1) * 5) / 2;
        n = 0;
        while (n < n3 + n4) {
            UsesDependency usesDependency = (UsesDependency)this.outUses.elementAt(n);
            int n7 = usesDependency.getTo().y + usesDependency.getTo().height / 2;
            if (n7 < n2) {
                usesDependency.setSourceCoords(n5, this.y - 4, true);
                n5 += 5;
            } else {
                usesDependency.setSourceCoords(n6, this.y + this.height + 4, false);
                n6 += 5;
            }
            ++n;
        }
    }

    public void recalcInUses() {
        int n;
        this.inUses.sort(new LayoutComparer(this, true));
        int n2 = this.x + this.width / 2;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.inUses.size() - 1;
        while (n5 >= 0) {
            DependentTarget dependentTarget = ((Dependency)this.inUses.elementAt(n5)).getFrom();
            n = dependentTarget.x + dependentTarget.width / 2;
            if (n < n2) {
                ++n3;
            } else {
                ++n4;
            }
            --n5;
        }
        n5 = this.y + (this.height - (n3 - 1) * 10) / 2;
        int n6 = this.y + (this.height - (n4 - 1) * 10) / 2;
        n = 0;
        while (n < n3 + n4) {
            UsesDependency usesDependency = (UsesDependency)this.inUses.elementAt(n);
            int n7 = usesDependency.getFrom().x + usesDependency.getFrom().width / 2;
            if (n7 < n2) {
                usesDependency.setDestCoords(this.x - 4, n5, true);
                n5 += 10;
            } else {
                usesDependency.setDestCoords(this.x + this.width + 4, n6, false);
                n6 += 10;
            }
            ++n;
        }
    }

    protected void unflagAllOutDependencies() {
        int n = 0;
        while (n < this.outUses.size()) {
            ((UsesDependency)this.outUses.elementAt(n)).setFlag(false);
            ++n;
        }
    }

    public Point getAttachment(double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = d2 / d3;
        double d5 = (double)this.height / (double)this.width;
        double d6 = Math.abs(d4) < d5 ? 0.5 * (double)this.width / Math.abs(d3) : 0.5 * (double)this.height / Math.abs(d2);
        Point point = new Point(this.x + this.width / 2 + (int)(d6 * d3), this.y + this.height / 2 - (int)(d6 * d2));
        if (-d5 < d4 && d4 < d5 && d3 > 0.0) {
            point.x += 4;
        }
        if (Math.abs(d4) > d5 && d2 < 0.0 && point.x > this.x + 4) {
            point.y += 4;
        }
        return point;
    }

    abstract Color getBackgroundColour();

    abstract Color getBorderColour();

    abstract Color getTextColour();

    abstract Font getFont();

    public void repaint() {
        if (this.getPackage().getEditor() != null) {
            this.getPackage().getEditor().repaint(this.x, this.y, this.width + 4, this.height + 4);
        }
    }

    public void mousePressed(MouseEvent mouseEvent, int n, int n2, GraphEditor graphEditor) {
        super.mousePressed(mouseEvent, n, n2, graphEditor);
    }

    public void mouseReleased(MouseEvent mouseEvent, int n, int n2, GraphEditor graphEditor) {
        Rectangle rectangle = new Rectangle(this.x, this.y, this.width, this.height);
        super.mouseReleased(mouseEvent, n, n2, graphEditor);
        if (!rectangle.equals(this.oldRect)) {
            Dependency dependency;
            this.recalcInUses();
            this.recalcOutUses();
            Enumeration enumeration = this.inUses.elements();
            while (enumeration.hasMoreElements()) {
                dependency = (Dependency)enumeration.nextElement();
                dependency.getFrom().recalcOutUses();
            }
            enumeration = this.outUses.elements();
            while (enumeration.hasMoreElements()) {
                dependency = (Dependency)enumeration.nextElement();
                dependency.getTo().recalcInUses();
            }
            graphEditor.revalidate();
            graphEditor.repaint();
        }
    }

    public String toString() {
        return this.getDisplayName();
    }

    public DependentTarget(Package package_, String string) {
        super(package_, string);
    }
}

