/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJEvent;
import bluej.Config;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.Utility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;

public class DocuGenerator {
    private static String docDirName = Config.getPropString("doctool.outputdir");
    private static String projectLogHeader = Config.getPropString("Project documentation");
    private static String classLogHeader = Config.getPropString("Class documentation");
    private static File docTempDir;
    private static String docCommand;
    private static String fixedJavadocParams;
    private static String tmpJavadocParams;
    private static Project project;
    private static File projectDir;
    private static String projectDirPath;
    private static File docDir;
    private static String docDirPath;
    private String destinationParam;
    private String sourceParam;
    private String titleParams;

    public static void generateClassDocu(String string) {
        String string2;
        if (docDir == null) {
            BlueJEvent.raiseEvent(7, null);
        }
        if ((string2 = DocuGenerator.testDocDir()) != "") {
            BlueJEvent.raiseEvent(7, null);
        }
        String string3 = docCommand + fixedJavadocParams + tmpJavadocParams + " -d " + docDir.getPath() + " " + string;
        File file = new File(DocuGenerator.getDocuPath(string));
        File file2 = new File(docDir, "logfile");
        DocuGenerator.generateDoc(string3, file, file2, classLogHeader, false);
    }

    public static String getDocuPath(String string) {
        if (string.startsWith(projectDirPath)) {
            string = string.substring(projectDirPath.length());
        }
        if (string.endsWith(".java")) {
            string = string.substring(0, string.indexOf(".java"));
        }
        return docDirPath + string + ".html";
    }

    private static File getDocTempDir() {
        if (docTempDir == null) {
            try {
                docTempDir = File.createTempFile("bluej", "tmp");
            }
            catch (IOException iOException) {
                return null;
            }
            docTempDir.delete();
            docTempDir.mkdir();
        } else {
            FileUtility.deleteDir(docTempDir);
            docTempDir.mkdir();
        }
        return docTempDir;
    }

    private static void generateDoc(String string, File file, File file2, String string2, boolean bl) {
        Thread thread = new Thread(new DocuRunStarter(string, file, file2, string2, bl));
        thread.setPriority(1);
        thread.start();
        BlueJEvent.raiseEvent(5, null);
    }

    public String generateProjectDocu() {
        Object object;
        Object object2;
        String string = DocuGenerator.testDocDir();
        if (string != "") {
            return string;
        }
        File file = new File(docDir, "index.html");
        File file2 = new File(docDir, "logfile");
        if (DocuGenerator.documentationExists(file2)) {
            int n = DialogManager.askQuestion(null, "show-or-generate");
            if (n == 0) {
                Utility.openWebBrowser(file.getPath());
                return "";
            }
            if (n == 2) {
                return "";
            }
        }
        List list = project.getPackageNames();
        StringBuffer stringBuffer = new StringBuffer();
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            object = project.getPackage((String)object2);
            if (!FileUtility.containsFile(((Package)object).getPath(), ".java")) continue;
            stringBuffer.append(" ");
            stringBuffer.append((String)object2);
        }
        object3 = project.getPackage(project.getInitialPackageName()).getAllClassnames();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            stringBuffer.append(" ");
            stringBuffer.append((String)object2.next());
        }
        object2 = new String(stringBuffer);
        object = this.getLinkParam();
        String string2 = docCommand + this.sourceParam + this.destinationParam + this.titleParams + (String)object + fixedJavadocParams + (String)object2;
        DocuGenerator.generateDoc(string2, file, file2, projectLogHeader, true);
        return "";
    }

    private static String testDocDir() {
        if (docDir.exists()) {
            if (!docDir.isDirectory()) {
                return DialogManager.getMessage("docdir-blocked-by-file");
            }
        } else {
            try {
                if (!docDir.mkdir()) {
                    return DialogManager.getMessage("docdir-not-created");
                }
            }
            catch (SecurityException securityException) {
                return DialogManager.getMessage("no-permission-for-docdir");
            }
        }
        return "";
    }

    private static boolean documentationExists(File file) {
        if (!file.exists()) {
            return false;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine();
            return string.equals(projectLogHeader);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String getLinkParam() {
        String string = Config.getPropString("doctool.linkToStandardLib");
        if (string.equals("true")) {
            String string2 = Config.getPropString("bluej.url.javaStdLib");
            if (string2.endsWith("index.html")) {
                string2 = string2.substring(0, string2.indexOf("index.html"));
            }
            return " -link " + string2;
        }
        return "";
    }

    public DocuGenerator(Project project) {
        DocuGenerator.project = project;
        projectDir = project.getProjectDir();
        projectDirPath = projectDir.getPath();
        docDir = new File(projectDir, docDirName);
        docDirPath = docDir.getPath();
        this.destinationParam = " -d " + docDirPath;
        this.sourceParam = " -sourcepath " + projectDirPath;
        this.titleParams = " -doctitle " + project.getProjectName() + " -windowtitle " + project.getProjectName();
    }

    static {
        docCommand = Config.getPropString("doctool.command");
        fixedJavadocParams = " -author -version -nodeprecated -package -bottom <small><em>Generated&nbsp;by&nbsp;BlueJ</em></small>";
        tmpJavadocParams = " -noindex -notree -nohelp -nonavbar";
    }

    private static class DocuRunStarter
    implements Runnable {
        private String docuCall;
        private File showFile;
        private File logFile;
        private String logHeader;
        private boolean openBrowser;

        public void run() {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.logFile);
                PrintWriter printWriter = new PrintWriter(fileOutputStream, true);
                printWriter.println(this.logHeader);
                printWriter.println(this.docuCall);
                printWriter.flush();
                Process process = Runtime.getRuntime().exec(this.docuCall);
                EchoThread echoThread = new EchoThread(process.getInputStream(), fileOutputStream);
                EchoThread echoThread2 = new EchoThread(process.getErrorStream(), fileOutputStream);
                echoThread.start();
                echoThread2.start();
                try {
                    process.waitFor();
                    echoThread.join();
                    echoThread2.join();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("Interrupted waiting for process");
                }
                if (process.exitValue() == 0) {
                    BlueJEvent.raiseEvent(6, null);
                    if (!this.showFile.exists()) {
                        Debug.message("showfile does not exist - searching");
                        this.showFile = FileUtility.findFile(this.showFile.getParentFile(), this.showFile.getName());
                    }
                    if (this.openBrowser) {
                        Utility.openWebBrowser(this.showFile.getPath());
                    }
                } else {
                    BlueJEvent.raiseEvent(7, null);
                    DialogManager.showMessageWithText(null, "doctool-error", this.logFile.getPath());
                }
            }
            catch (IOException iOException) {
                DialogManager.showMessage(null, "severe-doc-trouble");
            }
        }

        public DocuRunStarter(String string, File file, File file2, String string2, boolean bl) {
            this.docuCall = string;
            this.showFile = file;
            this.logFile = file2;
            this.logHeader = string2;
            this.openBrowser = bl;
        }

        private static class EchoThread
        extends Thread {
            private InputStream readStream;
            private OutputStream outStream;
            private byte[] lastBuf;

            public void run() {
                try {
                    int n;
                    byte[] byArray = new byte[1000];
                    while ((n = this.readStream.read(byArray)) != -1) {
                        this.outStream.write(byArray, 0, n);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }

            public EchoThread(InputStream inputStream, OutputStream outputStream) {
                this.readStream = inputStream;
                this.outStream = outputStream;
            }
        }
    }
}

