/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefMgr;
import bluej.utility.DialogManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class ExportDialog
extends JDialog
implements ActionListener {
    private static final String cont = Config.getString("continue");
    private static final String cancel = Config.getString("cancel");
    private static final String dialogTitle = Config.getString("pkgmgr.export.title");
    private static final String helpLine1 = Config.getString("pkgmgr.export.helpLine1");
    private static final String helpLine2 = Config.getString("pkgmgr.export.helpLine2");
    private static final String directoryLabel = Config.getString("pkgmgr.export.directoryLabel");
    private static final String jarFileLabel = Config.getString("pkgmgr.export.jarFileLabel");
    private static final String classLabelText = Config.getString("pkgmgr.export.classLabel");
    private static final String sourceLabel = Config.getString("pkgmgr.export.sourceLabel");
    private static final String noClassText = Config.getString("pkgmgr.export.noClassText");
    private static final Color envOpColour = Config.getItemColour("colour.menu.environOp");
    private String mainClassName = null;
    private JRadioButton directoryButton;
    private JRadioButton jarButton;
    private JComboBox classSelect;
    private JCheckBox sourceBox;
    private boolean ok;
    private Project project;

    public boolean display() {
        this.ok = false;
        ((Component)this).setVisible(true);
        return this.ok;
    }

    public String getMainClass() {
        return this.mainClassName;
    }

    public boolean saveAsJar() {
        return this.jarButton.isSelected();
    }

    public boolean includeSource() {
        return this.sourceBox.isSelected();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (cont.equals(string)) {
            this.doOK();
        } else if (cancel.equals(string)) {
            this.doCancel();
        }
    }

    private void doOK() {
        this.mainClassName = (String)this.classSelect.getSelectedItem();
        if (this.mainClassName.equals(noClassText)) {
            this.mainClassName = null;
        }
        this.ok = true;
        ((Component)this).setVisible(false);
    }

    private void doCancel() {
        this.ok = false;
        ((Component)this).setVisible(false);
    }

    private void makeDialog() {
        this.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(Config.dialogBorder);
        JLabel jLabel = new JLabel(helpLine1);
        jPanel.add(jLabel);
        JLabel jLabel2 = new JLabel(helpLine2);
        jPanel.add(jLabel2);
        Font font = jLabel.getFont().deriveFont(10);
        jLabel.setFont(font);
        jLabel2.setFont(font);
        jPanel.add(Box.createVerticalStrut(5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setAlignmentX(0.0f);
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        this.directoryButton = new JRadioButton(directoryLabel, true);
        this.directoryButton.setAlignmentX(0.0f);
        this.jarButton = new JRadioButton(jarFileLabel, false);
        this.jarButton.setAlignmentX(0.0f);
        Serializable serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this.directoryButton);
        ((ButtonGroup)serializable).add(this.jarButton);
        jPanel2.add(this.directoryButton);
        jPanel2.add(this.jarButton);
        jPanel2.add(Box.createVerticalStrut(5));
        JComponent jComponent = new JLabel(classLabelText);
        jComponent.setAlignmentX(0.0f);
        jPanel2.add(jComponent);
        this.classSelect = new JComboBox();
        this.classSelect.setAlignmentX(0.0f);
        this.makeClassPopup(this.classSelect);
        jPanel2.add(this.classSelect);
        jPanel2.add(Box.createVerticalStrut(5));
        this.sourceBox = new JCheckBox(sourceLabel, true);
        this.sourceBox.setAlignmentX(0.0f);
        jPanel2.add(this.sourceBox);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(17));
        serializable = new JPanel(new FlowLayout(2));
        ((JComponent)serializable).setAlignmentX(0.0f);
        jComponent = new JButton(cont);
        ((AbstractButton)jComponent).addActionListener(this);
        JButton jButton = new JButton(cancel);
        jButton.addActionListener(this);
        ((Container)serializable).add(jComponent);
        ((Container)serializable).add(jButton);
        this.getRootPane().setDefaultButton((JButton)jComponent);
        jButton.setPreferredSize(new Dimension(jComponent.getPreferredSize().width, jButton.getPreferredSize().height));
        jPanel.add((Component)serializable);
        this.getContentPane().add(jPanel);
        this.pack();
        DialogManager.centreDialog(this);
    }

    private void makeClassPopup(JComboBox jComboBox) {
        jComboBox.setFont(PrefMgr.getPopupMenuFont());
        jComboBox.addItem(noClassText);
        List list = this.project.getPackageNames();
        Collections.sort(list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2;
            String string = (String)iterator.next();
            Vector vector = this.project.getPackage(string).getAllClassnames();
            Collections.sort(vector);
            if (string.length() > 0) {
                iterator2 = vector.iterator();
                while (iterator2.hasNext()) {
                    jComboBox.addItem(string + "." + iterator2.next());
                }
                continue;
            }
            iterator2 = vector.iterator();
            while (iterator2.hasNext()) {
                jComboBox.addItem(iterator2.next());
            }
        }
    }

    public ExportDialog(PkgMgrFrame pkgMgrFrame) {
        super(pkgMgrFrame, dialogTitle, true);
        this.project = pkgMgrFrame.getProject();
        this.makeDialog();
    }
}

