/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.pkgmgr.ExportDialog;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.utility.BlueJFileReader;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

final class ExportManager {
    private static final String[] skipDirs = new String[]{"CVS"};
    private PkgMgrFrame frame;

    public void export() {
        ExportDialog exportDialog = new ExportDialog(this.frame);
        boolean bl = exportDialog.display();
        if (!bl) {
            return;
        }
        String string = exportDialog.saveAsJar() ? FileUtility.getFileName(this.frame, "Specify name for jar file", "Create", false) : FileUtility.getFileName(this.frame, "Specify name for export directory", "Create", false);
        if (string == null) {
            return;
        }
        String string2 = this.frame.getProject().getProjectDir().getPath();
        if (exportDialog.saveAsJar()) {
            this.exportJar(string2, string, exportDialog.getMainClass(), exportDialog.includeSource());
        } else {
            this.exportDir(string2, string, exportDialog.getMainClass(), false, exportDialog.includeSource(), "error-exporting");
        }
    }

    public void saveAs(String string, String string2) {
        this.exportDir(string, string2, null, true, true, "cannot-copy-package");
    }

    /*
     * Loose catch block
     */
    private void exportJar(String string, String string2, String string3, boolean bl) {
        block13: {
            File file;
            if (!string2.endsWith(".jar")) {
                string2 = string2 + ".jar";
            }
            if ((file = new File(string2)).exists() && DialogManager.askQuestion(this.frame, "error-jar-exists") != 0) {
                return;
            }
            FileOutputStream fileOutputStream = null;
            ZipOutputStream zipOutputStream = null;
            Object object2222 = new Manifest();
            Attributes attributes = ((Manifest)object2222).getMainAttributes();
            attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            attributes.put(Attributes.Name.MAIN_CLASS, string3);
            fileOutputStream = new FileOutputStream(file);
            zipOutputStream = string3 != null && string3.length() > 0 ? new JarOutputStream((OutputStream)fileOutputStream, (Manifest)object2222) : new JarOutputStream(fileOutputStream);
            this.writeDirToJar(new File(string), "", (JarOutputStream)zipOutputStream, bl, file.getCanonicalFile());
            this.frame.setStatus(Config.getString("pkgmgr.exported.jar"));
            Object var9_13 = null;
            try {
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
                break block13;
            }
            catch (IOException object2222) {}
            break block13;
            {
                catch (IOException iOException) {
                    DialogManager.showError(this.frame, "error-writing-jar");
                    Debug.reportError("problen writing jar file: " + iOException);
                    Object var9_14 = null;
                    try {
                        if (zipOutputStream != null) {
                            zipOutputStream.close();
                        }
                        break block13;
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                try {
                    if (zipOutputStream != null) {
                        zipOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void writeDirToJar(File file, String string, JarOutputStream jarOutputStream, boolean bl, File file2) throws IOException {
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory()) {
                if (!this.skipDir(fileArray[n])) {
                    this.writeDirToJar(fileArray[n], string + fileArray[n].getName() + "/", jarOutputStream, bl, file2);
                }
            } else if (!FileUtility.skipFile(fileArray[n].getName(), true, !bl) && !file2.equals(fileArray[n].getCanonicalFile())) {
                this.writeJarEntry(fileArray[n], jarOutputStream, string + fileArray[n].getName());
            }
            ++n;
        }
    }

    private boolean skipDir(File file) {
        int n = 0;
        while (n < skipDirs.length) {
            if (file.getName().equals(skipDirs[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void writeJarEntry(File file, JarOutputStream jarOutputStream, String string) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            jarOutputStream.putNextEntry(new ZipEntry(string));
            FileUtility.copyStream(fileInputStream, jarOutputStream);
        }
        finally {
            Object var6_5 = null;
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    private void exportDir(String string, String string2, String string3, boolean bl, boolean bl2, String string4) {
        int n = FileUtility.copyDirectory(string, string2, !bl, !bl2);
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                DialogManager.showError(this.frame, "directory-exists");
                return;
            }
            case 2: 
            case 3: {
                DialogManager.showError(this.frame, string4);
                return;
            }
        }
        this.writeReadMe(string2, string3);
        this.frame.setStatus(Config.getString("pkgmgr.exported"));
    }

    private void writeReadMe(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return;
        }
        try {
            String string3 = string + File.separator + "README.TXT";
            File file = new File(string3);
            File file2 = File.createTempFile("bluej", "txt");
            FileUtility.copyFile(file, file2);
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("MAINCLASS", string2);
            File file3 = Config.getTemplateFile("readmeexp");
            BlueJFileReader.translateFile(file3, file, hashtable);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string3, true));
            FileUtility.copyStream(bufferedInputStream, bufferedOutputStream);
            ((InputStream)bufferedInputStream).close();
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            DialogManager.showError(this.frame, "error-writing-readme");
            Debug.reportError("README file could not be updated. " + iOException);
        }
    }

    public ExportManager(PkgMgrFrame pkgMgrFrame) {
        this.frame = pkgMgrFrame;
    }
}

