/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.pkgmgr.Dependency;
import bluej.pkgmgr.DependentTarget;
import bluej.pkgmgr.Package;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Utility;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.Hashtable;
import java.util.Properties;

public class ImplementsDependency
extends Dependency {
    static final Color normalColour = Config.getItemColour("colour.arrow.implements");
    static final Color umlColour = Config.getItemColour("colour.uml.arrow.implements");
    static final Color bgGraph = Config.getItemColour("colour.graph.background");
    static final int ARROW_SIZE = 12;
    static final int UML_ARROW_SIZE = 18;
    static final double ARROW_ANGLE = 0.5235987755982988;
    static final int SELECT_DIST = 4;
    private static final float[] dash1 = new float[]{5.0f, 2.0f};
    private static final BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);

    void draw(Color color, Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(color);
        Point point = new Point(this.from.x + this.from.width / 2, this.from.y + this.from.height / 2);
        Point point2 = new Point(this.to.x + this.to.width / 2, this.to.y + this.to.height / 2);
        double d = Math.atan2(-(point.y - point2.y), point.x - point2.x);
        point = ((DependentTarget)this.from).getAttachment(d + Math.PI);
        point2 = ((DependentTarget)this.to).getAttachment(d);
        int n = PrefMgr.isUML() ? 18 : 12;
        Point point3 = new Point(point2.x + (int)((double)(n - 2) * Math.cos(d)), point2.y - (int)((double)(n - 2) * Math.sin(d)));
        int[] nArray = new int[]{point2.x, point2.x + (int)((double)n * Math.cos(d + 0.5235987755982988)), point2.x + (int)((double)n * Math.cos(d - 0.5235987755982988))};
        int[] nArray2 = new int[]{point2.y, point2.y - (int)((double)n * Math.sin(d + 0.5235987755982988)), point2.y - (int)((double)n * Math.sin(d - 0.5235987755982988))};
        if (PrefMgr.isUML()) {
            graphics2D.drawPolygon(nArray, nArray2, 3);
            graphics2D.setStroke(dashed);
            graphics2D.drawLine(point.x, point.y, point3.x, point3.y);
        } else {
            Utility.drawThickLine(graphics2D, point.x, point.y, point3.x, point3.y, 5);
            graphics2D.fillPolygon(nArray, nArray2, 3);
            graphics2D.setColor(bgGraph);
            graphics2D.drawLine(point.x, point.y, point3.x, point3.y);
        }
    }

    public void draw(Graphics2D graphics2D) {
        if (PrefMgr.isUML()) {
            this.draw(umlColour, graphics2D);
        } else {
            this.draw(normalColour, graphics2D);
        }
    }

    public boolean contains(int n, int n2) {
        Point point = new Point(this.from.x + this.from.width / 2, this.from.y + this.from.height / 2);
        Point point2 = new Point(this.to.x + this.to.width / 2, this.to.y + this.to.height / 2);
        double d = Math.atan2(-(point.y - point2.y), point.x - point2.x);
        point = ((DependentTarget)this.from).getAttachment(d + Math.PI);
        point2 = ((DependentTarget)this.to).getAttachment(d);
        if (n < Math.min(point.x, point2.x) - 4 || n > Math.max(point.x, point2.x) + 4 || n2 < Math.min(point.y, point2.y) - 4 || n2 > Math.max(point.y, point2.y) + 4) {
            return false;
        }
        double d2 = Math.atan2(-(point.y - n2), point.x - n);
        double d3 = ImplementsDependency.normDist(point.x, point.y, n, n2, Math.sin(d - d2));
        return d3 < 16.0;
    }

    static final double normDist(int n, int n2, int n3, int n4, double d) {
        return (double)((n - n3) * (n - n3) + (n2 - n4) * (n2 - n4)) * d * d;
    }

    static final int normDist(Point point, Point point2) {
        return (point.x - point2.x) * (point.x - point2.x) + (point.y - point2.y) * (point.y - point2.y);
    }

    public void highlight(Graphics2D graphics2D) {
        graphics2D.setXORMode(Color.red);
        this.draw(normalColour, graphics2D);
        graphics2D.setPaintMode();
    }

    public void load(Properties properties, String string) {
        super.load(properties, string);
    }

    public void save(Properties properties, String string) {
        super.save(properties, string);
        ((Hashtable)properties).put(string + ".type", "ImplementsDependency");
    }

    public ImplementsDependency(Package package_, DependentTarget dependentTarget, DependentTarget dependentTarget2) {
        super(package_, dependentTarget, dependentTarget2);
    }

    public ImplementsDependency(Package package_) {
        this(package_, null, null);
    }
}

