/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.compiler.CompileObserver;
import bluej.compiler.JobQueue;
import bluej.debugger.CallHistory;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerClassLoader;
import bluej.debugger.DebuggerThread;
import bluej.debugger.ExecControls;
import bluej.debugger.SourceLocation;
import bluej.editor.Editor;
import bluej.editor.EditorManager;
import bluej.graph.Graph;
import bluej.graph.Vertex;
import bluej.parser.ClassParser;
import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.Selection;
import bluej.pkgmgr.ClassTarget;
import bluej.pkgmgr.Dependency;
import bluej.pkgmgr.DependentTarget;
import bluej.pkgmgr.EditableTarget;
import bluej.pkgmgr.ExtendsDependency;
import bluej.pkgmgr.ImplementsDependency;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.PackageTarget;
import bluej.pkgmgr.ParentPackageTarget;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.ReadmeTarget;
import bluej.pkgmgr.Target;
import bluej.pkgmgr.UsesDependency;
import bluej.utility.Debug;
import bluej.utility.FileUtility;
import bluej.utility.JavaNames;
import bluej.utility.MultiEnumeration;
import bluej.utility.SortedProperties;
import bluej.utility.filefilter.JavaClassFilter;
import bluej.utility.filefilter.JavaSourceFilter;
import bluej.utility.filefilter.SubPackageFilter;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;

public class Package
extends Graph
implements CompileObserver,
MouseListener,
MouseMotionListener {
    static final String compiling = Config.getString("pkgmgr.compiling");
    static final String compileDone = Config.getString("pkgmgr.compileDone");
    static final String chooseUsesTo = Config.getString("pkgmgr.chooseUsesTo");
    static final String chooseInhTo = Config.getString("pkgmgr.chooseInhTo");
    public static final String pkgfileName = "bluej.pkg";
    public static final String pkgfileBackup = "bluej.pkh";
    public static final String readmeName = "README.TXT";
    public static final int NO_ERROR = 0;
    public static final int FILE_NOT_FOUND = 1;
    public static final int ILLEGAL_FORMAT = 2;
    public static final int COPY_ERROR = 3;
    public static final int CLASS_EXISTS = 4;
    public static final int CREATE_ERROR = 5;
    public static final int FIXED_TARGET_X = 10;
    public static final int FIXED_TARGET_Y = 10;
    public static EditorManager editorManager = EditorManager.getEditorManager();
    public static final int S_IDLE = 0;
    public static final int S_CHOOSE_USES_FROM = 1;
    public static final int S_CHOOSE_USES_TO = 2;
    public static final int S_CHOOSE_EXT_FROM = 3;
    public static final int S_CHOOSE_EXT_TO = 4;
    public static final int S_DELARROW = 5;
    public static final int HISTORY_LENGTH = 6;
    private Project project;
    private Package parentPackage = null;
    private String baseName = "";
    private SortedProperties lastSavedProps = new SortedProperties();
    protected Hashtable targets;
    protected Vector usesArrows;
    protected Vector extendsArrows;
    protected Target selected;
    protected DependentTarget fromChoice;
    Dependency currentArrow;
    private CallHistory callHistory;
    protected boolean showExtends = true;
    protected boolean showUses = true;
    private String lastSourceName = "";
    private int state = 0;
    protected PackageEditor editor;

    private void init() throws IOException {
        this.targets = new Hashtable();
        this.usesArrows = new Vector();
        this.extendsArrows = new Vector();
        this.selected = null;
        this.callHistory = new CallHistory(6);
        this.load();
    }

    public boolean isUnnamedPackage() {
        return this.parentPackage == null;
    }

    public Project getProject() {
        return this.project;
    }

    public String getId() {
        return this.getPath().getPath();
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getQualifiedName(String string) {
        if (this.isUnnamedPackage()) {
            return string;
        }
        return this.getQualifiedName() + "." + string;
    }

    public String getQualifiedName() {
        Package package_ = this;
        String string = "";
        while (!package_.isUnnamedPackage()) {
            string = string == "" ? package_.getBaseName() : package_.getBaseName() + "." + string;
            package_ = package_.getParent();
        }
        return string;
    }

    private File getRelativePath() {
        Package package_ = this;
        File file = new File(package_.getBaseName());
        while (!package_.isUnnamedPackage()) {
            package_ = package_.getParent();
            file = new File(package_.getBaseName(), file.getPath());
        }
        return file;
    }

    public File getPath() {
        return new File(this.project.getProjectDir(), this.getRelativePath().getPath());
    }

    protected Package getParent() {
        return this.parentPackage;
    }

    protected Package getBoringSubPackage() {
        PackageTarget packageTarget = null;
        Enumeration enumeration = this.targets.elements();
        while (enumeration.hasMoreElements()) {
            Target target = (Target)enumeration.nextElement();
            if (target instanceof ClassTarget) {
                return null;
            }
            if (!(target instanceof PackageTarget) || target instanceof ParentPackageTarget) continue;
            if (packageTarget != null) {
                return null;
            }
            packageTarget = (PackageTarget)target;
        }
        if (packageTarget == null) {
            return null;
        }
        return this.getProject().getPackage(packageTarget.getQualifiedName());
    }

    protected List getChildren() {
        ArrayList<Package> arrayList = new ArrayList<Package>();
        Enumeration enumeration = this.targets.elements();
        while (enumeration.hasMoreElements()) {
            Target target = (Target)enumeration.nextElement();
            if (!(target instanceof PackageTarget) || target instanceof ParentPackageTarget) continue;
            PackageTarget packageTarget = (PackageTarget)target;
            Package package_ = this.getProject().getPackage(packageTarget.getQualifiedName());
            if (package_ == null) continue;
            arrayList.add(package_);
        }
        if (arrayList.size() == 0) {
            arrayList = null;
        }
        return arrayList;
    }

    public void setStatus(String string) {
        PkgMgrFrame.displayMessage(this, string);
    }

    public void repaint() {
        if (this.editor != null) {
            this.editor.revalidate();
            this.editor.repaint();
        }
    }

    public PackageEditor getEditor() {
        return this.editor;
    }

    public Properties getLastSavedProperties() {
        return this.lastSavedProps;
    }

    public Target getSelectedTarget() {
        return this.selected;
    }

    private Set findTargets(File file) {
        String string;
        File[] fileArray = file.listFiles(new JavaSourceFilter());
        File[] fileArray2 = file.listFiles(new JavaClassFilter());
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].getName().startsWith("__SHELL")) {
                fileArray[n].delete();
            } else {
                string = JavaNames.stripSuffix(fileArray[n].getName(), ".java");
                if (JavaNames.isIdentifier(string) && string.indexOf(36) == -1) {
                    hashSet.add(string);
                }
            }
            ++n;
        }
        n = 0;
        while (n < fileArray2.length) {
            if (fileArray2[n].getName().startsWith("__SHELL")) {
                fileArray2[n].delete();
            } else {
                Class clazz;
                string = JavaNames.stripSuffix(fileArray2[n].getName(), ".class");
                if (JavaNames.isIdentifier(string) && string.indexOf(36) == -1 && !hashSet.contains(string) && Modifier.isPublic((clazz = this.loadClass(this.getQualifiedName(string))).getModifiers())) {
                    hashSet.add(string);
                }
            }
            ++n;
        }
        return hashSet;
    }

    private void load() throws IOException {
        Target target;
        File file = new File(this.getPath(), pkgfileName);
        FileInputStream fileInputStream = new FileInputStream(file);
        this.lastSavedProps.load(fileInputStream);
        HashMap<String, ClassTarget> hashMap = new HashMap<String, ClassTarget>();
        try {
            Object object;
            String string;
            Object object2;
            int n = Integer.parseInt(this.lastSavedProps.getProperty("package.numTargets", "0"));
            int n2 = Integer.parseInt(this.lastSavedProps.getProperty("package.numDependencies", "0"));
            int n3 = 0;
            while (n3 < n) {
                Target target2 = null;
                object2 = this.lastSavedProps.getProperty("target" + (n3 + 1) + ".type");
                string = this.lastSavedProps.getProperty("target" + (n3 + 1) + ".name");
                if ("ClassTarget".equals(object2) || "AppletTarget".equals(object2)) {
                    target2 = new ClassTarget(this, string);
                } else if ("PackageTarget".equals(object2)) {
                    target2 = new PackageTarget(this, string);
                }
                if (target2 != null) {
                    ((Target)target2).load(this.lastSavedProps, "target" + (n3 + 1));
                    hashMap.put(string, (ClassTarget)target2);
                }
                ++n3;
            }
            if (!this.isUnnamedPackage()) {
                target = new ParentPackageTarget(this);
                target.setPos(10, 10);
                this.addTarget(target);
            } else {
                target = new ReadmeTarget(this);
                target.setPos(10, 10);
                this.addTarget(target);
            }
            target = this.getPath().listFiles(new SubPackageFilter());
            int n4 = 0;
            while (n4 < ((Target)target).length) {
                if (JavaNames.isIdentifier(((File)((Object)target[n4])).getName())) {
                    object2 = (Target)hashMap.get(((File)((Object)target[n4])).getName());
                    if (object2 == null || !(object2 instanceof PackageTarget)) {
                        object2 = new PackageTarget(this, ((File)((Object)target[n4])).getName());
                        this.findSpaceForVertex((Vertex)object2);
                    }
                    this.addTarget((Target)object2);
                }
                ++n4;
            }
            Set set = this.findTargets(this.getPath());
            object2 = set.iterator();
            while (object2.hasNext()) {
                string = (String)object2.next();
                if (!JavaNames.isIdentifier(string)) continue;
                object = (Target)hashMap.get(string);
                if (object == null || !(object instanceof ClassTarget)) {
                    object = new ClassTarget(this, string);
                    this.findSpaceForVertex((Vertex)object);
                }
                try {
                    ((ClassTarget)object).enforcePackage(this.getQualifiedName());
                }
                catch (IOException iOException) {
                    Debug.message(iOException.getLocalizedMessage());
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                this.addTarget((Target)object);
            }
            int n5 = 0;
            while (n5 < n2) {
                object = null;
                String string2 = this.lastSavedProps.getProperty("dependency" + (n5 + 1) + ".type");
                if ("UsesDependency".equals(string2)) {
                    object = new UsesDependency(this);
                }
                if (object != null) {
                    ((Dependency)object).load(this.lastSavedProps, "dependency" + (n5 + 1));
                    this.addDependency((Dependency)object, false);
                }
                ++n5;
            }
            this.recalcArrows();
        }
        catch (Exception exception) {
            Debug.reportError("Error loading from bluej.pkg file " + file + ": " + exception);
            exception.printStackTrace();
            return;
        }
        Enumeration enumeration = this.targets.elements();
        while (enumeration.hasMoreElements()) {
            Target target3 = (Target)enumeration.nextElement();
            if (!(target3 instanceof ClassTarget)) continue;
            target = (ClassTarget)target3;
            ((ClassTarget)target).analyseSource(false);
        }
        enumeration = this.targets.elements();
        while (enumeration.hasMoreElements()) {
            Target target4 = (Target)enumeration.nextElement();
            if (!(target4 instanceof ClassTarget) || !((ClassTarget)target4).upToDate()) continue;
            target = (ClassTarget)target4;
            target.setState(0);
        }
    }

    public void reload() {
        ClassTarget classTarget;
        Target target;
        Object object;
        Object object2;
        File[] fileArray = this.getPath().listFiles(new SubPackageFilter());
        int n = 0;
        while (n < fileArray.length) {
            if (JavaNames.isIdentifier(fileArray[n].getName()) && (object2 = (Target)this.targets.get(fileArray[n].getName())) == null) {
                object = this.addPackage(fileArray[n].getName());
                this.findSpaceForVertex((Vertex)object);
            }
            ++n;
        }
        Set set = this.findTargets(this.getPath());
        object2 = set.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            if (!JavaNames.isIdentifier((String)object) || (target = (Target)this.targets.get(object)) != null) continue;
            classTarget = this.addClass((String)object);
            this.findSpaceForVertex(classTarget);
        }
        object = this.targets.elements();
        while (object.hasMoreElements()) {
            target = (Target)object.nextElement();
            if (!(target instanceof ClassTarget)) continue;
            classTarget = (ClassTarget)target;
            classTarget.analyseSource(false);
        }
        this.repaint();
    }

    public boolean save(Properties properties) {
        Object object;
        File file = this.getPath();
        if (!file.exists() && !file.mkdir()) {
            Debug.reportError("Error creating directory " + file);
            return false;
        }
        File file2 = new File(file, pkgfileName);
        if (!file2.canWrite()) {
            return false;
        }
        if (file2.exists()) {
            file2.renameTo(new File(this.getPath(), pkgfileBackup));
        }
        SortedProperties sortedProperties = new SortedProperties();
        if (properties != null) {
            ((Hashtable)sortedProperties).putAll(properties);
        }
        ((Hashtable)sortedProperties).put("package.numDependencies", String.valueOf(this.usesArrows.size()));
        Enumeration enumeration = this.targets.elements();
        int n = 0;
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            object = (Target)enumeration.nextElement();
            if (((Target)object).isSaveable()) {
                ((Target)object).save(sortedProperties, "target" + (n + 1));
                ++n;
            }
            ++n2;
        }
        ((Hashtable)sortedProperties).put("package.numTargets", String.valueOf(n));
        n2 = 0;
        while (n2 < this.usesArrows.size()) {
            object = (Dependency)this.usesArrows.elementAt(n2);
            ((Dependency)object).save(sortedProperties, "dependency" + (n2 + 1));
            ++n2;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            sortedProperties.store(fileOutputStream, "BlueJ package file");
        }
        catch (IOException iOException) {
            Debug.reportError("Error saving project file " + file2 + ": " + iOException);
            return false;
        }
        this.lastSavedProps = sortedProperties;
        return true;
    }

    public int importFile(File file) {
        if (!file.exists()) {
            return 1;
        }
        String string = file.getName();
        if (!string.endsWith(".java")) {
            return 2;
        }
        String string2 = string.substring(0, string.length() - 5);
        if (this.getTarget(string2) != null) {
            return 4;
        }
        File file2 = new File(this.getPath(), string);
        if (!FileUtility.copyFile(file, file2)) {
            return 3;
        }
        ClassTarget classTarget = this.addClass(string2);
        this.findSpaceForVertex(classTarget);
        classTarget.analyseSource(false);
        return 0;
    }

    public ClassTarget addClass(String string) {
        ClassTarget classTarget = new ClassTarget(this, string);
        this.addTarget(classTarget);
        try {
            classTarget.enforcePackage(this.getQualifiedName());
        }
        catch (IOException iOException) {
            Debug.message(iOException.getLocalizedMessage());
        }
        return classTarget;
    }

    public PackageTarget addPackage(String string) {
        PackageTarget packageTarget = new PackageTarget(this, string);
        this.addTarget(packageTarget);
        return packageTarget;
    }

    public DebuggerClassLoader getRemoteClassLoader() {
        return this.getProject().getRemoteClassLoader();
    }

    public Class loadClass(String string) {
        return this.getProject().loadClass(string);
    }

    public Enumeration getVertices() {
        return this.targets.elements();
    }

    public Enumeration getEdges() {
        Vector vector = new Vector();
        if (this.showUses) {
            vector.addElement(this.usesArrows.elements());
        }
        if (this.showExtends) {
            vector.addElement(this.extendsArrows.elements());
        }
        return new MultiEnumeration(vector);
    }

    public void compile() {
        if (!this.checkCompile()) {
            return;
        }
        Vector<ClassTarget> vector = new Vector<ClassTarget>();
        Enumeration enumeration = this.targets.elements();
        while (enumeration.hasMoreElements()) {
            Target target = (Target)enumeration.nextElement();
            if (!(target instanceof ClassTarget)) continue;
            ClassTarget classTarget = (ClassTarget)target;
            if (classTarget.editorOpen()) {
                classTarget.getEditor().save();
            }
            if (classTarget.getState() != 1) continue;
            vector.addElement(classTarget);
        }
        this.compileSet(vector);
    }

    public void compile(ClassTarget classTarget) {
        if (!this.checkCompile()) {
            return;
        }
        if (classTarget.editorOpen()) {
            classTarget.getEditor().save();
        }
        classTarget.setState(1);
        this.searchCompile(classTarget, 1, new Stack());
    }

    public void rebuild() {
        if (!this.checkCompile()) {
            return;
        }
        Vector<ClassTarget> vector = new Vector<ClassTarget>();
        Enumeration enumeration = this.targets.elements();
        while (enumeration.hasMoreElements()) {
            Target target = (Target)enumeration.nextElement();
            if (!(target instanceof ClassTarget)) continue;
            ClassTarget classTarget = (ClassTarget)target;
            if (classTarget.editorOpen()) {
                classTarget.getEditor().save();
            }
            classTarget.setState(1);
            classTarget.analyseSource(false);
            vector.addElement(classTarget);
        }
        this.doCompile(vector);
    }

    private void compileSet(Vector vector) {
        int n = vector.size() - 1;
        while (n >= 0) {
            this.searchCompile((ClassTarget)vector.elementAt(n), 1, new Stack());
            --n;
        }
    }

    private void searchCompile(ClassTarget classTarget, int n, Stack stack) {
        ClassTarget classTarget2;
        Object object;
        if (classTarget.getState() != 1 || classTarget.isFlagSet(2)) {
            return;
        }
        classTarget.setFlag(2);
        classTarget.dfn = n;
        classTarget.link = n;
        stack.push(classTarget);
        Enumeration enumeration = classTarget.dependencies();
        while (enumeration.hasMoreElements()) {
            object = (Dependency)enumeration.nextElement();
            if (!(((Dependency)object).getTo() instanceof ClassTarget)) continue;
            classTarget2 = (ClassTarget)((Dependency)object).getTo();
            if (classTarget2.isFlagSet(2)) {
                if (classTarget2.dfn >= classTarget.dfn || stack.search(classTarget2) == -1) continue;
                classTarget.link = Math.min(classTarget.link, classTarget2.dfn);
                continue;
            }
            if (classTarget2.getState() != 1) continue;
            this.searchCompile(classTarget2, n + 1, stack);
            classTarget.link = Math.min(classTarget.link, classTarget2.link);
        }
        if (classTarget.link == classTarget.dfn) {
            object = new Vector();
            do {
                classTarget2 = (ClassTarget)stack.pop();
                ((Vector)object).addElement(classTarget2);
            } while (classTarget2 != classTarget);
            this.doCompile((Vector)object);
        }
    }

    private void doCompile(Vector vector) {
        if (vector.size() == 0) {
            return;
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            ClassTarget classTarget = (ClassTarget)vector.get(n);
            stringArray[n] = classTarget.getSourceFile().getPath();
            ++n;
        }
        this.removeBreakpoints();
        JobQueue.getJobQueue().addJob(stringArray, (CompileObserver)this, this.getProject().getClassPath(), this.getProject().getProjectDir().getPath());
    }

    private boolean checkCompile() {
        if (Debugger.debugger.getStatus() != 0) {
            this.showMessage("compile-while-executing");
            return false;
        }
        return true;
    }

    public String generateDocumentation() {
        return this.project.generateDocumentation();
    }

    private void removeBreakpoints() {
        Enumeration enumeration = this.targets.elements();
        while (enumeration.hasMoreElements()) {
            Target target = (Target)enumeration.nextElement();
            if (!(target instanceof ClassTarget)) continue;
            ((ClassTarget)target).removeBreakpoints();
        }
    }

    public void removeStepMarks() {
        Enumeration enumeration = this.targets.elements();
        while (enumeration.hasMoreElements()) {
            Target target = (Target)enumeration.nextElement();
            if (!(target instanceof ClassTarget)) continue;
            ((ClassTarget)target).removeStepMark();
        }
    }

    public void addTarget(Target target) {
        if (target.getPackage() != this) {
            throw new IllegalArgumentException();
        }
        this.targets.put(target.getIdentifierName(), target);
    }

    public void removeTarget(Target target) {
        this.targets.remove(target.getIdentifierName());
    }

    public void updateTargetIdentifier(Target target, String string, String string2) {
        if (target == null || string2 == null) {
            Debug.reportError("cannot properly update target name...");
            return;
        }
        this.targets.remove(string);
        this.targets.put(string2, target);
    }

    public void removeClass(ClassTarget classTarget) {
        classTarget.prepareForRemoval();
        this.removeTarget(classTarget);
        this.getEditor().repaint();
    }

    public void removePackage(PackageTarget packageTarget) {
        packageTarget.deleteFiles();
        this.removeTarget(packageTarget);
        this.getEditor().repaint();
    }

    public void addDependency(Dependency dependency, boolean bl) {
        DependentTarget dependentTarget = dependency.getFrom();
        DependentTarget dependentTarget2 = dependency.getTo();
        if (dependentTarget == null || dependentTarget2 == null) {
            return;
        }
        if (dependency instanceof UsesDependency) {
            int n = this.usesArrows.indexOf(dependency);
            if (n != -1) {
                ((UsesDependency)this.usesArrows.get(n)).setFlag(true);
                return;
            }
            this.usesArrows.addElement(dependency);
        } else {
            if (this.extendsArrows.contains(dependency)) {
                return;
            }
            this.extendsArrows.addElement(dependency);
        }
        dependentTarget.addDependencyOut(dependency, bl);
        dependentTarget2.addDependencyIn(dependency, bl);
    }

    public void userAddImplementsClassDependency(Dependency dependency) {
        ClassTarget classTarget = (ClassTarget)dependency.getFrom();
        ClassTarget classTarget2 = (ClassTarget)dependency.getTo();
        Editor editor = classTarget.getEditor();
        try {
            ClassInfo classInfo = ClassParser.parse(classTarget.getSourceFile(), this.getAllClassnames());
            Selection selection = classInfo.getImplementsInsertSelection();
            editor.setSelection(selection.getLine(), selection.getColumn(), selection.getLength());
            if (classInfo.hasInterfaceSelections()) {
                Vector vector = classInfo.getInterfaceTexts();
                if (!vector.contains(classTarget2.getBaseName())) {
                    editor.insertText(", " + classTarget2.getBaseName(), false, false);
                }
            } else {
                editor.insertText(" implements " + classTarget2.getBaseName(), false, false);
            }
            editor.save();
        }
        catch (Exception exception) {
            return;
        }
    }

    public void userAddImplementsInterfaceDependency(Dependency dependency) {
        ClassTarget classTarget = (ClassTarget)dependency.getFrom();
        ClassTarget classTarget2 = (ClassTarget)dependency.getTo();
        Editor editor = classTarget.getEditor();
        try {
            ClassInfo classInfo = ClassParser.parse(classTarget.getSourceFile(), this.getAllClassnames());
            Selection selection = classInfo.getExtendsInsertSelection();
            editor.setSelection(selection.getLine(), selection.getColumn(), selection.getLength());
            if (classInfo.hasInterfaceSelections()) {
                Vector vector = classInfo.getInterfaceTexts();
                if (!vector.contains(classTarget2.getBaseName())) {
                    editor.insertText(", " + classTarget2.getBaseName(), false, false);
                }
            } else {
                editor.insertText(" extends " + classTarget2.getBaseName(), false, false);
            }
            editor.save();
        }
        catch (Exception exception) {
            return;
        }
    }

    public void userAddExtendsClassDependency(Dependency dependency) {
        ClassTarget classTarget = (ClassTarget)dependency.getFrom();
        ClassTarget classTarget2 = (ClassTarget)dependency.getTo();
        Editor editor = classTarget.getEditor();
        try {
            ClassInfo classInfo = ClassParser.parse(classTarget.getSourceFile(), this.getAllClassnames());
            if (classInfo.getSuperclass() == null) {
                Selection selection = classInfo.getExtendsInsertSelection();
                editor.setSelection(selection.getLine(), selection.getColumn(), selection.getLength());
                editor.insertText(" extends " + classTarget2.getBaseName(), false, false);
            } else {
                Selection selection = classInfo.getSuperReplaceSelection();
                editor.setSelection(selection.getLine(), selection.getColumn(), selection.getLength());
                editor.insertText(classTarget2.getBaseName(), false, false);
            }
            editor.save();
        }
        catch (Exception exception) {
            return;
        }
    }

    public void userRemoveDependency(Dependency dependency) {
        if (!(dependency.getFrom() instanceof ClassTarget) || !(dependency.getTo() instanceof ClassTarget)) {
            return;
        }
        ClassTarget classTarget = (ClassTarget)dependency.getFrom();
        ClassTarget classTarget2 = (ClassTarget)dependency.getTo();
        Editor editor = classTarget.getEditor();
        try {
            ClassInfo classInfo = ClassParser.parse(classTarget.getSourceFile(), this.getAllClassnames());
            Selection selection = null;
            Selection selection2 = null;
            Selection selection3 = null;
            String string = "";
            if (dependency instanceof ImplementsDependency) {
                Vector vector;
                Vector vector2;
                if (classInfo.isInterface()) {
                    vector2 = classInfo.getInterfaceSelections();
                    vector = classInfo.getInterfaceTexts();
                    string = "extends ";
                } else {
                    vector2 = classInfo.getInterfaceSelections();
                    vector = classInfo.getInterfaceTexts();
                    string = "implements ";
                }
                int n = vector.indexOf(classTarget2.getBaseName());
                if (n > 0) {
                    selection = (Selection)vector2.get(n - 1);
                    selection2 = (Selection)vector2.get(n);
                }
                if (n == 1 && vector2.size() > 2) {
                    selection3 = (Selection)vector2.get(n + 1);
                }
            } else if (dependency instanceof ExtendsDependency) {
                selection = classInfo.getExtendsReplaceSelection();
                selection2 = classInfo.getSuperReplaceSelection();
            }
            if (selection3 != null) {
                editor.setSelection(selection3.getLine(), selection3.getColumn(), selection3.getLength());
                editor.insertText(string, false, false);
            }
            if (selection2 != null) {
                editor.setSelection(selection2.getLine(), selection2.getColumn(), selection2.getLength());
                editor.insertText("", false, false);
            }
            if (selection != null) {
                editor.setSelection(selection.getLine(), selection.getColumn(), selection.getLength());
                editor.insertText("", false, false);
            }
            editor.save();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Debug.message("Parse error attempting to delete dependency arrow");
            return;
        }
    }

    public void removeDependency(Dependency dependency, boolean bl) {
        if (dependency instanceof UsesDependency) {
            this.usesArrows.removeElement(dependency);
        } else {
            this.extendsArrows.removeElement(dependency);
        }
        DependentTarget dependentTarget = dependency.getFrom();
        dependentTarget.removeDependencyOut(dependency, bl);
        DependentTarget dependentTarget2 = dependency.getTo();
        dependentTarget2.removeDependencyIn(dependency, bl);
    }

    public void recalcArrows() {
        Enumeration enumeration = this.getVertices();
        while (enumeration.hasMoreElements()) {
            Target target = (Target)enumeration.nextElement();
            if (!(target instanceof DependentTarget)) continue;
            DependentTarget dependentTarget = (DependentTarget)target;
            dependentTarget.recalcInUses();
            dependentTarget.recalcOutUses();
        }
    }

    public void setActiveVertex(Vertex vertex) {
        if (this.selected != null) {
            this.selected.toggleFlag(1);
        }
        this.selected = (Target)vertex;
        if (this.selected != null) {
            this.selected.toggleFlag(1);
        }
    }

    public Target getTarget(String string) {
        if (string == null) {
            return null;
        }
        Target target = (Target)this.targets.get(string);
        return target;
    }

    public DependentTarget getDependentTarget(String string) {
        if (string == null) {
            return null;
        }
        Target target = (Target)this.targets.get(string);
        if (target instanceof DependentTarget) {
            return (DependentTarget)target;
        }
        return null;
    }

    public Vector getAllClassnames() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.targets.elements();
        while (enumeration.hasMoreElements()) {
            Target target = (Target)enumeration.nextElement();
            if (!(target instanceof ClassTarget)) continue;
            ClassTarget classTarget = (ClassTarget)target;
            vector.add(classTarget.getBaseName());
        }
        return vector;
    }

    public ClassTarget getTargetFromFilename(String string) {
        this.getProject().convertPathToPackageName(string);
        Enumeration enumeration = this.targets.elements();
        while (enumeration.hasMoreElements()) {
            ClassTarget classTarget;
            Target target = (Target)enumeration.nextElement();
            if (!(target instanceof ClassTarget) || !string.equals((classTarget = (ClassTarget)target).getSourceFile().getPath())) continue;
            return classTarget;
        }
        return null;
    }

    public EditableTarget getTargetFromEditor(Editor editor) {
        Enumeration enumeration = this.targets.elements();
        while (enumeration.hasMoreElements()) {
            EditableTarget editableTarget;
            Target target = (Target)enumeration.nextElement();
            if (!(target instanceof EditableTarget) || !(editableTarget = (EditableTarget)target).usesEditor(editor)) continue;
            return editableTarget;
        }
        return null;
    }

    public boolean toggleShowUses() {
        this.showUses = !this.showUses;
        return this.showUses;
    }

    public boolean toggleShowExtends() {
        this.showExtends = !this.showExtends;
        return this.showExtends;
    }

    public void setState(int n) {
        switch (this.state) {
            case 5: {
                if (this.currentArrow != null) {
                    this.currentArrow.highlight(this.getEditor().getGraphics2D());
                    this.currentArrow = null;
                }
                this.getEditor().removeMouseListener(this);
                this.getEditor().removeMouseMotionListener(this);
                break;
            }
        }
        this.state = n;
        switch (this.state) {
            case 5: {
                this.getEditor().addMouseListener(this);
                this.getEditor().addMouseMotionListener(this);
                break;
            }
        }
    }

    public int getState() {
        return this.state;
    }

    public static boolean isBlueJPackage(File file) {
        if (file == null) {
            return false;
        }
        if (!file.isDirectory()) {
            return false;
        }
        if (file.getPath().endsWith(":\\")) {
            return false;
        }
        File file2 = new File(file, pkgfileName);
        return file2.exists();
    }

    void targetSelected(Target target) {
        switch (this.getState()) {
            case 1: {
                if (target instanceof DependentTarget) {
                    this.fromChoice = (DependentTarget)target;
                    this.setState(2);
                    this.setStatus(chooseUsesTo);
                    break;
                }
                this.setState(0);
                this.setStatus(" ");
                break;
            }
            case 2: {
                if (target == this.fromChoice || !(target instanceof DependentTarget)) break;
                this.setState(0);
                this.addDependency(new UsesDependency(this, this.fromChoice, (DependentTarget)target), true);
                this.setStatus(" ");
                break;
            }
            case 3: {
                if (target instanceof DependentTarget) {
                    this.fromChoice = (DependentTarget)target;
                    this.setState(4);
                    this.setStatus(chooseInhTo);
                    break;
                }
                this.setState(0);
                this.setStatus(" ");
                break;
            }
            case 4: {
                if (target == this.fromChoice) break;
                this.setState(0);
                if (target instanceof ClassTarget && this.fromChoice instanceof ClassTarget) {
                    ClassTarget classTarget = (ClassTarget)this.fromChoice;
                    ClassTarget classTarget2 = (ClassTarget)target;
                    if (classTarget2.isInterface()) {
                        ImplementsDependency implementsDependency = new ImplementsDependency(this, classTarget, classTarget2);
                        if (classTarget.isInterface()) {
                            this.userAddImplementsInterfaceDependency(implementsDependency);
                        } else {
                            this.userAddImplementsClassDependency(implementsDependency);
                        }
                        this.addDependency(implementsDependency, true);
                    } else if (!classTarget.isInterface()) {
                        ExtendsDependency extendsDependency = new ExtendsDependency(this, classTarget, classTarget2);
                        this.userAddExtendsClassDependency(extendsDependency);
                        this.addDependency(extendsDependency, true);
                    }
                }
                this.setStatus(" ");
                break;
            }
        }
    }

    public void showError(String string) {
        PkgMgrFrame.showError(this, string);
    }

    public void showMessage(String string) {
        PkgMgrFrame.showMessage(this, string);
    }

    public void showMessageWithText(String string, String string2) {
        PkgMgrFrame.showMessageWithText(this, string, string2);
    }

    public void reportException(String string) {
        this.showMessageWithText("exception-thrown", string);
    }

    public void forgetLastSource() {
        this.lastSourceName = "";
    }

    public boolean showSource(String string, int n, String string2, boolean bl) {
        String string3 = " ";
        if (bl) {
            string3 = "Thread \"" + string2 + "\" stopped at breakpoint.";
        }
        boolean bl2 = !string.equals(this.lastSourceName);
        this.lastSourceName = string;
        if (!this.showEditorMessage(new File(this.getPath(), string).getPath(), n, string3, false, false, bl2, true, null)) {
            this.showMessageWithText("break-no-source", string);
        }
        return bl2;
    }

    private boolean showEditorMessage(String string, int n, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string3) {
        ClassTarget classTarget;
        Package package_;
        String string4 = this.getProject().convertPathToPackageName(string);
        String string5 = JavaNames.getPrefix(string4);
        String string6 = JavaNames.getBase(string4);
        if (string5 != this.getQualifiedName()) {
            package_ = this.getProject().getPackage(string5);
            PkgMgrFrame pkgMgrFrame = PkgMgrFrame.findFrame(package_);
            if (pkgMgrFrame == null) {
                pkgMgrFrame = PkgMgrFrame.createFrame(package_);
            }
            pkgMgrFrame.show();
            classTarget = (ClassTarget)package_.getTarget(string6);
        } else {
            classTarget = (ClassTarget)this.getTarget(string6);
        }
        if (classTarget == null) {
            return false;
        }
        if (bl) {
            classTarget.setState(1);
            classTarget.unsetFlag(2);
        }
        if (bl3 || !classTarget.getEditor().isShowing()) {
            classTarget.open();
        }
        if ((package_ = classTarget.getEditor()) != null) {
            package_.displayMessage(string2, n, 0, bl2, bl4, string3);
        } else {
            Debug.message(classTarget.getDisplayName() + ", line" + n + ": " + string2);
        }
        return true;
    }

    public void hitBreakpoint(DebuggerThread debuggerThread) {
        this.showSource(debuggerThread.getClassSourceName(0), debuggerThread.getLineNumber(0), debuggerThread.getName(), true);
        ExecControls.showHide(true, true, debuggerThread);
    }

    public void hitHalt(DebuggerThread debuggerThread) {
        this.showSourcePosition(debuggerThread, true);
    }

    public void showSourcePosition(DebuggerThread debuggerThread, boolean bl) {
        int n = debuggerThread.getSelectedFrame();
        if (this.showSource(debuggerThread.getClassSourceName(n), debuggerThread.getLineNumber(n), debuggerThread.getName(), false)) {
            ((Component)ExecControls.getExecControls()).setVisible(true);
        }
        if (bl) {
            ExecControls.getExecControls().updateThreads(debuggerThread);
        }
    }

    public void startCompile(String[] stringArray) {
        this.setStatus(compiling);
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            String string2 = this.getProject().convertPathToPackageName(string);
            Target target = this.getTarget(JavaNames.getBase(string2));
            if (target != null) {
                target.setState(2);
            }
            ++n;
        }
    }

    public void errorMessage(String string, int n, String string2, boolean bl) {
        if (!this.showEditorMessage(string, n, string2, bl, true, true, false, Config.compilertype)) {
            this.showMessageWithText("error-in-file", string + ":" + n + "\n" + string2);
        }
    }

    public void checkTarget(String string) {
    }

    public void exceptionMessage(List list, String string, boolean bl) {
        SourceLocation sourceLocation;
        if (list.size() == 0) {
            Debug.reportError("Stack missing in exception event");
            return;
        }
        boolean bl2 = false;
        Iterator iterator = list.iterator();
        boolean bl3 = true;
        while (!bl2 && iterator.hasNext()) {
            sourceLocation = (SourceLocation)iterator.next();
            String string2 = new File(this.getPath(), sourceLocation.getFileName()).getPath();
            int n = sourceLocation.getLineNumber();
            bl2 = this.showEditorMessage(string2, n, string, bl, true, true, false, "exception");
            if (!bl3 || bl2) continue;
            string = string + " (in " + sourceLocation.getClassName() + ")";
            bl3 = false;
        }
        if (!bl2) {
            sourceLocation = (SourceLocation)list.get(0);
            this.showMessageWithText("error-in-file", sourceLocation.getClassName() + ":" + sourceLocation.getLineNumber() + "\n" + string);
        }
    }

    public void endCompile(String[] stringArray, boolean bl) {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            String string2 = this.getProject().convertPathToPackageName(string);
            ClassTarget classTarget = (ClassTarget)this.targets.get(JavaNames.getBase(string2));
            if (classTarget != null) {
                if (bl) {
                    classTarget.endCompile();
                    try {
                        ClassInfo classInfo = ClassParser.parse(classTarget.getSourceFile(), this.getAllClassnames());
                        FileOutputStream fileOutputStream = new FileOutputStream(classTarget.getContextFile());
                        classInfo.getComments().store(fileOutputStream, "BlueJ class context");
                        ((OutputStream)fileOutputStream).close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                classTarget.setState(bl ? 0 : 1);
                classTarget.unsetFlag(2);
                if (bl && classTarget.editorOpen()) {
                    classTarget.getEditor().setCompiled(true);
                }
            }
            ++n;
        }
        this.setStatus(compileDone);
        this.getEditor().repaint();
    }

    public void reportExit(String string) {
        this.showMessageWithText("system-exit", string);
    }

    public void closeAllEditors() {
        Enumeration enumeration = this.targets.elements();
        while (enumeration.hasMoreElements()) {
            ClassTarget classTarget;
            Target target = (Target)enumeration.nextElement();
            if (!(target instanceof ClassTarget) || !(classTarget = (ClassTarget)target).editorOpen()) continue;
            classTarget.getEditor().close();
        }
    }

    public CallHistory getCallHistory() {
        return this.callHistory;
    }

    public void invalidate(Target target) {
        if (target instanceof ClassTarget) {
            ClassTarget classTarget = (ClassTarget)target;
            this.getProject().removeLocalClassLoader();
            this.getProject().removeRemoteClassLoader();
        }
    }

    Dependency findArrow(int n, int n2) {
        Dependency dependency;
        Enumeration enumeration = this.usesArrows.elements();
        while (enumeration.hasMoreElements()) {
            dependency = (Dependency)enumeration.nextElement();
            if (!dependency.contains(n, n2)) continue;
            return dependency;
        }
        enumeration = this.extendsArrows.elements();
        while (enumeration.hasMoreElements()) {
            dependency = (Dependency)enumeration.nextElement();
            if (!dependency.contains(n, n2)) continue;
            return dependency;
        }
        return null;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        switch (this.state) {
            case 5: {
                Dependency dependency = this.findArrow(mouseEvent.getX(), mouseEvent.getY());
                if (this.currentArrow != null && this.currentArrow != dependency) {
                    this.currentArrow.highlight(this.getEditor().getGraphics2D());
                }
                if (dependency != null) {
                    if (!(dependency instanceof UsesDependency)) {
                        this.userRemoveDependency(dependency);
                    }
                    this.removeDependency(dependency, true);
                    this.getEditor().repaint();
                }
                this.currentArrow = null;
                this.setState(0);
                break;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        switch (this.state) {
            case 5: {
                Dependency dependency = this.findArrow(mouseEvent.getX(), mouseEvent.getY());
                if (this.currentArrow != null && this.currentArrow != dependency) {
                    this.currentArrow.highlight(this.getEditor().getGraphics2D());
                }
                if (dependency != null && this.currentArrow != dependency) {
                    dependency.highlight(this.getEditor().getGraphics2D());
                }
                this.currentArrow = dependency;
                break;
            }
        }
    }

    public Package(Project project, String string, Package package_) throws IOException {
        if (package_ == null) {
            throw new NullPointerException("Package must have a valid parent package");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("unnamedPackage must be created using Package(project)");
        }
        if (!JavaNames.isIdentifier(string)) {
            throw new IllegalArgumentException(string + " is not a valid name for a Package");
        }
        this.project = project;
        this.baseName = string;
        this.parentPackage = package_;
        this.init();
    }

    public Package(Project project) throws IOException {
        this.project = project;
        this.baseName = "";
        this.parentPackage = null;
        this.init();
    }
}

