/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.pkgmgr.Package;
import bluej.utility.Utility;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.text.DateFormat;
import java.util.Date;

public class PackagePrinter
extends Thread
implements Printable {
    static final int a4Width = 595;
    static final int a4Height = 840;
    static final int PRINT_HMARGIN = 6;
    static final int PRINT_VMARGIN = 24;
    static final Font printTitleFont = new Font("SansSerif", 0, 12);
    static final Font printInfoFont = new Font("SansSerif", 2, 10);
    private PageFormat pageFormat;
    private Package pkg;
    private int pageColumns = 0;
    private int pageRows = 0;
    private int pages;
    private int currentPage;
    private int currentColumn = 0;
    private int currentRow = 0;

    public void run() {
        this.printPackage();
    }

    private void printPackage() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        Dimension dimension = this.pkg.getMinimumSize();
        printerJob.setPrintable(this, this.pageFormat);
        if (printerJob.printDialog()) {
            this.pkg.setStatus(Config.getString("pkgmgr.info.printing"));
            this.calculatePages();
            try {
                printerJob.print();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.pkg.setStatus(Config.getString("pkgmgr.info.printed"));
        }
    }

    private void calculatePages() {
        Dimension dimension = new Dimension((int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
        Dimension dimension2 = this.pkg.getMinimumSize();
        Rectangle rectangle = this.getPrintArea(this.pageFormat);
        this.pageColumns = (dimension2.width + rectangle.width - 1) / rectangle.width;
        this.pageRows = (dimension2.height + rectangle.height - 1) / rectangle.height;
        this.pages = this.pageColumns * this.pageRows;
        this.currentRow = 0;
        this.currentColumn = 0;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n >= this.pages) {
            return 1;
        }
        Rectangle rectangle = this.getPrintArea(pageFormat);
        if (this.currentColumn < this.pageColumns) {
            if (this.currentPage < n) {
                ++this.currentColumn;
            }
        } else if (this.currentRow < this.pageRows) {
            ++this.currentRow;
            this.currentColumn = 0;
        }
        this.printTitle(graphics, pageFormat, n + 1);
        graphics.translate(rectangle.x - this.currentColumn * rectangle.width, rectangle.y - this.currentRow * rectangle.height);
        graphics.setClip(this.currentColumn * rectangle.width, this.currentRow * rectangle.height, rectangle.width, rectangle.height);
        this.pkg.getEditor().paint(graphics);
        this.currentPage = n;
        return 0;
    }

    private Rectangle getPrintArea(PageFormat pageFormat) {
        return new Rectangle((int)pageFormat.getImageableX() + 6, (int)pageFormat.getImageableY() + 24, (int)pageFormat.getImageableWidth() - 12, (int)pageFormat.getImageableHeight() - 48);
    }

    private void printTitle(Graphics graphics, PageFormat pageFormat, int n) {
        FontMetrics fontMetrics = graphics.getFontMetrics(printTitleFont);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(printInfoFont);
        Rectangle rectangle = new Rectangle((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY(), (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
        graphics.setColor(Color.lightGray);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, 24);
        graphics.setColor(Color.black);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, 24);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height - 24);
        String string = this.pkg.getQualifiedName();
        graphics.setFont(printTitleFont);
        Utility.drawCentredText(graphics, "BlueJ package - " + string, rectangle.x, rectangle.y, rectangle.width, fontMetrics.getHeight());
        graphics.setFont(printInfoFont);
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        Utility.drawRightText(graphics, dateFormat.format(new Date()) + ", Page " + n, rectangle.x, rectangle.y + rectangle.height - 24, rectangle.width, fontMetrics2.getHeight());
    }

    public PackagePrinter(Package package_, PageFormat pageFormat) {
        this.pkg = package_;
        this.pageFormat = pageFormat;
    }
}

