/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.graph.GraphEditor;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.Target;
import bluej.prefmgr.PrefMgr;
import bluej.utility.FileUtility;
import bluej.utility.Utility;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PackageTarget
extends Target {
    static final Color defaultbg = Config.getItemColour("colour.package.bg.default");
    static final Color umldefaultbg = Config.getItemColour("colour.package.bg.uml.default");
    static final Color ribboncolour = defaultbg.darker().darker();
    static final Color bordercolour = Config.getItemColour("colour.target.border");
    static final Color textbg = Config.getItemColour("colour.text.bg");
    static final Color textfg = Config.getItemColour("colour.text.fg");
    static final int TAB_HEIGHT = 12;
    static String openStr = Config.getString("pkgmgr.packagemenu.open");
    static String removeStr = Config.getString("pkgmgr.packagemenu.remove");
    static final Color envOpColour = Config.getItemColour("colour.menu.environOp");
    static final BasicStroke normalStroke = new BasicStroke(1.0f);
    static final BasicStroke selectedStroke = new BasicStroke(3.0f);
    private int tabWidth;

    public String getBaseName() {
        return this.getIdentifierName();
    }

    public String getQualifiedName() {
        return this.getPackage().getQualifiedName(this.getBaseName());
    }

    public void load(Properties properties, String string) throws NumberFormatException {
        super.load(properties, string);
    }

    public void save(Properties properties, String string) {
        super.save(properties, string);
        ((Hashtable)properties).put(string + ".type", "PackageTarget");
    }

    public void deleteFiles() {
        FileUtility.deleteDir(new File(this.getPackage().getPath(), this.getBaseName()));
    }

    public boolean copyFiles(String string) {
        return true;
    }

    Color getBackgroundColour() {
        if (PrefMgr.isUML()) {
            return umldefaultbg;
        }
        return defaultbg;
    }

    Color getBorderColour() {
        return bordercolour;
    }

    Color getTextColour() {
        return textfg;
    }

    Font getFont() {
        return this.state == 1 ? PrefMgr.getStandoutFont() : PrefMgr.getStandardFont();
    }

    public void draw(Graphics2D graphics2D) {
        if (PrefMgr.isUML()) {
            this.drawUMLStyle(graphics2D);
        } else {
            this.drawBlueStyle(graphics2D);
        }
    }

    public void drawUMLStyle(Graphics2D graphics2D) {
        this.tabWidth = this.width / 3;
        graphics2D.setColor(this.getBackgroundColour());
        graphics2D.fillRect(0, 0, this.tabWidth, 12);
        graphics2D.fillRect(0, 12, this.width, this.height - 12);
        graphics2D.setColor(Target.shadowCol);
        this.drawUMLShadow(graphics2D);
        graphics2D.setColor(this.getBorderColour());
        graphics2D.setFont(this.getFont());
        Utility.drawCentredText(graphics2D, this.getDisplayName(), 8, 20, this.width - 16, 16);
        this.drawUMLBorders(graphics2D);
    }

    public void drawBlueStyle(Graphics2D graphics2D) {
        graphics2D.setColor(this.getBackgroundColour());
        graphics2D.fillRect(0, 0, this.width, this.height);
        graphics2D.setColor(ribboncolour);
        int n = 16;
        int n2 = this.height - 20 + 5;
        graphics2D.drawLine(n, 0, n, this.height);
        graphics2D.drawLine(0, n2, this.width, n2);
        graphics2D.drawLine(n - 10, n2, n - 10, n2 - 3);
        graphics2D.drawLine(n - 10, n2 - 3, n - 8, n2 - 5);
        graphics2D.drawLine(n - 8, n2 - 5, n - 5, n2 - 5);
        graphics2D.drawLine(n - 5, n2 - 5, n, n2);
        graphics2D.drawLine(n, n2, n + 10, n2 + 10);
        graphics2D.drawLine(n + 10, n2, n + 10, n2 - 3);
        graphics2D.drawLine(n + 10, n2 - 3, n + 8, n2 - 5);
        graphics2D.drawLine(n + 8, n2 - 5, n + 5, n2 - 5);
        graphics2D.drawLine(n + 5, n2 - 5, n, n2);
        graphics2D.drawLine(n, n2, n - 10, n2 + 10);
        graphics2D.setColor(textbg);
        graphics2D.fillRect(8, 8, this.width - 16, 16);
        graphics2D.setColor(Target.shadowCol);
        this.drawShadow(graphics2D);
        graphics2D.setColor(this.getBorderColour());
        graphics2D.setFont(this.getFont());
        Utility.drawCentredText(graphics2D, this.getDisplayName(), 8, 8, this.width - 16, 16);
        graphics2D.drawRect(8, 8, this.width - 16, 16);
        this.drawBorders(graphics2D);
    }

    void drawBorders(Graphics2D graphics2D) {
        if (PrefMgr.isUML()) {
            this.drawUMLBorders(graphics2D);
        } else {
            super.drawBorders(graphics2D);
        }
    }

    void drawUMLBorders(Graphics2D graphics2D) {
        if ((this.flags & 1) != 0) {
            graphics2D.setStroke(selectedStroke);
        }
        graphics2D.drawRect(0, 0, this.tabWidth, 12);
        graphics2D.drawRect(0, 12, this.width, this.height - 12);
        if ((this.flags & 1) == 0) {
            return;
        }
        graphics2D.setStroke(normalStroke);
        graphics2D.drawLine(this.width - 20 - 2, this.height, this.width, this.height - 20 - 2);
        graphics2D.drawLine(this.width - 20 + 2, this.height, this.width, this.height - 20 + 2);
    }

    void drawUMLShadow(Graphics2D graphics2D) {
        graphics2D.fillRect(4, this.height, this.width, 4);
        graphics2D.fillRect(this.width, 16, 4, this.height - 12);
    }

    public void doubleClick(MouseEvent mouseEvent, int n, int n2, GraphEditor graphEditor) {
        PackageEditor packageEditor = (PackageEditor)graphEditor;
        packageEditor.raiseOpenPackageEvent(this, this.getPackage().getQualifiedName(this.getBaseName()));
    }

    public void popupMenu(MouseEvent mouseEvent, int n, int n2, GraphEditor graphEditor) {
        JPopupMenu jPopupMenu = this.createMenu(null);
        if (jPopupMenu != null) {
            jPopupMenu.show(graphEditor, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private JPopupMenu createMenu(Class clazz) {
        JPopupMenu jPopupMenu = new JPopupMenu(this.getBaseName());
        PackageTarget packageTarget = this;
        if (packageTarget == null) {
            throw null;
        }
        OpenAction openAction = packageTarget.new OpenAction(openStr, this, this.getPackage().getQualifiedName(this.getBaseName()));
        JMenuItem jMenuItem = jPopupMenu.add(openAction);
        jMenuItem.setFont(PrefMgr.getPopupMenuFont());
        jMenuItem.setForeground(envOpColour);
        PackageTarget packageTarget2 = this;
        if (packageTarget2 == null) {
            throw null;
        }
        RemoveAction removeAction = packageTarget2.new RemoveAction(removeStr, this);
        jMenuItem = jPopupMenu.add(removeAction);
        jMenuItem.setFont(PrefMgr.getPopupMenuFont());
        jMenuItem.setForeground(envOpColour);
        return jPopupMenu;
    }

    private void addMenuItem(JPopupMenu jPopupMenu, String string, String string2) {
        PackageTarget packageTarget = this;
        if (packageTarget == null) {
            throw null;
        }
        OpenAction openAction = packageTarget.new OpenAction(string, this, string2);
        JMenuItem jMenuItem = jPopupMenu.add(openAction);
        jMenuItem.setFont(PrefMgr.getPopupMenuFont());
        jMenuItem.setForeground(envOpColour);
    }

    public PackageTarget(Package package_, String string) {
        super(package_, string);
        this.setSize(Target.calculateWidth(string), 62);
    }

    private class OpenAction
    extends AbstractAction {
        private Target t;
        private String pkgName;

        public void actionPerformed(ActionEvent actionEvent) {
            PackageTarget.this.getPackage().getEditor().raiseOpenPackageEvent(this.t, this.pkgName);
        }

        public OpenAction(String string, Target target, String string2) {
            super(string);
            this.t = target;
            this.pkgName = string2;
        }
    }

    private class RemoveAction
    extends AbstractAction {
        private Target t;

        public void actionPerformed(ActionEvent actionEvent) {
            PackageTarget.this.getPackage().getEditor().raiseRemoveTargetEvent(this.t);
        }

        public RemoveAction(String string, Target target) {
            super(string);
            this.t = target;
        }
    }
}

