/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJEvent;
import bluej.BlueJEventListener;
import bluej.Config;
import bluej.Main;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerObject;
import bluej.debugger.ExecControlButtonModel;
import bluej.debugger.ExecControls;
import bluej.debugger.Invoker;
import bluej.debugger.LibraryCallDialog;
import bluej.debugger.ObjectBench;
import bluej.debugger.ObjectViewer;
import bluej.debugger.ObjectWrapper;
import bluej.debugger.ResultWatcher;
import bluej.pkgmgr.AboutBlue;
import bluej.pkgmgr.ClassTarget;
import bluej.pkgmgr.ExportManager;
import bluej.pkgmgr.Import;
import bluej.pkgmgr.ImportFailedDialog;
import bluej.pkgmgr.NewClassDialog;
import bluej.pkgmgr.NewPackageDialog;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.PackageEditorEvent;
import bluej.pkgmgr.PackageEditorListener;
import bluej.pkgmgr.PackagePrinter;
import bluej.pkgmgr.PackageTarget;
import bluej.pkgmgr.ParentPackageTarget;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.Target;
import bluej.pkgmgr.VersionCheckDialog;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefMgrDialog;
import bluej.terminal.Terminal;
import bluej.terminal.TerminalButtonModel;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.Utility;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class PkgMgrFrame
extends JFrame
implements BlueJEventListener,
ActionListener,
ItemListener,
MouseListener,
PackageEditorListener {
    static final String chooseUsesFrom = Config.getString("pkgmgr.chooseUsesFrom");
    static final String chooseInhFrom = Config.getString("pkgmgr.chooseInhFrom");
    static final String chooseArrow = Config.getString("pkgmgr.chooseArrow");
    static final String packageSaved = Config.getString("pkgmgr.packageSaved");
    static final String errCloseAlert = Config.getString("pkgmgr.error.close.title");
    static final String errCloseText = Config.getString("pkgmgr.error.close.text");
    static final String newpkgTitle = Config.getString("pkgmgr.newPkg.title");
    static final String createLabel = Config.getString("pkgmgr.newPkg.buttonLabel");
    static final int DEFAULT_WIDTH = 420;
    static final int DEFAULT_HEIGHT = 300;
    private static final String bluejUrl = Config.getPropString("bluej.url.bluej");
    private static final String tutorialUrl = Config.getPropString("bluej.url.tutorial");
    private static final String referenceUrl = Config.getPropString("bluej.url.reference");
    private static final String webBrowserMsg = Config.getString("pkgmgr.webBrowserMsg");
    private static final String webBrowserError = Config.getString("pkgmgr.webBrowserError");
    private static final String creatingVM = Config.getString("pkgmgr.creatingVM");
    private static final String creatingVMDone = Config.getString("pkgmgr.creatingVMDone");
    private static final String generatingDocu = Config.getString("pkgmgr.generatingDocu");
    private static final String docuGenerated = Config.getString("pkgmgr.docuGenerated");
    private static final String docuAborted = Config.getString("pkgmgr.docuAborted");
    private static final String addClassTitle = Config.getString("pkgmgr.addClass.title");
    private static final String addLabel = Config.getString("pkgmgr.addClass.buttonLabel");
    private static final String importpkgTitle = Config.getString("pkgmgr.importPkg.title");
    private static final Icon workingIcon = Config.getImageAsIcon("image.working");
    private static final Icon notWorkingIcon = Config.getImageAsIcon("image.working.disab");
    private static final Icon stoppedIcon = Config.getImageAsIcon("image.working.stopped");
    private static PageFormat pageFormat = new PageFormat();
    private static List frames = new ArrayList();
    static final int PROJ_COMMAND = 1000;
    static final int PROJ_NEW = 1000;
    static final int PROJ_OPEN = 1001;
    static final int PROJ_OPENNONBLUEJ = 1002;
    static final int PROJ_CLOSE = 1003;
    static final int PROJ_SAVE = 1004;
    static final int PROJ_SAVEAS = 1005;
    static final int PROJ_IMPORT = 1006;
    static final int PROJ_EXPORT = 1007;
    static final int PROJ_PAGESETUP = 1008;
    static final int PROJ_PRINT = 1009;
    static final int PROJ_QUIT = 1010;
    static final String[] ProjCmds = new String[]{"new", "open", "openNonBlueJ", "close", "save", "saveAs", "import", "export", "pageSetup", "print", "quit"};
    static final KeyStroke[] ProjKeys = new KeyStroke[]{null, KeyStroke.getKeyStroke(79, 2), null, KeyStroke.getKeyStroke(87, 2), KeyStroke.getKeyStroke(83, 2), null, null, null, null, KeyStroke.getKeyStroke(80, 2), KeyStroke.getKeyStroke(81, 2)};
    static final int[] ProjSeparators = new int[]{1005, 1007, 1009};
    static final int EDIT_COMMAND = 1100;
    static final int EDIT_NEWCLASS = 1100;
    static final int EDIT_NEWPACKAGE = 1101;
    static final int EDIT_ADDCLASS = 1102;
    static final int EDIT_REMOVE = 1103;
    static final int EDIT_NEWUSES = 1104;
    static final int EDIT_NEWINHERITS = 1105;
    static final int EDIT_REMOVEARROW = 1106;
    static final String[] EditCmds = new String[]{"newClass", "newPackage", "addClass", "remove", "newUses", "newInherits", "removeArrow"};
    static final KeyStroke[] EditKeys = new KeyStroke[]{KeyStroke.getKeyStroke(78, 2), KeyStroke.getKeyStroke(82, 2), null, null, null, null, null, null};
    static final int[] EditSeparators = new int[]{1103};
    static final int TOOLS_COMMAND = 1200;
    static final int TOOLS_COMPILE = 1200;
    static final int TOOLS_COMPILESELECTED = 1201;
    static final int TOOLS_CALLLIBRARY = 1202;
    static final int TOOLS_REBUILD = 1203;
    static final int TOOLS_GENERATEDOC = 1204;
    static final int TOOLS_PREFERENCES = 1205;
    static final String[] ToolsCmds = new String[]{"compile", "compileSelected", "callLibrary", "rebuild", "generateDoc", "preferences"};
    static final KeyStroke[] ToolsKeys = new KeyStroke[]{KeyStroke.getKeyStroke(75, 2), KeyStroke.getKeyStroke(75, 3), KeyStroke.getKeyStroke(76, 2), null, null, null};
    static final int[] ToolsSeparators = new int[]{1203, 1204};
    static final int VIEW_COMMAND = 1300;
    static final int VIEW_SHOWUSES = 1300;
    static final int VIEW_SHOWINHERITS = 1301;
    static final int VIEW_SHOWCONTROLS = 1302;
    static final int VIEW_SHOWTERMINAL = 1303;
    static final String[] ViewCmds = new String[]{"showUses", "showInherits", "showExecControls", "showTerminal"};
    static final KeyStroke[] ViewKeys = new KeyStroke[]{KeyStroke.getKeyStroke(85, 2), KeyStroke.getKeyStroke(73, 2), KeyStroke.getKeyStroke(68, 2), KeyStroke.getKeyStroke(84, 2)};
    static final int[] ViewSeparators = new int[]{1301};
    static final int GRP_COMMAND = 1400;
    static final int GRP_CREATE = 1400;
    static final int GRP_OPEN = 1401;
    static final int GRP_UPDATESELECTED = 1402;
    static final int GRP_UPDATEALL = 1403;
    static final int GRP_COMMITSELECTED = 1404;
    static final int GRP_COMMITALL = 1405;
    static final int GRP_STATUSSELECTED = 1406;
    static final int GRP_STATUSALL = 1407;
    static final int GRP_USERS = 1408;
    static final int GRP_CONFIG = 1409;
    static final String[] GrpCmds = new String[]{"make", "open", "updateSelected", "updateAll", "commitSelected", "commitAll", "statusSelection", "statusAll", "users", "configuration"};
    static final KeyStroke[] GrpKeys = new KeyStroke[]{null, null, null, null, null, null, null, null, null, null};
    static final int[] GrpSeparators = new int[]{1401, 1405, 1408};
    static final int HELP_COMMAND = 1500;
    static final int HELP_ABOUT = 1500;
    static final int HELP_VERSIONCHECK = 1501;
    static final int HELP_COPYRIGHT = 1502;
    static final int HELP_WEBSITE = 1503;
    static final int HELP_TUTORIAL = 1504;
    static final int HELP_STANDARDAPI = 1505;
    static final String[] HelpCmds = new String[]{"about", "versionCheck", "copyright", "website", "tutorial", "standardApi"};
    static final KeyStroke[] HelpKeys = new KeyStroke[]{null, KeyStroke.getKeyStroke(86, 2), null, null, null, null};
    static final int[] HelpSeparators = new int[]{1502};
    static final int[] CmdTypes = new int[]{1000, 1100, 1200, 1300, 1400, 1500};
    static final String[] CmdTypeNames = new String[]{"package", "edit", "tools", "view", "group", "help"};
    static final String[][] CmdStrings = new String[][]{ProjCmds, EditCmds, ToolsCmds, ViewCmds, GrpCmds, HelpCmds};
    static final KeyStroke[][] CmdKeys = new KeyStroke[][]{ProjKeys, EditKeys, ToolsKeys, ViewKeys, GrpKeys, HelpKeys};
    static final int[][] CmdSeparators = new int[][]{ProjSeparators, EditSeparators, ToolsSeparators, ViewSeparators, GrpSeparators, HelpSeparators};
    public Font PkgMgrFont = PrefMgr.getStandardFont();
    private JPanel buttonPanel;
    private JPanel viewPanel;
    private JPanel showPanel;
    private JButton imgExtendsButton;
    private JButton imgDependsButton;
    private JLabel statusbar = new JLabel(" ");
    private JMenuBar menubar = null;
    private JButton progressButton;
    private JCheckBoxMenuItem showUsesMenuItem;
    private JCheckBoxMenuItem showExtendsMenuItem;
    private JCheckBox showUsesCheckbox;
    private JCheckBox showExtendsCheckbox;
    private JScrollPane classScroller = null;
    private Package pkg = null;
    private PackageEditor editor = null;
    private ObjectBench objbench;
    private LibraryCallDialog libraryCallDialog = null;
    Hashtable actions = new Hashtable();

    public static PkgMgrFrame createFrame() {
        PkgMgrFrame pkgMgrFrame = new PkgMgrFrame();
        frames.add(pkgMgrFrame);
        BlueJEvent.addListener(pkgMgrFrame);
        return pkgMgrFrame;
    }

    public static PkgMgrFrame createFrame(Package package_) {
        PkgMgrFrame pkgMgrFrame = PkgMgrFrame.findFrame(package_);
        if (pkgMgrFrame == null) {
            if (frames.size() == 1) {
                pkgMgrFrame = (PkgMgrFrame)frames.get(0);
            }
            if (pkgMgrFrame == null || !pkgMgrFrame.isEmptyFrame()) {
                pkgMgrFrame = PkgMgrFrame.createFrame();
            }
            pkgMgrFrame.openPackage(package_);
        }
        return pkgMgrFrame;
    }

    public static void closeFrame(PkgMgrFrame pkgMgrFrame) {
        if (!pkgMgrFrame.isEmptyFrame()) {
            throw new IllegalArgumentException();
        }
        frames.remove(pkgMgrFrame);
        BlueJEvent.removeListener(pkgMgrFrame);
        pkgMgrFrame.dispose();
    }

    public static PkgMgrFrame findFrame(Package package_) {
        Iterator iterator = frames.iterator();
        while (iterator.hasNext()) {
            PkgMgrFrame pkgMgrFrame = (PkgMgrFrame)iterator.next();
            if (pkgMgrFrame.isEmptyFrame() || pkgMgrFrame.getPackage() != package_) continue;
            return pkgMgrFrame;
        }
        return null;
    }

    public static int frameCount() {
        return frames.size();
    }

    public static PkgMgrFrame[] getAllFrames() {
        if (frames.size() == 0) {
            return null;
        }
        PkgMgrFrame[] pkgMgrFrameArray = new PkgMgrFrame[frames.size()];
        frames.toArray(pkgMgrFrameArray);
        return pkgMgrFrameArray;
    }

    public static PkgMgrFrame[] getAllProjectFrames(Project project) {
        return PkgMgrFrame.getAllProjectFrames(project, "");
    }

    public static PkgMgrFrame[] getAllProjectFrames(Project project, String string) {
        ArrayList<PkgMgrFrame> arrayList = new ArrayList<PkgMgrFrame>();
        String string2 = string + ".";
        Iterator iterator = frames.iterator();
        while (iterator.hasNext()) {
            PkgMgrFrame pkgMgrFrame = (PkgMgrFrame)iterator.next();
            if (pkgMgrFrame.isEmptyFrame() || pkgMgrFrame.getProject() != project) continue;
            String string3 = pkgMgrFrame.getPackage().getQualifiedName();
            if (string3.startsWith(string2)) {
                arrayList.add(pkgMgrFrame);
                continue;
            }
            if (!string3.equals(string) && string.length() != 0) continue;
            arrayList.add(pkgMgrFrame);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new PkgMgrFrame[arrayList.size()]);
    }

    public static void refreshAllFrames() {
        if (!frames.isEmpty()) {
            Iterator iterator = frames.iterator();
            while (iterator.hasNext()) {
                PkgMgrFrame pkgMgrFrame = (PkgMgrFrame)iterator.next();
                pkgMgrFrame.setButtonImages();
                pkgMgrFrame.repaint();
            }
        }
    }

    public static void displayMessage(String string) {
        Iterator iterator = frames.iterator();
        while (iterator.hasNext()) {
            PkgMgrFrame pkgMgrFrame = (PkgMgrFrame)iterator.next();
            pkgMgrFrame.setStatus(string);
        }
    }

    public static void displayMessage(Package package_, String string) {
        PkgMgrFrame pkgMgrFrame = PkgMgrFrame.findFrame(package_);
        if (pkgMgrFrame != null) {
            pkgMgrFrame.setStatus(string);
        }
    }

    public static void showError(Package package_, String string) {
        PkgMgrFrame pkgMgrFrame = PkgMgrFrame.findFrame(package_);
        if (pkgMgrFrame != null) {
            DialogManager.showError(pkgMgrFrame, string);
        }
    }

    public static void showMessage(Package package_, String string) {
        PkgMgrFrame pkgMgrFrame = PkgMgrFrame.findFrame(package_);
        if (pkgMgrFrame != null) {
            DialogManager.showMessage(pkgMgrFrame, string);
        }
    }

    public static void showMessageWithText(Package package_, String string, String string2) {
        PkgMgrFrame pkgMgrFrame = PkgMgrFrame.findFrame(package_);
        if (pkgMgrFrame != null) {
            DialogManager.showMessageWithText(pkgMgrFrame, string, string2);
        }
    }

    public void openPackage(Package package_) {
        Object object;
        if (package_ == null) {
            throw new NullPointerException();
        }
        if (this.pkg != null) {
            this.closePackage();
        }
        this.pkg = package_;
        this.editor = new PackageEditor(package_);
        this.editor.addMouseListener(this);
        this.editor.addMouseListener(this.editor);
        this.pkg.editor = this.editor;
        this.classScroller.setViewportView(this.editor);
        this.editor.addPackageEditorListener(this);
        Properties properties = package_.getLastSavedProperties();
        try {
            object = properties.getProperty("package.editor.width", Integer.toString(420));
            String string = properties.getProperty("package.editor.height", Integer.toString(300));
            this.classScroller.setPreferredSize(new Dimension(Integer.parseInt((String)object), Integer.parseInt(string)));
            String string2 = properties.getProperty("package.editor.x", Integer.toString(16));
            String string3 = properties.getProperty("package.editor.y", Integer.toString(16));
            int n = 16;
            int n2 = 16;
            n = Integer.parseInt(string2);
            n2 = Integer.parseInt(string3);
            if (n > Config.screenBounds.width - 16) {
                n = Config.screenBounds.width - 16;
            }
            if (n2 > Config.screenBounds.height - 16) {
                n2 = Config.screenBounds.height - 16;
            }
            ((Component)this).setLocation(n, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pack();
        this.editor.revalidate();
        PkgMgrFrame pkgMgrFrame = this;
        if (pkgMgrFrame == null) {
            throw null;
        }
        object = new Runnable(pkgMgrFrame){
            private final /* synthetic */ PkgMgrFrame this$0;

            public void run() {
                this.this$0.enableFunctions(true);
                this.this$0.updateWindowTitle();
                this.this$0.show();
            }
            {
                this.this$0 = pkgMgrFrame;
                this.constructor$0(pkgMgrFrame);
            }

            private final void constructor$0(PkgMgrFrame pkgMgrFrame) {
            }
        };
        SwingUtilities.invokeLater((Runnable)object);
    }

    public void closePackage() {
        if (this.isEmptyFrame()) {
            return;
        }
        this.classScroller.setViewportView(null);
        this.editor.removePackageEditorListener(this);
        this.editor.removeMouseListener(this);
        this.getObjectBench().removeAll(this.getProject().getUniqueId());
        this.getPackage().closeAllEditors();
        Project project = this.getProject();
        this.editor = null;
        this.pkg = null;
        if (PkgMgrFrame.getAllProjectFrames(project) == null) {
            Project.closeProject(project);
        }
        PkgMgrFrame pkgMgrFrame = this;
        if (pkgMgrFrame == null) {
            throw null;
        }
        Runnable runnable = new Runnable(pkgMgrFrame){
            private final /* synthetic */ PkgMgrFrame this$0;

            public void run() {
                this.this$0.enableFunctions(false);
                this.this$0.updateWindowTitle();
            }
            {
                this.this$0 = pkgMgrFrame;
                this.constructor$0(pkgMgrFrame);
            }

            private final void constructor$0(PkgMgrFrame pkgMgrFrame) {
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void show() {
        super.show();
        this.setState(0);
        this.toFront();
    }

    public Package getPackage() {
        return this.pkg;
    }

    public Project getProject() {
        return this.pkg.getProject();
    }

    public boolean isEmptyFrame() {
        return this.pkg == null;
    }

    protected String updateWindowTitle() {
        if (this.isEmptyFrame()) {
            this.setTitle("BlueJ");
            return "BlueJ";
        }
        String string = "BlueJ:  " + this.getProject().getProjectName();
        if (!this.getPackage().isUnnamedPackage()) {
            string = string + "  [" + this.getPackage().getQualifiedName() + "]";
        }
        this.setTitle(string);
        return string;
    }

    public void setStatus(String string) {
        if (this.statusbar != null) {
            this.statusbar.setText(string);
        }
    }

    public void clearStatus() {
        if (this.statusbar != null) {
            this.statusbar.setText(" ");
        }
    }

    public void setWaitCursor(boolean bl) {
        if (bl) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public ObjectBench getObjectBench() {
        return this.objbench;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.clearStatus();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void targetEvent(PackageEditorEvent packageEditorEvent) {
        int n = packageEditorEvent.getID();
        switch (n) {
            case 1: {
                this.callMethod(packageEditorEvent.getCallable());
                break;
            }
            case 2: {
                this.doRemove((Target)packageEditorEvent.getSource());
                break;
            }
            case 3: {
                this.openPackageTarget(packageEditorEvent.getName());
                break;
            }
            case 4: {
                this.runAppletTarget((Target)packageEditorEvent.getSource());
                break;
            }
            case 5: {
                this.putObjectOnBench(packageEditorEvent.getDebuggerObject(), packageEditorEvent.getFieldName(), packageEditorEvent.getInstanceName());
                break;
            }
        }
    }

    protected void handleAction(AWTEvent aWTEvent) {
        int n;
        Object object = aWTEvent.getSource();
        Integer n2 = (Integer)this.actions.get(object);
        int n3 = n = n2 != null ? n2 : -1;
        if (n != 1104 && n != 1105 && !this.isEmptyFrame()) {
            this.pkg.setState(0);
        }
        this.clearStatus();
        switch (n) {
            case 1000: {
                this.doNewProject();
                break;
            }
            case 1001: {
                this.doOpen();
                break;
            }
            case 1002: {
                this.doOpenNonBlueJ();
                break;
            }
            case 1003: {
                this.doClose(true);
                break;
            }
            case 1004: {
                this.getProject().saveAll();
                break;
            }
            case 1005: {
                this.getProject().saveAs(this);
                break;
            }
            case 1006: {
                this.doImport();
                break;
            }
            case 1007: {
                this.doExport();
                break;
            }
            case 1008: {
                this.pageSetup();
                break;
            }
            case 1009: {
                this.print();
                break;
            }
            case 1010: {
                this.handleQuit();
                break;
            }
            case 1100: {
                this.createNewClass();
                break;
            }
            case 1101: {
                this.createNewPackage();
                break;
            }
            case 1102: {
                this.doAddFromFile();
                break;
            }
            case 1103: {
                this.doRemove();
                break;
            }
            case 1104: {
                this.pkg.setState(1);
                this.setStatus(chooseUsesFrom);
                break;
            }
            case 1105: {
                this.pkg.setState(3);
                this.setStatus(chooseInhFrom);
                break;
            }
            case 1106: {
                this.pkg.setState(5);
                this.setStatus(chooseArrow);
                break;
            }
            case 1200: {
                this.pkg.compile();
                break;
            }
            case 1201: {
                this.compileSelected();
                break;
            }
            case 1202: {
                this.callLibraryClass();
                break;
            }
            case 1203: {
                this.pkg.rebuild();
                break;
            }
            case 1204: {
                String string = this.pkg.generateDocumentation();
                if (string == "") break;
                DialogManager.showText(this, string);
                break;
            }
            case 1205: {
                PrefMgrDialog.showDialog(this);
                break;
            }
            case 1300: {
                this.toggleShowUses(object);
                break;
            }
            case 1301: {
                this.toggleShowExtends(object);
                break;
            }
            case 1302: {
                ExecControls.showHide(true, true, null);
                break;
            }
            case 1400: 
            case 1401: 
            case 1402: 
            case 1403: 
            case 1404: 
            case 1405: 
            case 1406: 
            case 1407: 
            case 1408: 
            case 1409: {
                DialogManager.NYI(this);
                break;
            }
            case 1500: {
                this.handleAbout();
                break;
            }
            case 1501: {
                VersionCheckDialog versionCheckDialog = new VersionCheckDialog(this);
                break;
            }
            case 1502: {
                JOptionPane.showMessageDialog(this, new String[]{"BlueJ \u00a9 2000 Michael K\u00f6lling, John Rosenberg.", " ", "BlueJ is available free of charge and may be", "redistributed freely. It may not be sold for", "profit or included in other packages which", "are sold for profit without written authorisation."}, "BlueJ Copyright", 1);
                break;
            }
            case 1503: {
                this.showWebPage(bluejUrl);
                break;
            }
            case 1504: {
                this.showWebPage(tutorialUrl);
                break;
            }
            case 1505: {
                this.showWebPage(Config.getPropString("bluej.url.javaStdLib"));
                break;
            }
            default: {
                Debug.reportError("unknown command ID");
                break;
            }
        }
    }

    protected boolean doNewProject() {
        String string = FileUtility.getFileName(this, newpkgTitle, createLabel, false);
        if (string == null) {
            return false;
        }
        if (Project.createNewProject(string)) {
            Project project = Project.openProject(string);
            if (this.isEmptyFrame()) {
                this.openPackage(project.getPackage(""));
            } else {
                PkgMgrFrame pkgMgrFrame = PkgMgrFrame.createFrame(project.getPackage(""));
                DialogManager.tileWindow(pkgMgrFrame, this);
                pkgMgrFrame.show();
            }
        }
        return true;
    }

    private void doOpen() {
        Project project;
        File file = FileUtility.getPackageName(this);
        if (file != null && (project = Project.openProject(file.getAbsolutePath())) != null) {
            Package package_ = project.getPackage(project.getInitialPackageName());
            PkgMgrFrame pkgMgrFrame = PkgMgrFrame.findFrame(package_);
            if (pkgMgrFrame == null) {
                if (this.isEmptyFrame()) {
                    pkgMgrFrame = this;
                    this.openPackage(package_);
                } else {
                    pkgMgrFrame = PkgMgrFrame.createFrame(package_);
                    DialogManager.tileWindow(pkgMgrFrame, this);
                }
            }
            pkgMgrFrame.show();
        }
    }

    private void doOpenNonBlueJ() {
        File file = FileUtility.getNonBlueJDirectoryName(this);
        if (file == null) {
            return;
        }
        if (file != null) {
            if (Project.openProject(file.getAbsolutePath()) != null) {
                DialogManager.showError(this, "open-non-bluej-already-bluej");
                return;
            }
            Import.convertDirectory(file);
            Project project = Project.openProject(file.getAbsolutePath());
            if (project == null) {
                return;
            }
            Package package_ = project.getPackage(project.getInitialPackageName());
            PkgMgrFrame pkgMgrFrame = PkgMgrFrame.findFrame(package_);
            if (pkgMgrFrame == null) {
                if (this.isEmptyFrame()) {
                    pkgMgrFrame = this;
                    this.openPackage(package_);
                } else {
                    pkgMgrFrame = PkgMgrFrame.createFrame(package_);
                    DialogManager.tileWindow(pkgMgrFrame, this);
                }
            }
            pkgMgrFrame.show();
        }
    }

    public void doClose(boolean bl) {
        this.doSave();
        this.closePackage();
        if (PkgMgrFrame.frameCount() == 1) {
            if (bl) {
                this.updateWindowTitle();
            } else {
                this.doQuit();
            }
        } else {
            PkgMgrFrame.closeFrame(this);
        }
    }

    public void handleQuit() {
        int n = 0;
        if (PkgMgrFrame.frameCount() > 1) {
            n = DialogManager.askQuestion(this, "quit-all");
        }
        if (n == 0) {
            this.doQuit();
        }
    }

    private void doQuit() {
        PkgMgrFrame[] pkgMgrFrameArray = PkgMgrFrame.getAllFrames();
        int n = pkgMgrFrameArray.length - 1;
        while (n >= 0) {
            pkgMgrFrameArray[n].doSave();
            pkgMgrFrameArray[n].closePackage();
            PkgMgrFrame.closeFrame(pkgMgrFrameArray[n]);
            --n;
        }
        Main.exit();
    }

    protected void doSave() {
        if (this.isEmptyFrame()) {
            return;
        }
        Properties properties = new Properties();
        Dimension dimension = this.classScroller.getSize(null);
        ((Hashtable)properties).put("package.editor.width", Integer.toString(dimension.width));
        ((Hashtable)properties).put("package.editor.height", Integer.toString(dimension.height));
        Point point = this.getLocation();
        ((Hashtable)properties).put("package.editor.x", Integer.toString(point.x));
        ((Hashtable)properties).put("package.editor.y", Integer.toString(point.y));
        this.pkg.save(properties);
        this.setStatus(packageSaved);
    }

    private void doImport() {
        String string = FileUtility.getFileName(this, Config.getString("pkgmgr.importPkg.title"), Config.getString("pkgmgr.importPkg.buttonLabel"), true);
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (!file.isDirectory()) {
            return;
        }
        if (this.isEmptyFrame()) {
            return;
        }
        Object[] objectArray = FileUtility.recursiveCopyFile(new File(string), this.getPackage().getPath());
        if (objectArray != null) {
            ImportFailedDialog importFailedDialog = new ImportFailedDialog(this, objectArray);
            importFailedDialog.show();
        }
        Import.convertDirectory(this.getPackage().getPath());
        this.getProject().reloadAll();
    }

    private void doAddFromFile() {
        String string = FileUtility.getFileName(this, addClassTitle, addLabel, false, FileUtility.getJavaSourceFilter());
        if (string == null) {
            return;
        }
        File file = new File(string);
        int n = this.pkg.importFile(file);
        switch (n) {
            case 0: {
                this.editor.repaint();
                break;
            }
            case 1: {
                DialogManager.showError(this, "file-does-not-exist");
                break;
            }
            case 2: {
                DialogManager.showError(this, "cannot-import");
                break;
            }
            case 4: {
                DialogManager.showError(this, "duplicate-name");
                break;
            }
            case 3: {
                DialogManager.showError(this, "error-in-import");
                break;
            }
        }
    }

    private void doExport() {
        ExportManager exportManager = new ExportManager(this);
        exportManager.export();
    }

    public void pageSetup() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        pageFormat = printerJob.validatePage(printerJob.pageDialog(pageFormat));
    }

    private void print() {
        PackagePrinter packagePrinter = new PackagePrinter(this.pkg, pageFormat);
        packagePrinter.setPriority(Thread.currentThread().getPriority() - 1);
        packagePrinter.start();
    }

    public void handleAbout() {
        AboutBlue aboutBlue = new AboutBlue(this, Main.BLUEJ_VERSION);
        ((Component)aboutBlue).setVisible(true);
    }

    private void callMethod(CallableView callableView) {
        ResultWatcher resultWatcher = null;
        if (callableView instanceof ConstructorView) {
            PkgMgrFrame pkgMgrFrame = this;
            if (pkgMgrFrame == null) {
                throw null;
            }
            resultWatcher = new ResultWatcher(pkgMgrFrame){
                private final /* synthetic */ PkgMgrFrame this$0;

                public void putResult(DebuggerObject debuggerObject, String string) {
                    if (string == null || string.length() == 0) {
                        string = "result";
                    }
                    if (debuggerObject != null) {
                        ObjectWrapper objectWrapper = new ObjectWrapper(this.this$0, debuggerObject.getInstanceFieldObject(0), string);
                        this.this$0.getObjectBench().add(objectWrapper);
                    } else {
                        Debug.reportError("cannot get execution result");
                    }
                }
                {
                    this.this$0 = pkgMgrFrame;
                    this.constructor$0(pkgMgrFrame);
                }

                private final void constructor$0(PkgMgrFrame pkgMgrFrame) {
                }
            };
        } else if (callableView instanceof MethodView) {
            MethodView methodView = (MethodView)callableView;
            if (methodView.isMain()) {
                this.getProject().removeLocalClassLoader();
                this.getProject().removeRemoteClassLoaderLeavingBreakpoints();
            }
            if (!methodView.isVoid()) {
                PkgMgrFrame pkgMgrFrame = this;
                if (pkgMgrFrame == null) {
                    throw null;
                }
                resultWatcher = new ResultWatcher(pkgMgrFrame){
                    private final /* synthetic */ PkgMgrFrame this$0;

                    public void putResult(DebuggerObject debuggerObject, String string) {
                        ObjectViewer objectViewer = ObjectViewer.getViewer(false, debuggerObject, string, this.this$0.getPackage(), true, this.this$0);
                        BlueJEvent.raiseEvent(2, objectViewer.getResult());
                    }
                    {
                        this.this$0 = pkgMgrFrame;
                        this.constructor$0(pkgMgrFrame);
                    }

                    private final void constructor$0(PkgMgrFrame pkgMgrFrame) {
                    }
                };
            }
        }
        new Invoker(this, callableView, null, resultWatcher);
    }

    private void openPackageTarget(String string) {
        Package package_ = this.getPackage().getProject().getPackage(string);
        PkgMgrFrame pkgMgrFrame = PkgMgrFrame.findFrame(package_);
        if (pkgMgrFrame == null) {
            pkgMgrFrame = PkgMgrFrame.createFrame(package_);
            DialogManager.tileWindow(pkgMgrFrame, this);
        }
        pkgMgrFrame.show();
    }

    private void runAppletTarget(Target target) {
        if (target instanceof ClassTarget) {
            ClassTarget classTarget = (ClassTarget)target;
            classTarget.runApplet(this);
        }
    }

    private void putObjectOnBench(DebuggerObject debuggerObject, String string, String string2) {
        ObjectWrapper objectWrapper = new ObjectWrapper(this, debuggerObject, string);
        this.getObjectBench().add(objectWrapper);
        Debugger.debugger.addObjectToScope(this.getPackage().getId(), string2, string, objectWrapper.getName());
    }

    private void createNewClass() {
        String string;
        NewClassDialog newClassDialog = new NewClassDialog(this);
        boolean bl = newClassDialog.display();
        if (bl && (string = newClassDialog.getClassName()).length() > 0) {
            if (this.pkg.getTarget(string) != null) {
                DialogManager.showError(this, "duplicate-name");
                return;
            }
            ClassTarget classTarget = null;
            String string2 = newClassDialog.getTemplateName();
            classTarget = new ClassTarget(this.pkg, string, string2);
            classTarget.generateSkeleton();
            this.pkg.findSpaceForVertex(classTarget);
            this.pkg.addTarget(classTarget);
            this.editor.revalidate();
            this.editor.scrollRectToVisible(classTarget.getRectangle());
            this.editor.repaint();
        }
    }

    private void createNewPackage() {
        String string;
        NewPackageDialog newPackageDialog = new NewPackageDialog(this);
        boolean bl = newPackageDialog.display();
        if (bl && (string = newPackageDialog.getPackageName()).length() > 0) {
            if (this.pkg.getTarget(string) != null) {
                DialogManager.showError(this, "duplicate-name");
                return;
            }
            File file = new File(this.getPackage().getPath(), string);
            if (file.mkdir()) {
                File file2 = new File(file, "bluej.pkg");
                try {
                    if (file2.createNewFile()) {
                        PackageTarget packageTarget = new PackageTarget(this.pkg, string);
                        this.pkg.findSpaceForVertex(packageTarget);
                        this.pkg.addTarget(packageTarget);
                        this.editor.revalidate();
                        this.editor.scrollRectToVisible(packageTarget.getRectangle());
                        this.editor.repaint();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void doRemove(Target target) {
        if (target instanceof ClassTarget) {
            ClassTarget classTarget = (ClassTarget)target;
            this.removeClass(classTarget);
        } else if (target instanceof PackageTarget && !(target instanceof ParentPackageTarget)) {
            PackageTarget packageTarget = (PackageTarget)target;
            this.removePackage(packageTarget);
        }
    }

    public void doRemove() {
        Target target = this.pkg.getSelectedTarget();
        if (target == null) {
            DialogManager.showError(this, "no-class-selected");
        } else {
            this.doRemove(target);
        }
    }

    public void removeClass(ClassTarget classTarget) {
        int n = DialogManager.askQuestion(this, "really-remove-class");
        if (n == 0) {
            this.pkg.removeClass(classTarget);
        }
    }

    public void removePackage(PackageTarget packageTarget) {
        String string = packageTarget.getQualifiedName();
        PkgMgrFrame[] pkgMgrFrameArray = PkgMgrFrame.getAllProjectFrames(this.getProject(), string);
        if (pkgMgrFrameArray != null) {
            DialogManager.showError(this, "remove-package-open");
            return;
        }
        int n = DialogManager.askQuestion(this, "really-remove-package");
        if (n == 0) {
            this.pkg.removePackage(packageTarget);
        }
    }

    public void compileSelected() {
        Target target = this.pkg.getSelectedTarget();
        if (target == null) {
            DialogManager.showError(this, "no-class-selected");
        } else if (target instanceof ClassTarget) {
            ClassTarget classTarget = (ClassTarget)target;
            this.pkg.compile(classTarget);
        }
    }

    public void callLibraryClass() {
        if (this.libraryCallDialog == null) {
            this.libraryCallDialog = new LibraryCallDialog(this);
        }
        this.libraryCallDialog.setVisible(true);
    }

    public void toggleShowUses(Object object) {
        if (this.showUsesCheckbox.isSelected() != this.showUsesMenuItem.isSelected()) {
            if (object == this.showUsesMenuItem) {
                this.showUsesCheckbox.setSelected(this.showUsesMenuItem.isSelected());
            } else {
                this.showUsesMenuItem.setSelected(this.showUsesCheckbox.isSelected());
            }
            this.pkg.toggleShowUses();
            this.editor.repaint();
        }
    }

    public void toggleShowExtends(Object object) {
        if (this.showExtendsCheckbox.isSelected() != this.showExtendsMenuItem.isSelected()) {
            if (object == this.showExtendsMenuItem) {
                this.showExtendsCheckbox.setSelected(this.showExtendsMenuItem.isSelected());
            } else {
                this.showExtendsMenuItem.setSelected(this.showExtendsCheckbox.isSelected());
            }
            boolean bl = this.pkg.toggleShowExtends();
            this.editor.repaint();
        }
    }

    private void clearTerminal() {
        Terminal.getTerminal().clear();
    }

    public void blueJEvent(int n, Object object) {
        switch (n) {
            case 0: {
                this.setStatus(creatingVM);
                break;
            }
            case 1: {
                this.setStatus(creatingVMDone);
                break;
            }
            case 3: {
                this.executionStarted();
                break;
            }
            case 4: {
                this.executionFinished();
                break;
            }
            case 8: {
                this.executionHalted();
                break;
            }
            case 9: {
                this.executionHalted();
                break;
            }
            case 10: {
                this.executionContinued();
                break;
            }
            case 5: {
                this.setStatus(generatingDocu);
                break;
            }
            case 6: {
                this.setStatus(docuGenerated);
                break;
            }
            case 7: {
                this.setStatus(docuAborted);
                break;
            }
        }
    }

    public void executionStarted() {
        this.progressButton.setEnabled(true);
        Terminal.getTerminal().activate(true);
    }

    private void executionFinished() {
        this.progressButton.setEnabled(false);
        if (ExecControls.execControlsShown()) {
            ExecControls.getExecControls().updateThreads(null);
        }
        Terminal.getTerminal().activate(false);
        this.pkg.removeStepMarks();
    }

    private void executionHalted() {
        this.progressButton.setIcon(stoppedIcon);
    }

    private void executionContinued() {
        this.pkg.removeStepMarks();
        this.progressButton.setIcon(workingIcon);
    }

    public String toString() {
        String string = "PkgMgrFrame(): ";
        string = this.isEmptyFrame() ? string + "empty" : string + this.getPackage().toString() + " " + this.getProject().toString();
        return string;
    }

    private void showWebPage(String string) {
        if (Utility.openWebBrowser(string)) {
            this.setStatus(webBrowserMsg);
        } else {
            this.setStatus(webBrowserError);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.handleAction(itemEvent);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.handleAction(actionEvent);
    }

    private void makeButtonNotGrow(JButton jButton) {
        Dimension dimension = jButton.getMinimumSize();
        dimension.width = Integer.MAX_VALUE;
        jButton.setMaximumSize(dimension);
        jButton.setMargin(new Insets(2, 0, 2, 0));
    }

    private void makeFrame() {
        this.setFont(this.PkgMgrFont);
        ((Frame)this).setIconImage(Config.frameImage);
        this.setupMenus();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.setBorder(Config.generalBorderWithStatusBar);
        JPanel jPanel2 = new JPanel();
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        Object object = Config.getString("menu.edit." + EditCmds[0]);
        JComponent jComponent = new JButton((String)object);
        jComponent.setFont(this.PkgMgrFont);
        jComponent.setToolTipText(Config.getString("tooltip.newClass"));
        ((AbstractButton)jComponent).addActionListener(this);
        jComponent.setRequestFocusEnabled(false);
        this.makeButtonNotGrow((JButton)jComponent);
        this.buttonPanel.add(jComponent);
        this.buttonPanel.add(Box.createVerticalStrut(3));
        this.actions.put(jComponent, new Integer(1100));
        this.imgDependsButton = new JButton();
        this.imgDependsButton.setToolTipText(Config.getString("tooltip.newUses"));
        this.imgDependsButton.addActionListener(this);
        this.imgDependsButton.setRequestFocusEnabled(false);
        this.buttonPanel.add(this.imgDependsButton);
        this.buttonPanel.add(Box.createVerticalStrut(3));
        this.actions.put(this.imgDependsButton, new Integer(1104));
        this.imgExtendsButton = new JButton();
        this.imgExtendsButton.setToolTipText(Config.getString("tooltip.newExtends"));
        this.imgExtendsButton.addActionListener(this);
        this.imgExtendsButton.setRequestFocusEnabled(false);
        this.buttonPanel.add(this.imgExtendsButton);
        this.buttonPanel.add(Box.createVerticalStrut(3));
        this.actions.put(this.imgExtendsButton, new Integer(1105));
        this.setButtonImages();
        Object object2 = Config.getString("menu.tools." + ToolsCmds[0]);
        jComponent = new JButton((String)object2);
        jComponent.setFont(this.PkgMgrFont);
        jComponent.setToolTipText(Config.getString("tooltip.compile"));
        ((AbstractButton)jComponent).addActionListener(this);
        jComponent.setRequestFocusEnabled(false);
        this.makeButtonNotGrow((JButton)jComponent);
        this.buttonPanel.add(jComponent);
        this.actions.put(jComponent, new Integer(1200));
        this.viewPanel = new JPanel();
        this.viewPanel.setLayout(new BorderLayout());
        object = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.darkGray), Config.getString("pkgmgr.view.label"), 2, 3, this.PkgMgrFont);
        this.showPanel = new JPanel();
        this.showPanel.setLayout(new GridLayout(0, 1));
        this.showPanel.setBorder((Border)object);
        this.showUsesCheckbox = new JCheckBox(Config.getString("pkgmgr.view.usesLabel"), null, true);
        this.showUsesCheckbox.addItemListener(this);
        this.showUsesCheckbox.setFont(this.PkgMgrFont);
        this.showUsesCheckbox.setToolTipText(Config.getString("tooltip.showUses"));
        this.actions.put(this.showUsesCheckbox, new Integer(1300));
        this.showPanel.add(this.showUsesCheckbox);
        this.showExtendsCheckbox = new JCheckBox(Config.getString("pkgmgr.view.inheritLabel"), null, true);
        this.showExtendsCheckbox.addItemListener(this);
        this.showExtendsCheckbox.setFont(this.PkgMgrFont);
        this.showExtendsCheckbox.setToolTipText(Config.getString("tooltip.showExtends"));
        this.actions.put(this.showExtendsCheckbox, new Integer(1301));
        this.showPanel.add(this.showExtendsCheckbox);
        this.viewPanel.add("Center", this.showPanel);
        this.progressButton = new JButton(workingIcon);
        this.progressButton.setDisabledIcon(notWorkingIcon);
        this.progressButton.setMargin(new Insets(0, 0, 0, 0));
        this.progressButton.setToolTipText(Config.getString("tooltip.progress"));
        this.progressButton.addActionListener(this);
        this.actions.put(this.progressButton, new Integer(1302));
        this.progressButton.setEnabled(false);
        this.progressButton.setAlignmentX(0.5f);
        this.buttonPanel.setAlignmentX(0.5f);
        this.viewPanel.setAlignmentX(0.5f);
        this.viewPanel.setMaximumSize(this.viewPanel.getMinimumSize());
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(this.buttonPanel);
        jPanel2.add(Box.createVerticalGlue());
        jPanel2.add(this.viewPanel);
        jPanel2.add(Box.createVerticalStrut(4));
        jPanel2.add(this.progressButton);
        jPanel2.add(Box.createVerticalStrut(3));
        jComponent = new JPanel();
        jComponent.setLayout(new BorderLayout());
        this.objbench = new ObjectBench();
        object2 = new JScrollPane(this.objbench);
        jComponent.add("North", (Component)object2);
        jComponent.add("South", this.statusbar);
        jPanel.add("West", jPanel2);
        jPanel.add("South", jComponent);
        this.classScroller = new JScrollPane();
        jPanel.add((Component)this.classScroller, "Center");
        this.classScroller.setPreferredSize(new Dimension(420, 300));
        this.getContentPane().add(jPanel);
        this.pack();
        PkgMgrFrame pkgMgrFrame = this;
        if (pkgMgrFrame == null) {
            throw null;
        }
        this.addWindowListener(new WindowAdapter(pkgMgrFrame){
            private final /* synthetic */ PkgMgrFrame this$0;

            public void windowClosing(WindowEvent windowEvent) {
                PkgMgrFrame pkgMgrFrame = (PkgMgrFrame)windowEvent.getWindow();
                pkgMgrFrame.doClose(false);
            }
            {
                this.this$0 = pkgMgrFrame;
                this.constructor$0(pkgMgrFrame);
            }

            private final void constructor$0(PkgMgrFrame pkgMgrFrame) {
            }
        });
        if (this.isEmptyFrame()) {
            this.enableFunctions(false);
        }
    }

    private void setButtonImages() {
        String string = "image.build.depends";
        String string2 = "image.build.extends";
        String string3 = ".uml";
        if (PrefMgr.isUML()) {
            string = string + string3;
            string2 = string2 + string3;
        }
        ImageIcon imageIcon = Config.getImageAsIcon(string);
        ImageIcon imageIcon2 = Config.getImageAsIcon(string2);
        this.imgDependsButton.setIcon(imageIcon);
        this.imgExtendsButton.setIcon(imageIcon2);
        this.makeButtonNotGrow(this.imgExtendsButton);
        this.makeButtonNotGrow(this.imgDependsButton);
    }

    private void setupMenus() {
        this.menubar = new JMenuBar();
        JMenu jMenu = null;
        int n = 0;
        while (n < CmdTypes.length) {
            int n2 = 0;
            String string = "menu." + CmdTypeNames[n];
            String string2 = Config.getString(string);
            if (CmdTypes[n] != 1400) {
                jMenu = new JMenu(string2);
                int n3 = 0;
                while (n3 < CmdStrings[n].length) {
                    JMenuItem jMenuItem;
                    int n4 = CmdTypes[n] + n3;
                    String string3 = string + "." + CmdStrings[n][n3];
                    String string4 = Config.getString(string3);
                    ImageIcon imageIcon = Config.getImageAsIcon("image." + CmdTypeNames[n] + "." + CmdStrings[n][n3]);
                    KeyStroke keyStroke = CmdKeys[n][n3];
                    switch (n4) {
                        case 1300: {
                            this.showUsesMenuItem = new JCheckBoxMenuItem(string4, true);
                            jMenuItem = this.showUsesMenuItem;
                            jMenuItem.addActionListener(this);
                            if (keyStroke == null) break;
                            jMenuItem.setAccelerator(keyStroke);
                            break;
                        }
                        case 1301: {
                            this.showExtendsMenuItem = new JCheckBoxMenuItem(string4, true);
                            jMenuItem = this.showExtendsMenuItem;
                            jMenuItem.addActionListener(this);
                            if (keyStroke == null) break;
                            jMenuItem.setAccelerator(keyStroke);
                            break;
                        }
                        case 1302: {
                            jMenuItem = new JCheckBoxMenuItem(string4, false);
                            ((AbstractButton)jMenuItem).setModel(new ExecControlButtonModel());
                            if (keyStroke == null) break;
                            jMenuItem.setAccelerator(keyStroke);
                            break;
                        }
                        case 1303: {
                            jMenuItem = new JCheckBoxMenuItem(string4, false);
                            ((AbstractButton)jMenuItem).setModel(new TerminalButtonModel());
                            if (keyStroke == null) break;
                            jMenuItem.setAccelerator(keyStroke);
                            break;
                        }
                        default: {
                            jMenuItem = new JMenuItem(string4);
                            jMenuItem.addActionListener(this);
                            if (keyStroke == null) break;
                            jMenuItem.setAccelerator(keyStroke);
                            break;
                        }
                    }
                    if (CmdTypes[n] == 1400) {
                        jMenuItem.setEnabled(false);
                    }
                    if (imageIcon != null) {
                        jMenuItem.setIcon(imageIcon);
                    }
                    if (CmdTypes[n] != 1400) {
                        jMenu.add(jMenuItem);
                        this.actions.put(jMenuItem, new Integer(n4));
                    }
                    if (n2 < CmdSeparators[n].length && CmdSeparators[n][n2] == n4) {
                        jMenu.addSeparator();
                        ++n2;
                    }
                    ++n3;
                }
                if (CmdTypes[n] == 1500) {
                    this.menubar.add(Box.createHorizontalGlue());
                }
                this.menubar.add(jMenu);
            }
            ++n;
        }
        if (jMenu != null) {
            // empty if block
        }
        this.setJMenuBar(this.menubar);
    }

    protected void enableFunctions(boolean bl) {
        Component[] componentArray = this.buttonPanel.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            componentArray[n].setEnabled(bl);
            ++n;
        }
        componentArray = this.viewPanel.getComponents();
        n = 0;
        while (n < componentArray.length) {
            componentArray[n].setEnabled(bl);
            ++n;
        }
        componentArray = this.showPanel.getComponents();
        n = 0;
        while (n < componentArray.length) {
            componentArray[n].setEnabled(bl);
            ++n;
        }
        MenuElement[] menuElementArray = this.menubar.getSubElements();
        JMenu jMenu = null;
        List<String> list = Arrays.asList(Config.getString("menu.package.new"), Config.getString("menu.package.open"), Config.getString("menu.package.openNonBlueJ"), Config.getString("menu.package.quit"), Config.getString("menu.tools.browse"), Config.getString("menu.tools.preferences"), Config.getString("menu.view.showExecControls"), Config.getString("menu.view.showTerminal"), Config.getString("menu.help.about"), Config.getString("menu.help.versionCheck"), Config.getString("menu.help.copyright"), Config.getString("menu.help.website"), Config.getString("menu.help.tutorial"), Config.getString("menu.help.standardApi"));
        int n2 = 0;
        while (n2 < menuElementArray.length) {
            if (menuElementArray[n2] != null) {
                jMenu = (JMenu)menuElementArray[n2];
                int n3 = 0;
                while (n3 < jMenu.getItemCount()) {
                    String string;
                    JMenuItem jMenuItem = jMenu.getItem(n3);
                    if (jMenuItem != null && !list.contains(string = jMenuItem.getText())) {
                        jMenuItem.setEnabled(bl);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
    }

    private PkgMgrFrame() {
        this.makeFrame();
        this.updateWindowTitle();
        this.setStatus(Main.BLUEJ_VERSION_TITLE);
    }
}

