/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJEvent;
import bluej.BlueJEventListener;
import bluej.Config;
import bluej.classmgr.ClassMgr;
import bluej.classmgr.ClassPathEntry;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerClassLoader;
import bluej.debugger.DebuggerThread;
import bluej.pkgmgr.DocuGenerator;
import bluej.pkgmgr.ExportManager;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.JavaNames;
import bluej.views.View;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Project
implements BlueJEventListener {
    private static final String saveAsTitle = Config.getString("pkgmgr.saveAs.title");
    private static final String saveLabel = Config.getString("pkgmgr.saveAs.buttonLabel");
    private static Map projects = new HashMap();
    private File projectDir;
    private Map packages;
    private ClassLoader loader;
    private DebuggerClassLoader debuggerLoader;
    private String initialPackageName = "";
    private DocuGenerator docuGenerator;

    public static Project openProject(String string) {
        String string2;
        Object object;
        Object object2;
        File file;
        block12: {
            try {
                file = new File(string).getCanonicalFile();
                if (!file.isFile()) break block12;
                if (file.getName().equals("bluej.pkg")) {
                    file = file.getParentFile();
                    break block12;
                }
                return null;
            }
            catch (IOException iOException) {
                Debug.message("could not resolve directory " + string);
                iOException.printStackTrace();
                return null;
            }
        }
        if (Package.isBlueJPackage(file)) {
            object2 = file;
            object = null;
            string2 = "";
            while (object2 != null && Package.isBlueJPackage((File)object2)) {
                if (object != null) {
                    string2 = "." + ((File)object).getName() + string2;
                }
                object = object2;
                object2 = ((File)object2).getParentFile();
            }
            if (string2.length() > 0 && string2.charAt(0) == '.') {
                string2 = string2.substring(1);
            }
        } else {
            return null;
        }
        File file2 = object;
        object2 = (Project)projects.get(file2);
        if (object2 == null) {
            object2 = new Project(file2);
            projects.put(file2, object2);
        }
        if (string2.equals("")) {
            object = ((Project)object2).getPackage("");
            while (object != null) {
                Package package_ = ((Package)object).getBoringSubPackage();
                if (package_ == null) break;
                object = package_;
            }
            ((Project)object2).initialPackageName = ((Package)object).getQualifiedName();
        } else {
            ((Project)object2).initialPackageName = string2;
        }
        return object2;
    }

    public static void closeProject(Project project) {
        PkgMgrFrame[] pkgMgrFrameArray = PkgMgrFrame.getAllProjectFrames(project);
        if (pkgMgrFrameArray != null) {
            int n = 0;
            while (n < pkgMgrFrameArray.length) {
                pkgMgrFrameArray[n].doClose(true);
                ++n;
            }
        }
        BlueJEvent.removeListener(project);
        projects.remove(project.getProjectDir());
    }

    public static boolean createNewProject(String string) {
        if (string != null) {
            File file = new File(string);
            if (file.exists()) {
                DialogManager.showError(null, "directory-exists");
                return false;
            }
            if (file.mkdir()) {
                File file2 = new File(file, "bluej.pkg");
                File file3 = new File(file, "README.TXT");
                try {
                    if (file2.createNewFile()) {
                        if (FileUtility.copyFile(Config.getTemplateFile("readme"), file3)) {
                            return true;
                        }
                        Debug.message("could not copy readme template");
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static int getOpenProjectCount() {
        return projects.size();
    }

    public static Project getProject() {
        Collection collection;
        Iterator iterator;
        if (projects.size() == 1 && (iterator = (collection = projects.values()).iterator()).hasNext()) {
            return (Project)iterator.next();
        }
        return null;
    }

    public String getProjectName() {
        return this.projectDir.getName();
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public String getUniqueId() {
        return "BJID" + this.getProjectDir().getPath();
    }

    public String getInitialPackageName() {
        return this.initialPackageName;
    }

    public Package getPackage(String string) {
        Package package_ = (Package)this.packages.get(string);
        if (package_ != null) {
            return package_;
        }
        if (string.length() > 0) {
            Package package_2;
            try {
                Package package_3 = this.getPackage(JavaNames.getPrefix(string));
                if (package_3 != null) {
                    package_2 = new Package(this, JavaNames.getBase(string), package_3);
                    this.packages.put(string, package_2);
                } else {
                    package_2 = null;
                }
            }
            catch (IOException iOException) {
                package_2 = null;
            }
            return package_2;
        }
        throw new IllegalStateException("Project.getPackage()");
    }

    private List getPackageNames(Package package_) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(package_.getQualifiedName());
        List list = package_.getChildren();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Package package_2 = (Package)iterator.next();
                linkedList.addAll(this.getPackageNames(package_2));
            }
        }
        return linkedList;
    }

    public List getPackageNames() {
        return this.getPackageNames(this.getPackage(""));
    }

    public String generateDocumentation() {
        return this.docuGenerator.generateProjectDocu();
    }

    public void saveAll() {
        PkgMgrFrame[] pkgMgrFrameArray = PkgMgrFrame.getAllProjectFrames(this);
        int n = 0;
        while (n < pkgMgrFrameArray.length) {
            pkgMgrFrameArray[n].doSave();
            ++n;
        }
    }

    public void reloadAll() {
        Iterator iterator = this.packages.values().iterator();
        while (iterator.hasNext()) {
            Package package_ = (Package)iterator.next();
            package_.reload();
        }
    }

    public void saveAs(PkgMgrFrame pkgMgrFrame) {
        String string = FileUtility.getFileName(pkgMgrFrame, saveAsTitle, saveLabel, false);
        if (string != null) {
            this.saveAll();
            new ExportManager(pkgMgrFrame).saveAs(this.getProjectDir().getPath(), string);
            Project.closeProject(this);
            Project project = Project.openProject(string);
            if (project != null) {
                Package package_ = project.getPackage(project.getInitialPackageName());
                PkgMgrFrame pkgMgrFrame2 = PkgMgrFrame.createFrame(package_);
                pkgMgrFrame2.show();
            } else {
                Debug.message("could not open package under new name");
            }
        }
    }

    private synchronized ClassLoader getLocalClassLoader() {
        if (this.loader == null) {
            this.loader = ClassMgr.getLoader(this.getProjectDir());
        }
        return this.loader;
    }

    synchronized void removeLocalClassLoader() {
        if (this.loader != null) {
            PkgMgrFrame[] pkgMgrFrameArray = PkgMgrFrame.getAllProjectFrames(this);
            int n = 0;
            while (n < pkgMgrFrameArray.length) {
                pkgMgrFrameArray[n].getObjectBench().removeAll(this.getUniqueId());
                ++n;
            }
            View.removeAll(this.loader);
            this.loader = null;
        }
    }

    public synchronized DebuggerClassLoader getRemoteClassLoader() {
        if (this.debuggerLoader == null) {
            this.debuggerLoader = Debugger.debugger.createClassLoader(this.getUniqueId(), this.getProjectDir().getPath());
        }
        return this.debuggerLoader;
    }

    synchronized void removeRemoteClassLoader() {
        if (this.debuggerLoader != null) {
            Debugger.debugger.removeClassLoader(this.debuggerLoader);
            this.debuggerLoader = null;
        }
    }

    synchronized void removeRemoteClassLoaderLeavingBreakpoints() {
        if (this.debuggerLoader != null) {
            Debugger.debugger.saveBreakpoints();
            Debugger.debugger.removeClassLoader(this.debuggerLoader);
            this.debuggerLoader = null;
            this.getRemoteClassLoader();
            Debugger.debugger.restoreBreakpoints(this.debuggerLoader);
        }
    }

    public Class loadClass(String string) {
        try {
            return this.getLocalClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    public String getClassPath() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = ClassMgr.getClassMgr().getAllClassPathEntries();
        while (iterator.hasNext()) {
            ClassPathEntry classPathEntry = (ClassPathEntry)iterator.next();
            stringBuffer.append(classPathEntry.getPath());
            stringBuffer.append(File.pathSeparator);
        }
        stringBuffer.append(this.getProjectDir().getPath());
        return stringBuffer.toString();
    }

    public String convertPathToPackageName(String string) {
        try {
            File file = new File(string).getCanonicalFile();
            File file2 = null;
            String string2 = "";
            while ((file2 = file.getParentFile()) != null) {
                if (file.equals(this.getProjectDir())) {
                    return string2;
                }
                if (string2 == "") {
                    string2 = file.getName();
                    int n = string2.indexOf(46);
                    if (n >= 0) {
                        string2 = string2.substring(0, n);
                    }
                } else {
                    string2 = file.getName() + "." + string2;
                }
                file = file2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void blueJEvent(int n, Object object) {
        switch (n) {
            case 8: {
                DebuggerThread debuggerThread = (DebuggerThread)object;
                if (debuggerThread.getParam() != this) break;
                this.hitBreakpoint(debuggerThread);
                break;
            }
            case 9: {
                DebuggerThread debuggerThread = (DebuggerThread)object;
                if (debuggerThread == null || debuggerThread.getParam() != this) break;
                this.hitHalt(debuggerThread);
                break;
            }
            case 11: {
                DebuggerThread debuggerThread = (DebuggerThread)object;
                if (debuggerThread.getParam() != this) break;
                this.showSourcePosition(debuggerThread, false);
                break;
            }
        }
    }

    private void hitBreakpoint(DebuggerThread debuggerThread) {
        String string = JavaNames.getPrefix(debuggerThread.getClass(0));
        Package package_ = this.getPackage(string);
        if (package_ != null) {
            package_.hitBreakpoint(debuggerThread);
        }
    }

    private void hitHalt(DebuggerThread debuggerThread) {
        String string = JavaNames.getPrefix(debuggerThread.getClass(0));
        Package package_ = this.getPackage(string);
        if (package_ != null) {
            package_.hitHalt(debuggerThread);
        }
    }

    private void showSourcePosition(DebuggerThread debuggerThread, boolean bl) {
        String string = JavaNames.getPrefix(debuggerThread.getClass(0));
        Package package_ = this.getPackage(string);
        if (package_ != null) {
            package_.showSourcePosition(debuggerThread, bl);
        }
    }

    private Project(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.projectDir = file;
        this.packages = new TreeMap();
        try {
            this.packages.put("", new Package(this));
        }
        catch (IOException iOException) {
            Debug.reportError("could not read package file (unnamed package)");
        }
        BlueJEvent.addListener(this);
        this.docuGenerator = new DocuGenerator(this);
    }
}

