/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.utility.DialogManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class RunAppletDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    static final String okay = Config.getString("okay");
    static final String cancel = Config.getString("cancel");
    static final String runAppletTitle = Config.getString("pkgmgr.runApplet.title");
    static final String createWebPage = Config.getString("pkgmgr.runApplet.webPageLabel");
    static final String radioButtonText1 = Config.getString("pkgmgr.runApplet.webPage");
    static final String radioButtonText2 = Config.getString("pkgmgr.runApplet.appletviewer");
    static final String radioButtonText3 = Config.getString("pkgmgr.runApplet.webBrowser");
    static final String heightLbl = Config.getString("pkgmgr.runApplet.heightLbl");
    static final String widthLbl = Config.getString("pkgmgr.runApplet.widthLbl");
    static final String newParameterLbl = Config.getString("pkgmgr.runApplet.newParameterLbl");
    static final String appletParameterLbl = Config.getString("pkgmgr.runApplet.appletParameterLbl");
    static final String nameLbl = Config.getString("pkgmgr.runApplet.nameLbl");
    static final String valueLbl = Config.getString("pkgmgr.runApplet.valueLbl");
    static final int EXEC_APPLETVIEWER = 0;
    static final int EXEC_WEBBROWSER = 1;
    static final int GENERATE_PAGE_ONLY = 2;
    private static final String ADD_BUTTON = Config.getString("classmgr.add");
    private static final String DELETE_BUTTON = Config.getString("classmgr.delete");
    private static final String PARAM_NAME = "PARAM NAME";
    private static final String VALUE = "VALUE";
    private String webPageName;
    private JList parameterList;
    private JTextField paramNameField;
    private JTextField paramValueField;
    private JTextField heightField;
    private JTextField widthField;
    private JButton addButton;
    private JButton deleteButton;
    private JFrame parent;
    private DefaultListModel appletParameters;
    private JRadioButton generateWebPage;
    private JRadioButton runAppletViewer;
    private JRadioButton runWebBrowser;
    private boolean ok;

    private void addGridBagComponent(Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Component component, int n, int n2, int n3, int n4, int n5) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.anchor = n5;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        if (!container.getLayout().equals(gridBagLayout)) {
            container.setLayout(gridBagLayout);
        }
        container.add(component);
    }

    public boolean display() {
        this.ok = false;
        this.pack();
        ((Component)this).setVisible(true);
        return this.ok;
    }

    public String getWebPageName() {
        return this.webPageName;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (okay.equals(string)) {
            this.doOK();
        } else if (cancel.equals(string)) {
            this.doCancel();
        } else if (ADD_BUTTON.equals(string)) {
            if (!this.paramNameField.getText().equals("") && !this.paramValueField.getText().equals("")) {
                this.addAppletParameter();
                this.paramNameField.requestFocus();
            }
        } else if (DELETE_BUTTON.equals(string)) {
            this.appletParameters.remove(this.parameterList.getSelectedIndex());
            this.deleteButton.setEnabled(false);
        }
    }

    public void addAppletParameter() {
        String string = "<PARAM NAME = " + this.paramNameField.getText() + "   " + VALUE + " = " + this.paramValueField.getText() + ">";
        this.appletParameters.addElement(string);
        this.paramNameField.setText("");
        this.paramValueField.setText("");
    }

    public void doOK() {
        if (!this.checkFieldsAreValid()) {
            DialogManager.showError(this.parent, "applet-height-width");
        } else {
            this.ok = true;
            ((Component)this).setVisible(false);
        }
    }

    public void doCancel() {
        this.ok = false;
        ((Component)this).setVisible(false);
    }

    public boolean checkFieldsAreValid() {
        return !this.widthField.getText().equals("") && !this.heightField.getText().equals("");
    }

    public String getAppletHeight() {
        return this.heightField.getText();
    }

    public String getAppletWidth() {
        return this.widthField.getText();
    }

    public void setAppletHeight(int n) {
        this.heightField.setText(String.valueOf(n));
    }

    public void setAppletWidth(int n) {
        this.widthField.setText(String.valueOf(n));
    }

    public String[] getAppletParameters() {
        Object[] objectArray = this.appletParameters.toArray();
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            stringArray[n] = (String)objectArray[n];
            ++n;
        }
        return stringArray;
    }

    public void setAppletParameters(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.appletParameters.addElement(stringArray[n]);
            ++n;
        }
    }

    public int getAppletExecutionOption() {
        if (this.runAppletViewer.isSelected()) {
            return 0;
        }
        if (this.runWebBrowser.isSelected()) {
            return 1;
        }
        return 2;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!this.parameterList.isSelectionEmpty()) {
            this.deleteButton.setEnabled(true);
        }
    }

    static /* synthetic */ boolean access$0(RunAppletDialog runAppletDialog) {
        return runAppletDialog.ok;
    }

    static /* synthetic */ void access$1(RunAppletDialog runAppletDialog, boolean bl) {
        runAppletDialog.ok = bl;
    }

    public RunAppletDialog(JFrame jFrame, String string) {
        super(jFrame, runAppletTitle, true);
        this.parent = jFrame;
        RunAppletDialog runAppletDialog = this;
        if (runAppletDialog == null) {
            throw null;
        }
        this.addWindowListener(new WindowAdapter(runAppletDialog){
            private final /* synthetic */ RunAppletDialog this$0;

            public void windowClosing(WindowEvent windowEvent) {
                RunAppletDialog.access$1(this.this$0, false);
                ((Component)this.this$0).setVisible(false);
            }
            {
                this.this$0 = runAppletDialog;
                this.constructor$0(runAppletDialog);
            }

            private final void constructor$0(RunAppletDialog runAppletDialog) {
            }
        });
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setBorder(Config.dialogBorder);
        this.appletParameters = new DefaultListModel();
        this.webPageName = string + ".html";
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JButton jButton = new JButton(okay);
        jPanel2.add(jButton);
        jButton.addActionListener(this);
        this.getRootPane().setDefaultButton(jButton);
        jButton = new JButton(cancel);
        jPanel2.add(jButton);
        jButton.addActionListener(this);
        this.getContentPane().add("South", jPanel2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        JPanel jPanel3 = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        jPanel4.setLayout(new GridLayout(3, 1));
        this.generateWebPage = new JRadioButton(radioButtonText1, false);
        jPanel4.add(this.generateWebPage);
        buttonGroup.add(this.generateWebPage);
        this.runAppletViewer = new JRadioButton(radioButtonText2, true);
        jPanel4.add(this.runAppletViewer);
        buttonGroup.add(this.runAppletViewer);
        this.runWebBrowser = new JRadioButton(radioButtonText3, false);
        jPanel4.add(this.runWebBrowser);
        buttonGroup.add(this.runWebBrowser);
        this.getContentPane().add("North", jPanel4);
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.darkGray), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.addGridBagComponent(jPanel3, gridBagLayout, gridBagConstraints, new JLabel(heightLbl), 0, 1, 1, 1, 13);
        this.heightField = new JTextField(5);
        this.addGridBagComponent(jPanel3, gridBagLayout, gridBagConstraints, this.heightField, 1, 1, 1, 1, 17);
        this.addGridBagComponent(jPanel3, gridBagLayout, gridBagConstraints, new JLabel(widthLbl), 2, 1, 1, 1, 13);
        this.widthField = new JTextField(5);
        this.addGridBagComponent(jPanel3, gridBagLayout, gridBagConstraints, this.widthField, 3, 1, 1, 1, 17);
        this.addGridBagComponent(jPanel3, gridBagLayout, gridBagConstraints, new JLabel(newParameterLbl), 4, 2, 2, 1, 10);
        this.parameterList = new JList(this.appletParameters);
        this.parameterList.setSelectionMode(0);
        this.parameterList.setModel(this.appletParameters);
        this.parameterList.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.parameterList);
        jScrollPane.setColumnHeaderView(new JLabel(appletParameterLbl, 0));
        this.addGridBagComponent(jPanel3, gridBagLayout, gridBagConstraints, jScrollPane, 0, 2, 4, 4, 10);
        this.addGridBagComponent(jPanel3, gridBagLayout, gridBagConstraints, new JLabel(nameLbl), 4, 3, 1, 1, 17);
        this.paramNameField = new JTextField(16);
        this.addGridBagComponent(jPanel3, gridBagLayout, gridBagConstraints, this.paramNameField, 5, 3, 1, 1, 17);
        this.addGridBagComponent(jPanel3, gridBagLayout, gridBagConstraints, new JLabel(valueLbl), 4, 4, 1, 1, 17);
        this.paramValueField = new JTextField(16);
        this.addGridBagComponent(jPanel3, gridBagLayout, gridBagConstraints, this.paramValueField, 5, 4, 1, 1, 17);
        this.deleteButton = new JButton(DELETE_BUTTON);
        this.deleteButton.addActionListener(this);
        this.addGridBagComponent(jPanel3, gridBagLayout, gridBagConstraints, this.deleteButton, 4, 5, 1, 1, 13);
        this.deleteButton.setEnabled(false);
        this.addButton = new JButton(ADD_BUTTON);
        this.addButton.addActionListener(this);
        this.addGridBagComponent(jPanel3, gridBagLayout, gridBagConstraints, this.addButton, 5, 5, 1, 1, 17);
        this.addButton.setEnabled(true);
        this.getContentPane().add("Center", jPanel3);
        DialogManager.centreDialog(this);
    }
}

