/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.graph.GraphEditor;
import bluej.graph.Vertex;
import bluej.pkgmgr.Package;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Utility;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public abstract class Target
extends Vertex {
    static final int MIN_WIDTH = 60;
    static final int MIN_HEIGHT = 40;
    static final int DEF_WIDTH = 80;
    static final int DEF_HEIGHT = 50;
    static final int ARR_HORIZ_DIST = 5;
    static final int ARR_VERT_DIST = 10;
    static final int GRID_SIZE = 10;
    static final int HANDLE_SIZE = 20;
    static final int TEXT_HEIGHT = 16;
    static final int TEXT_BORDER = 8;
    static final int SHAD_SIZE = 4;
    static final Color textbg = Config.getItemColour("colour.text.bg");
    static final Color shadowCol = Config.getItemColour("colour.target.shadow");
    static final Color graphbg = Config.getItemColour("colour.graph.background");
    static final int S_NORMAL = 0;
    static final int S_INVALID = 1;
    static final int S_COMPILING = 2;
    static final int F_SELECTED = 1;
    static final int F_QUEUED = 2;
    static FontRenderContext FRC = new FontRenderContext(new AffineTransform(), false, false);
    private String identifierName;
    private String displayName;
    private Package pkg;
    protected boolean resizing;
    protected boolean disabled;
    protected int drag_start_x;
    protected int drag_start_y;
    protected int state = 1;
    protected int flags = 0;
    Rectangle oldRect;

    protected static int calculateWidth(String string) {
        int n = 0;
        if (string != null) {
            n = (int)PrefMgr.getTargetFont().getStringBounds(string, FRC).getWidth();
        }
        if (n + 20 <= 80) {
            return 80;
        }
        return (n + 29) / 10 * 10;
    }

    public void load(Properties properties, String string) throws NumberFormatException {
        this.x = Integer.parseInt(properties.getProperty(string + ".x"));
        this.y = Integer.parseInt(properties.getProperty(string + ".y"));
        this.width = Integer.parseInt(properties.getProperty(string + ".width"));
        this.height = Integer.parseInt(properties.getProperty(string + ".height"));
    }

    public void save(Properties properties, String string) {
        ((Hashtable)properties).put(string + ".x", String.valueOf(this.x));
        ((Hashtable)properties).put(string + ".y", String.valueOf(this.y));
        ((Hashtable)properties).put(string + ".width", String.valueOf(this.width));
        ((Hashtable)properties).put(string + ".height", String.valueOf(this.height));
        ((Hashtable)properties).put(string + ".name", this.getIdentifierName());
    }

    public abstract boolean copyFiles(String var1);

    public Package getPackage() {
        return this.pkg;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getIdentifierName() {
        return this.identifierName;
    }

    public void setIdentifierName(String string) {
        this.identifierName = string;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        if (this.state == 0 && n == 1) {
            this.pkg.invalidate(this);
        }
        this.state = n;
        this.repaint();
    }

    public void setFlag(int n) {
        if ((this.flags & n) != n) {
            this.flags |= n;
            this.repaint();
        }
    }

    public void unsetFlag(int n) {
        if ((this.flags & n) != 0) {
            this.flags &= ~n;
            this.repaint();
        }
    }

    public void toggleFlag(int n) {
        this.flags ^= n;
        this.repaint();
    }

    public boolean isFlagSet(int n) {
        return (this.flags & n) == n;
    }

    public boolean isResizable() {
        return true;
    }

    public boolean isMoveable() {
        return true;
    }

    public boolean isSaveable() {
        return true;
    }

    public boolean isSelectable() {
        return true;
    }

    abstract Color getBackgroundColour();

    abstract Color getBorderColour();

    abstract Color getTextColour();

    abstract Font getFont();

    public void repaint() {
        if (this.pkg.getEditor() != null) {
            this.pkg.getEditor().repaint(this.x, this.y, this.width + 4, this.height + 4);
        }
    }

    public void draw(Graphics2D graphics2D) {
        graphics2D.setColor(this.getBackgroundColour());
        graphics2D.fillRect(0, 0, this.width, this.height);
        graphics2D.setColor(shadowCol);
        this.drawShadow(graphics2D);
        graphics2D.setColor(this.getBorderColour());
        this.drawBorders(graphics2D);
    }

    void drawShadow(Graphics2D graphics2D) {
        graphics2D.fillRect(4, this.height, this.width, 4);
        graphics2D.fillRect(this.width, 4, 4, this.height);
    }

    void drawBorders(Graphics2D graphics2D) {
        int n = (this.flags & 1) == 0 ? 1 : 4;
        Utility.drawThickRect(graphics2D, 0, 0, this.width, this.height, n);
        graphics2D.drawLine(this.width - 20 - 2, this.height, this.width, this.height - 20 - 2);
        graphics2D.drawLine(this.width - 20 + 2, this.height, this.width, this.height - 20 + 2);
    }

    public void mousePressed(MouseEvent mouseEvent, int n, int n2, GraphEditor graphEditor) {
        if (this.pkg.getState() != 0) {
            this.pkg.targetSelected(this);
            return;
        }
        this.resizing = n - this.x + n2 - this.y >= this.width + this.height - 20;
        this.drag_start_x = n;
        this.drag_start_y = n2;
        this.oldRect = new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void mouseReleased(MouseEvent mouseEvent, int n, int n2, GraphEditor graphEditor) {
        Rectangle rectangle = new Rectangle(this.x, this.y, this.width, this.height);
        if (this.pkg.getState() == 2 || this.pkg.getState() == 4) {
            Target target = null;
            Enumeration enumeration = this.pkg.getVertices();
            while (target == null && enumeration.hasMoreElements()) {
                Target target2 = (Target)enumeration.nextElement();
                if (target2.x > n || n >= target2.x + target2.width || target2.y > n2 || n2 >= target2.y + target2.height) continue;
                target = target2;
            }
            if (target != null && target != this) {
                this.pkg.targetSelected(target);
                this.pkg.setState(0);
            }
        }
        if (!rectangle.equals(this.oldRect)) {
            graphEditor.revalidate();
            graphEditor.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent, int n, int n2, GraphEditor graphEditor) {
        Graphics2D graphics2D = (Graphics2D)graphEditor.getGraphics();
        if (this.oldRect == null) {
            return;
        }
        int n3 = this.resizing ? this.oldRect.width : this.oldRect.x;
        int n4 = this.resizing ? this.oldRect.height : this.oldRect.y;
        int n5 = this.resizing ? this.width : this.x;
        int n6 = this.resizing ? this.height : this.y;
        int n7 = (n3 + n - this.drag_start_x) / 10;
        int n8 = n7 * 10;
        int n9 = (n4 + n2 - this.drag_start_y) / 10;
        int n10 = n9 * 10;
        if (n8 != n5 || n10 != n6) {
            if (!this.isResizable() && this.resizing) {
                return;
            }
            if (!this.isMoveable() && !this.resizing) {
                return;
            }
            graphics2D.setColor(this.getBorderColour());
            graphics2D.setXORMode(graphbg);
            graphics2D.translate(this.x, this.y);
            this.drawBorders(graphics2D);
            graphics2D.translate(-this.x, -this.y);
            if (this.resizing) {
                this.width = Math.max(n8, 60);
                this.height = Math.max(n10, 40);
            } else {
                this.x = n8 >= 0 ? n8 : 0;
                this.y = n10 >= 0 ? n10 : 0;
            }
            graphics2D.translate(this.x, this.y);
            this.drawBorders(graphics2D);
            graphics2D.translate(-this.x, -this.y);
        }
    }

    public String toString() {
        return this.getDisplayName();
    }

    public Target(Package package_, String string) {
        super(0, 0, Target.calculateWidth(string), 50);
        if (package_ == null) {
            throw new NullPointerException();
        }
        this.pkg = package_;
        this.identifierName = string;
        this.displayName = string;
    }
}

