/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.Main;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

final class VersionCheckDialog
extends JDialog
implements ActionListener {
    private static final String close = Config.getString("close");
    private static final String check = Config.getString("pkgmgr.versionDlg.check");
    private static final String dialogTitle = Config.getString("pkgmgr.versionDlg.title");
    private static final String helpLine1 = Config.getString("pkgmgr.versionDlg.helpLine1");
    private static final String helpLine2 = Config.getString("pkgmgr.versionDlg.helpLine2");
    private static final String versionURL = Config.getPropString("bluej.url.versionCheck");
    private JTextArea textArea;
    private JButton closeButton;
    private String newVersion = null;
    private Thread versionThread = null;
    private boolean isClosed = false;

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (check.equals(string)) {
            this.doVersionCheck();
            this.getRootPane().setDefaultButton(this.closeButton);
        } else if (close.equals(string)) {
            this.doClose();
        }
    }

    private void doClose() {
        this.isClosed = true;
        ((Component)this).setVisible(false);
    }

    private void doVersionCheck() {
        VersionCheckDialog versionCheckDialog = this;
        if (versionCheckDialog == null) {
            throw null;
        }
        this.versionThread = versionCheckDialog.new VersionChecker();
        this.versionThread.start();
    }

    private void makeDialog() {
        this.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(Config.dialogBorder);
        JLabel jLabel = new JLabel(helpLine1);
        jPanel.add(jLabel);
        JLabel jLabel2 = new JLabel(helpLine2);
        jPanel.add(jLabel2);
        Font font = jLabel.getFont().deriveFont(10);
        jLabel.setFont(font);
        jLabel2.setFont(font);
        jPanel.add(Box.createVerticalStrut(5));
        this.textArea = new JTextArea(8, 16);
        this.textArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jPanel.add(jScrollPane);
        jPanel.add(Box.createVerticalStrut(17));
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.setAlignmentX(0.0f);
        JButton jButton = new JButton(check);
        jButton.addActionListener(this);
        this.closeButton = new JButton(close);
        this.closeButton.addActionListener(this);
        jPanel2.add(jButton);
        jPanel2.add(this.closeButton);
        this.getRootPane().setDefaultButton(jButton);
        jButton.requestFocus();
        this.closeButton.setPreferredSize(new Dimension(jButton.getPreferredSize().width, this.closeButton.getPreferredSize().height));
        jPanel.add(jPanel2);
        this.getContentPane().add(jPanel);
        this.pack();
        DialogManager.centreDialog(this);
    }

    public VersionCheckDialog(PkgMgrFrame pkgMgrFrame) {
        super(pkgMgrFrame, dialogTitle, true);
        this.makeDialog();
        ((Component)this).setVisible(true);
    }

    private class VersionChecker
    extends Thread {
        public void run() {
            VersionCheckDialog.this.textArea.setText("Making connection to version server...");
            try {
                InputStream inputStream = new URL(versionURL).openStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                if (this.isOutOfDate(bufferedReader)) {
                    if (!VersionCheckDialog.this.isClosed) {
                        this.displayNewVersionInfo(bufferedReader);
                    }
                } else if (!VersionCheckDialog.this.isClosed) {
                    VersionCheckDialog.this.textArea.setText(Config.getString("pkgmgr.versionDlg.upToDate"));
                }
            }
            catch (IOException iOException) {
                if (!VersionCheckDialog.this.isClosed) {
                    VersionCheckDialog.this.textArea.setText("Error: could not access remote version information");
                }
                Debug.reportError("IO error when trying to access URL\n" + iOException);
            }
        }

        private boolean isOutOfDate(BufferedReader bufferedReader) {
            try {
                VersionCheckDialog.this.newVersion = bufferedReader.readLine();
                if (VersionCheckDialog.this.newVersion != null) {
                    VersionCheckDialog.this.newVersion = VersionCheckDialog.this.newVersion.trim();
                }
            }
            catch (IOException iOException) {
                VersionCheckDialog.this.textArea.setText("Error: could not read remote version information");
                Debug.reportError("IO error when reading remote version info\n" + iOException);
            }
            return !Main.BLUEJ_VERSION.equals(VersionCheckDialog.this.newVersion);
        }

        private void displayNewVersionInfo(BufferedReader bufferedReader) {
            if (VersionCheckDialog.this.newVersion == null) {
                VersionCheckDialog.this.textArea.setText("Error: could not read remote version info");
            } else {
                VersionCheckDialog.this.textArea.setText(Config.getString("pkgmgr.versionDlg.currentVersion"));
                VersionCheckDialog.this.textArea.append(Main.BLUEJ_VERSION);
                VersionCheckDialog.this.textArea.append("\n");
                VersionCheckDialog.this.textArea.append(Config.getString("pkgmgr.versionDlg.newVersion"));
                VersionCheckDialog.this.textArea.append(VersionCheckDialog.this.newVersion);
                VersionCheckDialog.this.textArea.append("\n");
                try {
                    String string = bufferedReader.readLine();
                    while (string != null) {
                        VersionCheckDialog.this.textArea.append(string);
                        VersionCheckDialog.this.textArea.append("\n");
                        string = bufferedReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    Debug.reportError("IO error when reading from version file");
                }
                VersionCheckDialog.this.textArea.setCaretPosition(0);
            }
        }
    }
}

