/*
 * Decompiled with CFR 0.152.
 */
package bluej.prefmgr;

import bluej.Config;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefMgrDialog;
import bluej.prefmgr.PrefPanelListener;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class MiscPrefPanel
extends JPanel
implements PrefPanelListener {
    static final String prefpaneltitle = Config.getString("prefmgr.misc.prefpaneltitle");
    static final String jdkURLPropertyName = "bluej.url.javaStdLib";
    private JTextField editorFontField;
    private JCheckBox hilightingBox;
    private JTextField jdkURLField;
    private JCheckBox linkToLibBox;
    ButtonGroup notationStyleGroup;
    private JRadioButton umlRadioButton;
    private JRadioButton blueRadioButton;

    public static void register() {
        MiscPrefPanel miscPrefPanel = new MiscPrefPanel();
        PrefMgrDialog.add(miscPrefPanel, prefpaneltitle, miscPrefPanel);
    }

    public void beginEditing() {
        this.editorFontField.setText(String.valueOf(PrefMgr.getEditorFontSize()));
        this.hilightingBox.setSelected(PrefMgr.useSyntaxHilighting());
        this.linkToLibBox.setSelected(PrefMgr.linkDocToLibrary());
        this.jdkURLField.setText(Config.getPropString(jdkURLPropertyName));
        if (!PrefMgr.isUML()) {
            this.blueRadioButton.setSelected(true);
        } else {
            this.umlRadioButton.setSelected(true);
        }
    }

    public void revertEditing() {
    }

    public void commitEditing() {
        int n = 0;
        try {
            n = Integer.parseInt(this.editorFontField.getText());
            PrefMgr.setEditorFontSize(n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        PrefMgr.setSyntaxHilighting(this.hilightingBox.isSelected());
        PrefMgr.setDocumentationLinking(this.linkToLibBox.isSelected());
        Package.editorManager.refreshAll();
        String string = this.jdkURLField.getText();
        if (Config.getDefaultPropString(jdkURLPropertyName, "") == string) {
            Config.removeProperty(jdkURLPropertyName);
        } else {
            Config.putPropString(jdkURLPropertyName, string);
        }
        String string2 = this.notationStyleGroup.getSelection().getActionCommand();
        PrefMgr.setNotationStyle(string2);
        PkgMgrFrame.refreshAllFrames();
    }

    private MiscPrefPanel() {
        JLabel jLabel = new JLabel(Config.getString("prefmgr.misc.editorfontsize"));
        jLabel.setAlignmentX(0.0f);
        MiscPrefPanel miscPrefPanel = this;
        if (miscPrefPanel == null) {
            throw null;
        }
        this.editorFontField = miscPrefPanel.new SingleLineTextField(8);
        this.editorFontField.setAlignmentX(0.0f);
        this.hilightingBox = new JCheckBox(Config.getString("prefmgr.misc.usesyntaxhilighting"));
        JLabel jLabel2 = new JLabel(Config.getString("prefmgr.misc.jdkurlpath"));
        jLabel2.setAlignmentX(0.0f);
        MiscPrefPanel miscPrefPanel2 = this;
        if (miscPrefPanel2 == null) {
            throw null;
        }
        this.jdkURLField = miscPrefPanel2.new SingleLineTextField(8);
        this.jdkURLField.setAlignmentX(0.0f);
        this.linkToLibBox = new JCheckBox(Config.getString("prefmgr.misc.linkToLib"));
        JLabel jLabel3 = new JLabel(Config.getString("prefmgr.misc.linkToLibNoteLine1"));
        Font font = jLabel3.getFont().deriveFont(10);
        jLabel3.setFont(font);
        JLabel jLabel4 = new JLabel(Config.getString("prefmgr.misc.linkToLibNoteLine2"));
        jLabel4.setFont(font);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(Config.generalBorder);
        this.add(jLabel);
        this.add(this.editorFontField);
        this.add(Box.createVerticalStrut(5));
        this.add(this.hilightingBox);
        this.add(Box.createVerticalStrut(5));
        this.add(Box.createVerticalStrut(5));
        this.add(jLabel2);
        this.add(this.jdkURLField);
        this.add(this.linkToLibBox);
        this.add(jLabel3);
        this.add(jLabel4);
        this.add(Box.createVerticalStrut(5));
        this.add(Box.createVerticalStrut(5));
        this.add(Box.createVerticalStrut(5));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        String string = Config.getString("prefmgr.notation.title");
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(string), Config.generalBorder));
        jPanel.setAlignmentX(0.0f);
        this.notationStyleGroup = new ButtonGroup();
        this.umlRadioButton = new JRadioButton(Config.getString("prefmgr.notation.uml"));
        this.blueRadioButton = new JRadioButton(Config.getString("prefmgr.notation.blue"));
        this.umlRadioButton.setActionCommand("uml");
        this.blueRadioButton.setActionCommand("blue");
        this.notationStyleGroup.add(this.umlRadioButton);
        this.notationStyleGroup.add(this.blueRadioButton);
        jPanel.add(this.umlRadioButton);
        jPanel.add(this.blueRadioButton);
        this.add(jPanel);
        this.add(Box.createGlue());
    }

    class SingleLineTextField
    extends JTextField {
        public Dimension getMaximumSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = Integer.MAX_VALUE;
            return dimension;
        }

        public SingleLineTextField(int n) {
            super(n);
        }
    }
}

