/*
 * Decompiled with CFR 0.152.
 */
package bluej.prefmgr;

import bluej.Config;
import java.awt.Font;

public class PrefMgr {
    private static final String hilightingPropertyName = "bluej.syntaxHilighting";
    private static final String linkingPropertyName = "doctool.linkToStandardLib";
    private static final String editorFontPropertyName = "bluej.editor.font";
    private static final String editorFontSizePropertyName = "bluej.editor.fontsize";
    private static final String notationStyle = "bluej.notation.style";
    private static int fontSize;
    private static int editFontsize;
    private static int printFontsize;
    private static int printTitleFontsize;
    private static int printInfoFontsize;
    private static int targetFontSize;
    private static Font normalFont;
    private static Font targetFont;
    private static int menuFontSize;
    private static Font menuFont;
    private static Font popupMenuFont;
    private static Font italicMenuFont;
    private static int editorFontSize;
    private static Font editorStandardFont;
    private static Font editorStandoutFont;
    private static boolean isSyntaxHilighting;
    private static boolean isLinkDocumentation;
    private static boolean isUML;
    private static boolean hasTheme;
    private static PrefMgr prefmgr;

    public static void initialise() {
    }

    public static Font getStandardFont() {
        return normalFont;
    }

    public static Font getStandoutFont() {
        return normalFont;
    }

    public static Font getStandardMenuFont() {
        return menuFont;
    }

    public static Font getStandoutMenuFont() {
        return italicMenuFont;
    }

    public static Font getPopupMenuFont() {
        return popupMenuFont;
    }

    public static Font getTargetFont() {
        return targetFont;
    }

    public static Font getStandardEditorFont() {
        return editorStandardFont;
    }

    public static boolean useSyntaxHilighting() {
        return isSyntaxHilighting;
    }

    public static boolean linkDocToLibrary() {
        return isLinkDocumentation;
    }

    protected static void setEditorFontSize(int n) {
        if (n > 0 && n != editorFontSize) {
            editorFontSize = n;
            if (Config.getDefaultPropInteger(editorFontSizePropertyName, -1) == n) {
                Config.removeProperty(editorFontSizePropertyName);
            } else {
                Config.putPropInteger(editorFontSizePropertyName, n);
            }
            String string = Config.getPropString(editorFontPropertyName, "Monospaced");
            editorStandardFont = PrefMgr.deriveFont(string, n);
            editorStandoutFont = new Font(string, 1, n);
        }
    }

    private static Font deriveFont(String string, int n) {
        int n2;
        if (string.endsWith("-bold")) {
            n2 = 1;
            string = string.substring(0, string.length() - 5);
        } else {
            n2 = 0;
        }
        return new Font(string, n2, n);
    }

    protected static int getEditorFontSize() {
        return editorFontSize;
    }

    protected static void setSyntaxHilighting(boolean bl) {
        String string = Config.getDefaultPropString(hilightingPropertyName, "true");
        if (Boolean.valueOf(string) == bl) {
            Config.removeProperty(hilightingPropertyName);
        } else {
            Config.putPropString(hilightingPropertyName, new Boolean(bl).toString());
        }
        isSyntaxHilighting = bl;
    }

    protected static void setDocumentationLinking(boolean bl) {
        String string = Config.getDefaultPropString(linkingPropertyName, "true");
        if (Boolean.valueOf(string) == bl) {
            Config.removeProperty(linkingPropertyName);
        } else {
            Config.putPropString(linkingPropertyName, new Boolean(bl).toString());
        }
        isLinkDocumentation = bl;
    }

    public static boolean isUML() {
        return isUML;
    }

    public static boolean hasTheme() {
        return hasTheme;
    }

    protected static void setNotationStyle(String string) {
        isUML = !"blue".equals(string);
        Config.putPropString(notationStyle, string);
    }

    private PrefMgr() {
        PrefMgr.setEditorFontSize(Config.getPropInteger(editorFontSizePropertyName, 12));
        String string = Config.getPropString("bluej.menu.font", "SansSerif");
        menuFontSize = Config.getPropInteger("bluej.menu.fontsize", 12);
        menuFont = PrefMgr.deriveFont(string, menuFontSize);
        if (string.endsWith("-bold")) {
            string = string.substring(0, string.length() - 5);
        }
        italicMenuFont = new Font(string, 2, menuFontSize);
        popupMenuFont = new Font(string, 0, menuFontSize);
        String string2 = Config.getPropString("bluej.font", "SansSerif");
        fontSize = Config.getPropInteger("bluej.fontsize", 12);
        normalFont = PrefMgr.deriveFont(string2, fontSize);
        String string3 = Config.getPropString("bluej.target.font", "SansSerif-bold");
        targetFontSize = Config.getPropInteger("bluej.target.fontsize", 12);
        targetFont = PrefMgr.deriveFont(string3, targetFontSize);
        isSyntaxHilighting = Boolean.valueOf(Config.getPropString(hilightingPropertyName, "true"));
        isLinkDocumentation = Boolean.valueOf(Config.getPropString(linkingPropertyName, "true"));
        isUML = Config.getDefaultPropString(notationStyle, "uml").equals("uml");
        hasTheme = Boolean.valueOf(Config.getPropString("bluej.useTheme", "false"));
    }

    static {
        prefmgr = new PrefMgr();
    }
}

