/*
 * Decompiled with CFR 0.152.
 */
package bluej.runtime;

import bluej.runtime.ExitException;
import bluej.runtime.RemoteClassMgr;
import bluej.runtime.RemoteObjectInputStream;
import bluej.runtime.RemoteSecurityManager;
import bluej.runtime.TerminateException;
import bluej.utility.Debug;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ExecServer {
    public static final int CREATE_LOADER = 0;
    public static final int REMOVE_LOADER = 1;
    public static final int LOAD_CLASS = 2;
    public static final int ADD_OBJECT = 3;
    public static final int REMOVE_OBJECT = 4;
    public static final int SET_LIBRARIES = 5;
    public static final int SET_DIRECTORY = 6;
    public static final int SERIALIZE_OBJECT = 7;
    public static final int DESERIALIZE_OBJECT = 8;
    public static final int SUPRESS_OUTPUT = 9;
    public static final int RESTORE_OUTPUT = 10;
    public static final int DISPOSE_WINDOWS = 11;
    static ExecServer server = null;
    static TerminateException terminateExc = new TerminateException("term");
    static ExitException exitExc = new ExitException("0");
    private static Map scopes = new HashMap();
    private static List openWindows = Collections.synchronizedList(new LinkedList());
    private static PrintStream systemErr = System.err;
    private static ByteArrayOutputStream throwawayErr = null;
    private RemoteClassMgr classmgr;
    private Map loaders = new HashMap();

    public static void main(String[] stringArray) throws Throwable {
        server = new ExecServer();
        server.suspendExecution();
    }

    public static void exitMarker() {
    }

    public void suspendExecution() {
        Debug.message("[VM] woke up from suspend");
    }

    public Object performTask(int n, String string, String string2, String string3, String string4) throws Throwable {
        try {
            switch (n) {
                case 0: {
                    return this.createClassLoader(string, string2);
                }
                case 1: {
                    this.removeClassLoader(string);
                    return null;
                }
                case 2: {
                    this.loadClass(string, string2);
                    return null;
                }
                case 3: {
                    ExecServer.addObject(string, string2, string3, string4);
                    return null;
                }
                case 4: {
                    ExecServer.removeObject(string, string2);
                    return null;
                }
                case 5: {
                    this.setLibraries(string);
                    return null;
                }
                case 6: {
                    this.setDirectory(string);
                    return null;
                }
                case 7: {
                    ExecServer.serializeObject(string, string2, string3);
                    return null;
                }
                case 8: {
                    return this.deserializeObject(string, string2, string3, string4);
                }
                case 9: {
                    ExecServer.supressErrorOutput();
                    return null;
                }
                case 10: {
                    ExecServer.restoreErrorOutput();
                    return null;
                }
                case 11: {
                    ExecServer.disposeWindows();
                    return null;
                }
            }
        }
        catch (Exception exception) {
            Debug.reportError("Exception while performing task: " + exception);
            exception.printStackTrace();
        }
        return null;
    }

    private ClassLoader createClassLoader(String string, String string2) {
        ClassLoader classLoader = this.classmgr.getLoader(string2);
        this.loaders.put(string, classLoader);
        return classLoader;
    }

    private void removeClassLoader(String string) {
        this.loaders.remove(string);
    }

    private Class loadClass(String string, String string2) throws Exception {
        Class<?> clazz = null;
        if (string == null) {
            clazz = this.classmgr.getLoader().loadClass(string2);
        } else {
            ClassLoader classLoader = (ClassLoader)this.loaders.get(string);
            if (classLoader != null) {
                clazz = classLoader.loadClass(string2);
            }
        }
        if (clazz == null) {
            Debug.reportError("Could not load class for execution");
        } else {
            this.prepareClass(clazz);
        }
        return clazz;
    }

    private void prepareClass(Class clazz) {
        try {
            Method method = clazz.getMethod("prepare", null);
            method.invoke(null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void putObject(String string, String string2, Object object) {
        Map map = ExecServer.getScope(string);
        map.put(string2, object);
    }

    static void serializeObject(String string, String string2, String string3) {
        Map map = ExecServer.getScope(string);
        Object v = map.get(string2);
        if (v == null) {
            System.out.println("wrap object was null for scope " + string);
            System.out.println(scopes.toString());
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(v);
            objectOutputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private Object deserializeObject(String string, String string2, String string3, String string4) {
        Map map = ExecServer.getScope(string2);
        Object object = null;
        try {
            ClassLoader classLoader = (ClassLoader)this.loaders.get(string);
            FileInputStream fileInputStream = new FileInputStream(string4);
            RemoteObjectInputStream remoteObjectInputStream = new RemoteObjectInputStream(fileInputStream, classLoader);
            object = remoteObjectInputStream.readObject();
            map.put(string3, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println(object.toString());
        return object;
    }

    static void addObject(String string, String string2, String string3, String string4) {
        Map map = ExecServer.getScope(string);
        Object v = map.get(string2);
        try {
            Object object;
            if (v.getClass().isArray()) {
                int n = Integer.valueOf(string3.substring(5));
                object = Array.get(v, n);
            } else {
                Field field = v.getClass().getField(string3);
                object = field.get(v);
            }
            map.put(string4, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Debug.reportError("object field not found: " + string3 + " in " + string2);
            Debug.reportError("exception: " + exception);
        }
    }

    static void removeObject(String string, String string2) {
        Map map = ExecServer.getScope(string);
        map.remove(string2);
    }

    static Map getScope(String string) {
        HashMap hashMap = (HashMap)scopes.get(string);
        if (hashMap == null) {
            hashMap = new HashMap();
            scopes.put(string, hashMap);
        }
        return hashMap;
    }

    private static void addWindow(Object object) {
        openWindows.add(object);
    }

    private static void removeWindow(Object object) {
        openWindows.remove(object);
    }

    static void supressErrorOutput() {
        throwawayErr = new ByteArrayOutputStream();
        System.setErr(new PrintStream(throwawayErr));
    }

    static void restoreErrorOutput() {
        System.setErr(systemErr);
    }

    static void disposeWindows() {
        List list = openWindows;
        synchronized (list) {
            Iterator iterator = openWindows.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Window)) continue;
                Window window = (Window)e;
                window.dispose();
            }
            openWindows.clear();
        }
    }

    private void setLibraries(String string) {
        this.classmgr.setLibraries(string);
    }

    private void setDirectory(String string) {
        System.setProperty("user.dir", string);
    }

    static /* synthetic */ void access$0(Object object) {
        ExecServer.addWindow(object);
    }

    static /* synthetic */ void access$1(Object object) {
        ExecServer.removeWindow(object);
    }

    private ExecServer() {
        this.classmgr = new RemoteClassMgr();
        try {
            this.createClassLoader("#dummy", ".");
            this.loadClass("#dummy", "Dummy");
            this.removeClassLoader("#dummy");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        ExecServer execServer = this;
        if (execServer == null) {
            throw null;
        }
        AWTEventListener aWTEventListener = new AWTEventListener(execServer){
            private final /* synthetic */ ExecServer this$0;

            public void eventDispatched(AWTEvent aWTEvent) {
                if (aWTEvent.getID() == 200) {
                    ExecServer.access$0(aWTEvent.getSource());
                } else if (aWTEvent.getID() == 202) {
                    ExecServer.access$1(aWTEvent.getSource());
                }
            }
            {
                this.this$0 = execServer;
                this.constructor$0(execServer);
            }

            private final void constructor$0(ExecServer execServer) {
            }
        };
        toolkit.addAWTEventListener(aWTEventListener, 64L);
        System.setSecurityManager(new RemoteSecurityManager());
    }
}

