/*
 * Decompiled with CFR 0.152.
 */
package bluej.terminal;

import java.awt.Toolkit;

public final class InputBuffer {
    private char[] buffer;
    private int bufferNextFull = 0;
    private int bufferNextFree = 0;
    private int bufferSize;

    public boolean putChar(char c) {
        if (this.isFull()) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        this.buffer[this.bufferNextFree] = c;
        this.bufferNextFree = this.advance(this.bufferNextFree);
        return true;
    }

    public boolean backSpace() {
        if (!this.isEmpty()) {
            this.bufferNextFree = this.backwards(this.bufferNextFree);
            return true;
        }
        Toolkit.getDefaultToolkit().beep();
        return false;
    }

    public char getChar() {
        while (this.isEmpty()) {
            try {
                InputBuffer inputBuffer = this;
                synchronized (inputBuffer) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        char c = this.buffer[this.bufferNextFull];
        this.bufferNextFull = this.advance(this.bufferNextFull);
        return c;
    }

    public int numberOfCharacters() {
        if (this.bufferNextFree >= this.bufferNextFull) {
            return this.bufferNextFree - this.bufferNextFull;
        }
        return this.bufferNextFree + this.bufferSize - this.bufferNextFull;
    }

    public synchronized void notifyReaders() {
        this.notify();
    }

    public boolean isFull() {
        return this.advance(this.bufferNextFree) == this.bufferNextFull;
    }

    public boolean isEmpty() {
        return this.bufferNextFull == this.bufferNextFree;
    }

    private int advance(int n) {
        return ++n % this.bufferSize;
    }

    private int backwards(int n) {
        return --n < 0 ? this.bufferSize - 1 : n;
    }

    InputBuffer(int n) {
        this.buffer = new char[n];
        this.bufferSize = n;
    }
}

