/*
 * Decompiled with CFR 0.152.
 */
package bluej.terminal;

import bluej.BlueJEvent;
import bluej.BlueJEventListener;
import bluej.Config;
import bluej.terminal.InputBuffer;
import bluej.terminal.TermTextArea;
import bluej.terminal.Terminal;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;

public final class Terminal
extends JFrame
implements KeyListener,
BlueJEventListener {
    private static final String WINDOWTITLE = Config.getString("terminal.title");
    private static final int FONTSIZE = 12;
    private static final Color activeBgColour = Color.white;
    private static final Color inactiveBgColour = new Color(224, 224, 224);
    private static final Color fgColour = Color.black;
    private static final Image iconImage = Config.getImageAsIcon("image.icon.terminal").getImage();
    private static final char CHAR_CLEAR = '\u000b';
    private static final char CHAR_COPY = '\u0003';
    private static final char CHAR_SAVE = '\u0013';
    private static final char CHAR_CLOSE = '\u0017';
    static Terminal frame = null;
    static boolean enabled = true;
    private TermTextArea text;
    private boolean isActive = false;
    private boolean recordMethodCalls = false;
    private InputBuffer buffer;
    private JCheckBoxMenuItem recordCalls;
    private JCheckBoxMenuItem unlimitedBuffering;
    Reader in;
    Writer out;

    public static synchronized Terminal getTerminal() {
        if (frame == null) {
            frame = new Terminal();
        }
        return frame;
    }

    public void showTerminal(boolean bl) {
        ((Component)this).setVisible(bl);
        if (bl) {
            this.setState(0);
            this.text.requestFocus();
        }
    }

    public boolean isShown() {
        return this.isShowing();
    }

    public void activate(boolean bl) {
        if (bl != this.isActive) {
            this.text.setEditable(bl);
            this.isActive = bl;
        }
    }

    public void clear() {
        this.text.setText("");
    }

    public void save() {
        String string = FileUtility.getFileName(this, Config.getString("terminal.save.title"), Config.getString("terminal.save.buttonText"), false);
        if (string != null) {
            try {
                FileWriter fileWriter = new FileWriter(string);
                this.text.write(fileWriter);
                fileWriter.close();
            }
            catch (IOException iOException) {
                DialogManager.showError(this, "error-save-file");
            }
        }
    }

    private void writeToTerminal(String string) {
        this.text.append(string);
        this.text.setCaretPosition(this.text.getDocument().getLength());
    }

    private void writeToTerminal(char c) {
        this.text.append(new Character(c).toString());
        this.text.setCaretPosition(this.text.getDocument().getLength());
    }

    private void setScreenSize(int n, int n2) {
        this.text.setColumns(n);
        this.text.setRows(n2);
        this.pack();
    }

    private void prepare() {
        if (!this.isShown()) {
            this.showTerminal(true);
        }
    }

    public Reader getReader() {
        return this.in;
    }

    public Writer getWriter() {
        return this.out;
    }

    public void keyPressed(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    public void keyReleased(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        boolean bl = false;
        if (Character.isISOControl(c)) {
            switch (c) {
                case '\u000b': {
                    this.clear();
                    bl = true;
                    break;
                }
                case '\u0003': {
                    this.getCopyAction().actionPerformed(new ActionEvent(keyEvent.getSource(), 0, ""));
                    bl = true;
                    break;
                }
                case '\u0013': {
                    this.save();
                    bl = true;
                    break;
                }
                case '\u0017': {
                    this.showTerminal(false);
                    bl = true;
                    break;
                }
            }
        }
        if (this.isActive && !bl) {
            switch (c) {
                case '\b': {
                    if (!this.buffer.backSpace()) break;
                    try {
                        int n = this.text.getDocument().getLength();
                        this.text.replaceRange("", n - 1, n);
                    }
                    catch (Exception exception) {
                        Debug.reportError("bad location " + exception);
                    }
                    break;
                }
                case '\n': 
                case '\r': {
                    if (!this.buffer.putChar('\n')) break;
                    this.writeToTerminal(c);
                    this.buffer.notifyReaders();
                    break;
                }
                default: {
                    if (!this.buffer.putChar(c)) break;
                    this.writeToTerminal(c);
                    break;
                }
            }
        }
        keyEvent.consume();
    }

    public void blueJEvent(int n, Object object) {
        if (n == 2 && this.recordMethodCalls) {
            try {
                if (this.text.getCaretPosition() != this.text.getLineStartOffset(this.text.getLineCount())) {
                    this.writeToTerminal("\n");
                }
            }
            catch (BadLocationException badLocationException) {
                this.writeToTerminal("\n");
            }
            this.writeToTerminal("[ ");
            this.writeToTerminal((String)object);
            this.writeToTerminal(" ]\n");
        }
    }

    private void makeWindow(int n, int n2) {
        ((Frame)this).setIconImage(iconImage);
        this.text = new TermTextArea(n2, n);
        JScrollPane jScrollPane = new JScrollPane(this.text);
        this.text.setFont(new Font("Monospaced", 0, 12));
        this.text.setEditable(false);
        this.text.setLineWrap(false);
        this.text.setForeground(fgColour);
        this.text.setMargin(new Insets(6, 6, 6, 6));
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.text.addKeyListener(this);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(Config.getString("terminal.options"));
        Terminal terminal = this;
        if (terminal == null) {
            throw null;
        }
        JMenuItem jMenuItem = jMenu.add(terminal.new ClearAction());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(75, 2));
        jMenuItem = jMenu.add(this.getCopyAction());
        jMenuItem.setText(Config.getString("terminal.copy"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        Terminal terminal2 = this;
        if (terminal2 == null) {
            throw null;
        }
        jMenuItem = jMenu.add(terminal2.new SaveAction());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenu.add(new JSeparator());
        this.recordCalls = new JCheckBoxMenuItem(Config.getString("terminal.recordCalls"));
        Terminal terminal3 = this;
        if (terminal3 == null) {
            throw null;
        }
        this.recordCalls.addActionListener(terminal3.new RecordCallAction());
        jMenu.add(this.recordCalls);
        this.unlimitedBuffering = new JCheckBoxMenuItem(Config.getString("terminal.buffering"));
        Terminal terminal4 = this;
        if (terminal4 == null) {
            throw null;
        }
        this.unlimitedBuffering.addActionListener(terminal4.new BufferAction());
        jMenu.add(this.unlimitedBuffering);
        jMenu.add(new JSeparator());
        Terminal terminal5 = this;
        if (terminal5 == null) {
            throw null;
        }
        jMenuItem = jMenu.add(terminal5.new CloseAction());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        Terminal terminal6 = this;
        if (terminal6 == null) {
            throw null;
        }
        this.addWindowListener(new WindowAdapter(terminal6){
            private final /* synthetic */ Terminal this$0;

            public void windowClosing(WindowEvent windowEvent) {
                Window window = (Window)windowEvent.getSource();
                ((Component)window).setVisible(false);
            }
            {
                this.this$0 = terminal;
                this.constructor$0(terminal);
            }

            private final void constructor$0(Terminal terminal) {
            }
        });
        Terminal terminal7 = this;
        if (terminal7 == null) {
            throw null;
        }
        this.addComponentListener(new ComponentAdapter(terminal7){
            private final /* synthetic */ Terminal this$0;

            public void componentMoved(ComponentEvent componentEvent) {
                Config.putLocation("bluej.terminal", this.this$0.getLocation());
            }
            {
                this.this$0 = terminal;
                this.constructor$0(terminal);
            }

            private final void constructor$0(Terminal terminal) {
            }
        });
        ((Component)this).setLocation(Config.getLocation("bluej.terminal"));
        this.pack();
    }

    private Action getCopyAction() {
        Action[] actionArray = this.text.getActions();
        int n = 0;
        while (n < actionArray.length) {
            if (actionArray[n].getValue("Name").equals("copy-to-clipboard")) {
                return actionArray[n];
            }
            ++n;
        }
        return null;
    }

    static /* synthetic */ InputBuffer access$0(Terminal terminal) {
        return terminal.buffer;
    }

    static /* synthetic */ void access$1(Terminal terminal) {
        terminal.prepare();
    }

    static /* synthetic */ void access$2(Terminal terminal, String string) {
        terminal.writeToTerminal(string);
    }

    static /* synthetic */ void access$3(Terminal terminal, char c) {
        terminal.writeToTerminal(c);
    }

    static /* synthetic */ boolean access$4(Terminal terminal) {
        return terminal.recordMethodCalls;
    }

    private Terminal() {
        this(WINDOWTITLE, 80, 25);
    }

    private Terminal(String string, int n, int n2) {
        super(string);
        Terminal terminal = this;
        if (terminal == null) {
            throw null;
        }
        this.in = new 1(terminal);
        Terminal terminal2 = this;
        if (terminal2 == null) {
            throw null;
        }
        this.out = new 2(terminal2);
        this.buffer = new InputBuffer(256);
        this.makeWindow(n, n2);
        BlueJEvent.addListener(this);
    }

    private class ClearAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Terminal.this.clear();
        }

        public ClearAction() {
            super(Config.getString("terminal.clear"));
        }
    }

    private class SaveAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Terminal.this.save();
        }

        public SaveAction() {
            super(Config.getString("terminal.save"));
        }
    }

    private class CloseAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Terminal.this.showTerminal(false);
        }

        public CloseAction() {
            super(Config.getString("terminal.close"));
        }
    }

    private class RecordCallAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Terminal.this.recordMethodCalls = Terminal.this.recordCalls.isSelected();
        }

        public RecordCallAction() {
            super(Config.getString("terminal.recordCalls"));
        }
    }

    private class BufferAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Terminal.this.text.setUnlimitedBuffering(Terminal.this.unlimitedBuffering.isSelected());
        }

        public BufferAction() {
            super(Config.getString("terminal.buffering"));
        }
    }
}

