/*
 * Decompiled with CFR 0.152.
 */
package bluej.terminal;

import bluej.utility.Debug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JComponent;

class TerminalCanvas
extends JComponent
implements ComponentListener,
KeyListener {
    private static final Font screenFont = new Font("Monospaced", 0, 12);
    private static final Color activeBgColour = Color.white;
    private static final Color inactiveBgColour = new Color(224, 224, 224);
    private static final Color fgColour = Color.black;
    private static final int TAB_SIZE = 8;
    private static final int MARGIN = 3;
    private char[][] screen = null;
    private Dimension textsize = new Dimension();
    private Point pos = new Point();
    private boolean cursorOn = true;
    private int fontwidth;
    private int fontascent;
    private int fontheight;
    private Color backgroundColour;
    private int unbuffered = 0;
    Vector inputLines = new Vector();
    Buffer currentBuffer;

    public void setScreenSize(int n, int n2) {
        if (this.textsize.width == n && this.textsize.height == n2 || n <= 0 || n2 <= 0) {
            return;
        }
        char[][] cArray = new char[n2][n];
        if (this.screen != null) {
            int n3 = Math.min(this.textsize.width, n);
            int n4 = Math.min(this.textsize.height, n2);
            int n5 = 0;
            while (n5 < n4) {
                System.arraycopy(this.screen[n5], 0, cArray[n5], 0, n3);
                ++n5;
            }
        }
        this.screen = cArray;
        this.textsize.width = n;
        this.textsize.height = n2;
        this.pos.x = Math.min(this.pos.x, n - 1);
        this.pos.y = Math.min(this.pos.y, n2 - 1);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension(this.textsize.width * this.fontwidth + 6, this.textsize.height * this.fontheight + 6);
        return dimension;
    }

    public void componentResized(ComponentEvent componentEvent) {
        Dimension dimension = this.getSize();
        int n = dimension.width / this.fontwidth;
        int n2 = dimension.height / this.fontheight;
        this.setScreenSize(n, n2);
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == '\r') {
            c = '\n';
        }
        this.updateBuffer(c);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        int n = (rectangle.y - 3) / this.fontheight;
        int n2 = (rectangle.x - 3) / this.fontwidth;
        graphics.setFont(screenFont);
        graphics.setColor(this.backgroundColour);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(fgColour);
        int n3 = (rectangle.width + this.fontwidth - 2) / this.fontwidth;
        int n4 = (rectangle.height + this.fontheight - 1) / this.fontheight;
        n3 = Math.min(n3, this.textsize.width - n2);
        n4 = Math.min(n4, this.textsize.height - n);
        int n5 = n;
        while (n5 < n + n4) {
            graphics.setColor(fgColour);
            char[] cArray = new char[n3];
            int n6 = 0;
            while (n6 < n3) {
                int n7 = this.screen[n5][n2 + n6];
                cArray[n6] = n7 == 0 ? 32 : n7;
                ++n6;
            }
            graphics.drawChars(cArray, 0, n3, n2 * this.fontwidth + 3, n5 * this.fontheight + this.fontascent + 3);
            ++n5;
        }
        if (this.cursorOn) {
            this.showCursor(graphics);
        }
    }

    public void activate(boolean bl) {
        this.backgroundColour = bl ? activeBgColour : inactiveBgColour;
        this.repaint();
    }

    public void showCursor(Graphics graphics) {
        graphics.setColor(Color.red);
        graphics.drawLine(this.pos.x * this.fontwidth + 3, this.pos.y * this.fontheight + 3, this.pos.x * this.fontwidth + 3, (this.pos.y + 1) * this.fontheight + 3 - 1);
    }

    void redrawChar(int n, int n2) {
        this.repaint(n2 * this.fontwidth + 3, n * this.fontheight + 3, this.fontwidth + 1, this.fontheight);
    }

    public void cursorTo(int n, int n2) {
        n = Math.min(n, this.textsize.width - 1);
        n2 = Math.min(n2, this.textsize.height - 1);
        this.redrawChar(this.pos.y, this.pos.x);
        this.pos.x = n;
        this.pos.y = n2;
        this.redrawChar(this.pos.y, this.pos.x);
    }

    public void setCursor(boolean bl) {
        this.cursorOn = bl;
        this.redrawChar(this.pos.y, this.pos.x);
    }

    public void clear() {
        int n = 0;
        while (n < this.textsize.height) {
            this.clearRow(n);
            ++n;
        }
        this.pos.y = 0;
        this.pos.x = 0;
        this.repaint();
    }

    public void clearRow(int n) {
        int n2 = 0;
        while (n2 < this.textsize.width) {
            this.screen[n][n2] = '\u0000';
            ++n2;
        }
    }

    public void putchar(char c) {
        switch (c) {
            case '\t': {
                int n = 8 - this.pos.x % 8;
                while (n > 0) {
                    this.putchar(' ');
                    --n;
                }
                break;
            }
            case '\r': {
                this.carriage_return();
                break;
            }
            case '\n': {
                this.line_feed();
                break;
            }
            case '\b': {
                this.backspace();
                break;
            }
            default: {
                this.screen[this.pos.y][this.pos.x] = c;
                this.redrawChar(this.pos.y, this.pos.x);
                if (++this.pos.x != this.textsize.width) break;
                this.line_feed();
                break;
            }
        }
    }

    void carriage_return() {
        if (this.pos.x > 0) {
            this.redrawChar(this.pos.y, this.pos.x);
            this.pos.x = 0;
            this.redrawChar(this.pos.y, this.pos.x);
        }
    }

    void line_feed() {
        this.redrawChar(this.pos.y, this.pos.x);
        this.pos.x = 0;
        if (this.pos.y == this.textsize.height - 1) {
            this.scroll();
        } else {
            ++this.pos.y;
        }
        this.redrawChar(this.pos.y, this.pos.x);
    }

    void scroll() {
        char[] cArray = this.screen[0];
        System.arraycopy(this.screen, 1, this.screen, 0, this.textsize.height - 1);
        this.screen[this.textsize.height - 1] = cArray;
        this.clearRow(this.textsize.height - 1);
        this.repaint();
    }

    void backspace() {
        if (this.pos.x == 0 && this.pos.y == 0) {
            return;
        }
        this.redrawChar(this.pos.y, this.pos.x);
        if (this.pos.x > 0) {
            this.screen[this.pos.y][--this.pos.x] = '\u0000';
        } else {
            --this.pos.y;
            this.pos.x = this.textsize.width - 1;
            while (this.pos.x > 0 && this.screen[this.pos.y][this.pos.x - 1] == '\u0000') {
                --this.pos.x;
            }
        }
        this.redrawChar(this.pos.y, this.pos.x);
    }

    int getChar() {
        while (this.bufferEmpty()) {
            try {
                TerminalCanvas terminalCanvas = this;
                synchronized (terminalCanvas) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.nextChar();
    }

    synchronized int nextChar() {
        Buffer buffer = (Buffer)this.inputLines.elementAt(0);
        int n = buffer.getChar();
        if (buffer.isEmpty()) {
            this.inputLines.removeElementAt(0);
        }
        return n;
    }

    char getCharUnbuffered() {
        while (this.bufferEmpty() && this.currentBuffer.isEmpty()) {
            try {
                TerminalCanvas terminalCanvas = this;
                synchronized (terminalCanvas) {
                    ++this.unbuffered;
                    this.wait();
                    --this.unbuffered;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.bufferEmpty()) {
            return (char)this.nextChar();
        }
        return (char)this.currentBuffer.getChar();
    }

    boolean askCharUnbuffered() {
        return !this.bufferEmpty() || !this.currentBuffer.isEmpty();
    }

    synchronized void updateBuffer(char c) {
        switch (c) {
            case '\n': 
            case '\r': {
                this.currentBuffer.addChar('\n');
                this.inputLines.addElement(this.currentBuffer);
                TerminalCanvas terminalCanvas = this;
                if (terminalCanvas == null) {
                    throw null;
                }
                this.currentBuffer = terminalCanvas.new Buffer();
                this.putchar(c);
                TerminalCanvas terminalCanvas2 = this;
                synchronized (terminalCanvas2) {
                    this.notify();
                }
                return;
            }
            case '\b': {
                if (this.unbuffered != 0) break;
                if (this.currentBuffer.isEmpty()) {
                    return;
                }
                this.currentBuffer.removeChar();
            }
        }
        this.currentBuffer.addChar(c);
        this.putchar(c);
    }

    boolean bufferEmpty() {
        return this.inputLines.isEmpty();
    }

    int available() {
        if (this.bufferEmpty()) {
            return 0;
        }
        return ((Buffer)this.inputLines.elementAt(0)).available();
    }

    public TerminalCanvas(int n, int n2) {
        TerminalCanvas terminalCanvas = this;
        if (terminalCanvas == null) {
            throw null;
        }
        this.currentBuffer = terminalCanvas.new Buffer();
        this.backgroundColour = inactiveBgColour;
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(screenFont);
        this.fontwidth = fontMetrics.charWidth('a');
        this.fontascent = fontMetrics.getAscent();
        this.fontheight = fontMetrics.getHeight();
        Debug.assert(this.fontwidth != 0 && this.fontascent != 0 && this.fontheight != 0);
        this.addComponentListener(this);
        this.addKeyListener(this);
        this.setScreenSize(n, n2);
    }

    class Buffer {
        char[] data = new char[16];
        int size = 0;
        int read = 0;

        void addChar(char c) {
            if (this.size == this.data.length) {
                char[] cArray = new char[this.data.length * 2];
                System.arraycopy(this.data, 0, cArray, 0, this.data.length);
                this.data = cArray;
            }
            this.data[this.size++] = c;
        }

        void removeChar() {
            if (this.size > 0) {
                --this.size;
            }
        }

        int getChar() {
            return this.read < this.size ? this.data[this.read++] : -1;
        }

        int available() {
            return this.size - this.read;
        }

        boolean isEmpty() {
            return this.read >= this.size;
        }

        Buffer() {
        }
    }
}

