/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.Config;
import bluej.utility.BlueJFileChooser;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.PackageChooser;
import bluej.utility.PackageChooserStrict;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileUtility {
    private static final String sourceSuffix = ".java";
    private static final String contextSuffix = ".ctxt";
    private static final String packageFilePrefix = "bluej.pk";
    private static JFileChooser pkgChooser = null;
    private static JFileChooser pkgChooserNonBlueJ = null;
    private static JFileChooser fileChooser = null;
    public static final int NO_ERROR = 0;
    public static final int DEST_EXISTS = 1;
    public static final int SRC_NOT_DIRECTORY = 2;
    public static final int COPY_ERROR = 3;

    public static File getPackageName(Component component) {
        JFileChooser jFileChooser = FileUtility.getPackageChooser();
        if (jFileChooser.showOpenDialog(component) != 0) {
            return null;
        }
        return jFileChooser.getSelectedFile();
    }

    public static File getNonBlueJDirectoryName(Component component) {
        JFileChooser jFileChooser = FileUtility.getNonBlueJPackageChooser();
        if (jFileChooser.showOpenDialog(component) != 0) {
            return null;
        }
        return jFileChooser.getSelectedFile();
    }

    public static String getFileName(Component component, String string, String string2, boolean bl, FileFilter fileFilter) {
        JFileChooser jFileChooser = FileUtility.getFileChooser();
        jFileChooser.setDialogTitle(string);
        if (bl) {
            jFileChooser.setFileSelectionMode(1);
        } else {
            jFileChooser.setFileSelectionMode(2);
        }
        if (fileFilter == null) {
            fileFilter = jFileChooser.getAcceptAllFileFilter();
        }
        jFileChooser.setFileFilter(fileFilter);
        int n = jFileChooser.showDialog(component, string2);
        if (n == 0) {
            return jFileChooser.getSelectedFile().getPath();
        }
        if (n == 1) {
            return null;
        }
        DialogManager.showError(component, "error-no-name");
        return null;
    }

    public static String getFileName(Component component, String string, String string2, boolean bl) {
        return FileUtility.getFileName(component, string, string2, bl, null);
    }

    public static FileFilter getJavaSourceFilter() {
        return new JavaSourceFilter();
    }

    private static JFileChooser getPackageChooser() {
        String string = new File("x").getAbsolutePath();
        if (pkgChooser == null) {
            pkgChooser = new PackageChooserStrict(new File(Config.getPropString("bluej.defaultProjectPath", string)));
        }
        pkgChooser.setDialogTitle(Config.getString("pkgmgr.openPkg.title"));
        pkgChooser.setApproveButtonText(Config.getString("pkgmgr.openPkg.buttonLabel"));
        return pkgChooser;
    }

    private static JFileChooser getNonBlueJPackageChooser() {
        String string = new File("x").getAbsolutePath();
        if (pkgChooserNonBlueJ == null) {
            pkgChooserNonBlueJ = new PackageChooser(new File(Config.getPropString("bluej.defaultProjectPath", string)));
        }
        pkgChooserNonBlueJ.setDialogTitle(Config.getString("pkgmgr.openNonBlueJPkg.title"));
        pkgChooserNonBlueJ.setApproveButtonText(Config.getString("pkgmgr.openNonBlueJPkg.buttonLabel"));
        return pkgChooserNonBlueJ;
    }

    public static JFileChooser getFileChooser() {
        String string = new File("x").getAbsolutePath();
        if (fileChooser == null) {
            fileChooser = new BlueJFileChooser(Config.getPropString("bluej.defaultProjectPath", string));
        }
        return fileChooser;
    }

    public static boolean copyFile(String string, String string2) {
        File file = new File(string);
        File file2 = new File(string2);
        return FileUtility.copyFile(file, file2);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFile(File var0, File var1_1) {
        if (var0.equals(var1_1)) {
            return true;
        }
        var2_2 = null;
        var3_3 = null;
        try {
            try {
                var2_2 = new BufferedInputStream(new FileInputStream(var0));
                var3_3 = new BufferedOutputStream(new FileOutputStream(var1_1));
                FileUtility.copyStream(var2_2, var3_3);
                var6_4 = true;
                var5_6 = null;
            }
            catch (IOException var7_10) {
                var6_5 = false;
                var5_7 = null;
                try {
                    if (var2_2 != null) {
                        var2_2.close();
                    }
                    if (var3_3 == null) return var6_5;
                    var3_3.close();
                    return var6_5;
                }
                catch (IOException var7_11) {
                    // empty catch block
                }
                return var6_5;
            }
        }
        catch (Throwable var4_13) {
            var5_8 = null;
            try {}
            catch (IOException var7_12) {
                throw var4_13;
            }
            if (var2_2 != null) {
                var2_2.close();
            }
            if (var3_3 == null) throw var4_13;
            var3_3.close();
            throw var4_13;
        }
        ** try [egrp 2[TRYBLOCK] [2 : 81->100)] { 
lbl40:
        // 1 sources

        if (var2_2 != null) {
            var2_2.close();
        }
        if (var3_3 == null) return var6_4;
        var3_3.close();
        return var6_4;
lbl45:
        // 1 sources

        catch (IOException var7_9) {
            // empty catch block
        }
        return var6_4;
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        while ((n = inputStream.read()) != -1) {
            outputStream.write(n);
        }
    }

    public static int copyDirectory(String string, String string2, boolean bl, boolean bl2) {
        File file = new File(string);
        File file2 = new File(string2);
        if (!file.isDirectory()) {
            return 2;
        }
        if (file2.exists()) {
            return 1;
        }
        if (!file2.mkdir()) {
            return 3;
        }
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            File file3;
            String string3 = string + File.separator + stringArray[n];
            File file4 = new File(string3);
            if (file4.isDirectory() ? FileUtility.copyDirectory(string3, string2 + File.separator + stringArray[n], bl, bl2) != 0 : !FileUtility.skipFile(stringArray[n], bl, bl2) && !FileUtility.copyFile(file4, file3 = new File(string2, stringArray[n]))) {
                return 3;
            }
            ++n;
        }
        return 0;
    }

    public static boolean skipFile(String string, boolean bl, boolean bl2) {
        if (bl && (string.startsWith(packageFilePrefix) || string.endsWith(contextSuffix))) {
            return true;
        }
        return bl2 && string.endsWith(sourceSuffix);
    }

    public static Object[] recursiveCopyFile(File file, File file2) {
        if (file == null || file2 == null) {
            throw new IllegalArgumentException();
        }
        File file3 = file2.getParentFile();
        while (file3 != null) {
            if (file3.equals(file)) {
                return new Object[]{file};
            }
            file3 = file3.getParentFile();
        }
        return FileUtility.actualRecursiveCopyFile(file, file2);
    }

    private static Object[] actualRecursiveCopyFile(File file, File file2) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file.getAbsolutePath().equals(file2.getAbsolutePath())) {
            return null;
        }
        if (!file.isDirectory() || !file2.isDirectory()) {
            throw new IllegalArgumentException();
        }
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file3;
            if (fileArray[n].isDirectory()) {
                file3 = new File(file2, fileArray[n].getName());
                file3.mkdir();
                if (file3.isDirectory()) {
                    FileUtility.actualRecursiveCopyFile(fileArray[n], file3);
                } else {
                    arrayList.add(fileArray[n]);
                }
            } else if (fileArray[n].isFile() && ((file3 = new File(file2, fileArray[n].getName())).exists() || !FileUtility.copyFile(fileArray[n], file3))) {
                arrayList.add(fileArray[n]);
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            return arrayList.toArray();
        }
        return null;
    }

    public static File findFile(File file, String string) {
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isFile() && fileArray[n].getName().endsWith(string)) {
                return fileArray[n];
            }
            ++n;
        }
        n = 0;
        while (n < fileArray.length) {
            File file2;
            if (fileArray[n].isDirectory() && (file2 = FileUtility.findFile(fileArray[n], string)) != null) {
                return file2;
            }
            ++n;
        }
        return null;
    }

    public static boolean containsFile(File file, String string) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isFile() && fileArray[n].getName().endsWith(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static void deleteDir(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null || Array.getLength(fileArray) == 0) {
            try {
                file.delete();
            }
            catch (SecurityException securityException) {
                Debug.message("Trouble deleting: " + file + securityException);
            }
        } else {
            int n = 0;
            while (n < Array.getLength(fileArray)) {
                FileUtility.deleteDir(fileArray[n]);
                ++n;
            }
            try {
                file.delete();
            }
            catch (SecurityException securityException) {
                Debug.message("Trouble deleting: " + file + securityException);
            }
        }
    }

    static /* synthetic */ String access$0() {
        return sourceSuffix;
    }

    private static class JavaSourceFilter
    extends FileFilter {
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(FileUtility.sourceSuffix);
        }

        public String getDescription() {
            return "Java Source";
        }

        JavaSourceFilter() {
        }
    }
}

