/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import java.util.StringTokenizer;

public class JavaNames {
    public static boolean isIdentifier(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            if (!Character.isJavaIdentifierPart(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isQualifiedIdentifier(String string) {
        if (string.length() == 0) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            if (JavaNames.isIdentifier(stringTokenizer.nextToken())) continue;
            return false;
        }
        return true;
    }

    public static String stripPrefix(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(".")) >= 0) {
            return string.substring(++n);
        }
        return string;
    }

    public static String stripSuffix(String string, String string2) {
        int n = string.lastIndexOf(string2);
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String getBase(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            return string.substring(++n);
        }
        return string;
    }

    public static String getPrefix(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        int n = string.lastIndexOf(".");
        if (n > 0) {
            return string.substring(0, n);
        }
        return "";
    }

    public static String typeName(String string) {
        if (string.charAt(0) != '[') {
            return string;
        }
        String string2 = "";
        while (string.startsWith("[")) {
            string = string.substring(1);
            string2 = string2 + "[]";
        }
        switch (string.charAt(0)) {
            case 'L': {
                string2 = string.substring(1, string.length() - 1) + string2;
                break;
            }
            case 'B': {
                string2 = "byte" + string2;
                break;
            }
            case 'C': {
                string2 = "char" + string2;
                break;
            }
            case 'D': {
                string2 = "double" + string2;
                break;
            }
            case 'F': {
                string2 = "float" + string2;
                break;
            }
            case 'I': {
                string2 = "int" + string2;
                break;
            }
            case 'J': {
                string2 = "long" + string2;
                break;
            }
            case 'S': {
                string2 = "short" + string2;
                break;
            }
            case 'Z': {
                string2 = "boolean" + string2;
                break;
            }
        }
        return string2;
    }
}

