/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.utility.Utility;
import java.awt.Color;
import java.awt.Font;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MultiLineLabel
extends JPanel {
    protected int fontAttributes = 0;
    protected float alignment;
    protected Color col = null;

    public void setText(String string) {
        this.removeAll();
        this.addText(string);
    }

    public void addText(String string) {
        String[] stringArray = Utility.splitLines(string);
        Font font = new Font("SansSerif", this.fontAttributes, 12);
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            JLabel jLabel = new JLabel(stringArray[n]);
            jLabel.setFont(font);
            jLabel.setAlignmentX(this.alignment);
            if (this.col != null) {
                jLabel.setForeground(this.col);
            }
            this.add(jLabel);
            ++n;
        }
    }

    public void addText(String string, boolean bl, boolean bl2) {
        int n = this.fontAttributes;
        this.setBold(bl);
        this.setItalic(bl2);
        this.addText(string);
        this.fontAttributes = n;
    }

    public void setForeground(Color color) {
        this.col = color;
    }

    public void setItalic(boolean bl) {
        this.fontAttributes = bl ? (this.fontAttributes |= 2) : (this.fontAttributes &= 0xFFFFFFFD);
    }

    public void setBold(boolean bl) {
        this.fontAttributes = bl ? (this.fontAttributes |= 1) : (this.fontAttributes &= 0xFFFFFFFE);
    }

    public MultiLineLabel(String string, float f) {
        this.alignment = f;
        this.setLayout(new BoxLayout(this, 1));
        if (string != null) {
            this.setText(string);
        }
    }

    public MultiLineLabel(String string) {
        this(string, 0.0f);
    }

    public MultiLineLabel(float f) {
        this(null, f);
    }

    public MultiLineLabel() {
        this(null, 0.0f);
    }
}

