/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.Config;
import bluej.utility.JavaNames;
import bluej.utility.PackageFileView;
import bluej.utility.filefilter.DirectoryFilter;
import bluej.utility.filefilter.JavaSourceFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;

class PackageChooser
extends JFileChooser {
    static final Icon classIcon = Config.getImageAsIcon("image.classIcon");
    static final Icon packageIcon = Config.getImageAsIcon("image.packageIcon");
    static final String previewLine1 = Config.getString("utility.packageChooser.previewPane1");
    static final String previewLine2 = Config.getString("utility.packageChooser.previewPane2");
    PackageDisplay displayPanel;

    public PackageChooser(File file) {
        this(file, true);
    }

    public PackageChooser(File file, boolean bl) {
        super(file);
        this.setFileSelectionMode(1);
        this.setFileView(new PackageFileView());
        if (bl) {
            PackageChooser packageChooser = this;
            if (packageChooser == null) {
                throw null;
            }
            this.displayPanel = packageChooser.new PackageDisplay(file);
            this.setAccessory(this.displayPanel);
            PackageChooser packageChooser2 = this;
            if (packageChooser2 == null) {
                throw null;
            }
            this.addPropertyChangeListener(new PropertyChangeListener(packageChooser2){
                private final /* synthetic */ PackageChooser this$0;

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (!(propertyChangeEvent.getNewValue() instanceof File)) {
                        return;
                    }
                    File file = (File)propertyChangeEvent.getNewValue();
                    if (file == null) {
                        return;
                    }
                    if (file.getName().equals("")) {
                        return;
                    }
                    this.this$0.displayPanel.setDisplayDirectory(file.getAbsoluteFile());
                    if (propertyChangeEvent.getPropertyName().equals("directoryChanged")) {
                        // empty if block
                    }
                    if (propertyChangeEvent.getPropertyName().equals("SelectedFileChangedProperty")) {
                        // empty if block
                    }
                }
                {
                    this.this$0 = packageChooser;
                    this.constructor$0(packageChooser);
                }

                private final void constructor$0(PackageChooser packageChooser) {
                }
            });
        }
    }

    class PackageDisplay
    extends JList {
        final int headerLines;
        int lastClass = 0;

        protected void processMouseEvent(MouseEvent mouseEvent) {
        }

        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        }

        void setDisplayDirectory(File file) {
            if (file == null) {
                return;
            }
            int n = 3;
            File[] fileArray = file.listFiles(new DirectoryFilter());
            File[] fileArray2 = file.listFiles(new JavaSourceFilter());
            Vector<String> vector = new Vector<String>();
            vector.add(previewLine1);
            vector.add(previewLine2);
            vector.add(" ");
            if (fileArray != null) {
                this.lastClass = 0;
                while (this.lastClass < fileArray2.length && this.lastClass < n) {
                    String string = JavaNames.stripSuffix(fileArray2[this.lastClass].getName(), ".java");
                    if (JavaNames.isIdentifier(string) && string.indexOf(36) == -1) {
                        vector.add(string);
                    }
                    ++this.lastClass;
                }
            }
            if (fileArray2 != null) {
                int n2 = 0;
                while (n2 < fileArray.length && n2 < n) {
                    if (JavaNames.isIdentifier(fileArray[n2].getName())) {
                        vector.add(fileArray[n2].getName());
                        File[] fileArray3 = fileArray[n2].listFiles(new DirectoryFilter());
                        if (fileArray3 != null) {
                            int n3 = 0;
                            while (n3 < fileArray3.length) {
                                if (JavaNames.isIdentifier(fileArray3[n3].getName())) {
                                    vector.add(fileArray[n2].getName() + "." + fileArray3[n3].getName());
                                }
                                ++n3;
                            }
                        }
                    }
                    ++n2;
                }
            }
            this.setListData(vector);
        }

        PackageDisplay(File file) {
            this.headerLines = 3;
            this.setPreferredSize(new Dimension(150, 200));
            PackageDisplay packageDisplay = this;
            if (packageDisplay == null) {
                throw null;
            }
            this.setCellRenderer(packageDisplay.new MyListRenderer());
            this.setDisplayDirectory(file);
        }

        class MyListRenderer
        extends DefaultListCellRenderer {
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (n >= 3) {
                    if (n - 3 < PackageDisplay.this.lastClass) {
                        ((JLabel)component).setIcon(classIcon);
                    } else {
                        ((JLabel)component).setIcon(packageIcon);
                    }
                }
                return component;
            }

            MyListRenderer() {
            }
        }
    }
}

