/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class SortedProperties
extends Properties {
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final String whiteSpaceChars = " \t\r\n\f";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private String saveConvert(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2++);
            switch (c) {
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    break;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    break;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    break;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    break;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    break;
                }
                default: {
                    if (c < '\u0014' || c > '\u007f') {
                        stringBuffer.append('\\');
                        stringBuffer.append('u');
                        stringBuffer.append(SortedProperties.toHex(c >> 12 & 0xF));
                        stringBuffer.append(SortedProperties.toHex(c >> 8 & 0xF));
                        stringBuffer.append(SortedProperties.toHex(c >> 4 & 0xF));
                        stringBuffer.append(SortedProperties.toHex(c & 0xF));
                        break;
                    }
                    if (specialSaveChars.indexOf(c) != -1) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static char toHex(int n) {
        return hexDigit[n & 0xF];
    }

    public void store(OutputStream outputStream, String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "8859_1"));
        if (string != null) {
            bufferedWriter.write("#" + string);
            bufferedWriter.newLine();
        }
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(this);
        Iterator<Map.Entry<Object, Object>> iterator = treeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string2 = this.saveConvert((String)entry.getKey());
            String string3 = this.saveConvert((String)entry.getValue());
            bufferedWriter.write(string2 + "=" + string3);
            bufferedWriter.newLine();
        }
        bufferedWriter.flush();
    }
}

