/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.Config;
import bluej.utility.Comparer;
import bluej.utility.Debug;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;

public class Utility {
    private static Random random = new Random();

    public static int getRandom(int n, int n2) {
        int n3 = random.nextInt();
        n3 = n3 > 0 ? n3 : -n3;
        return n + n3 % (n2 - n);
    }

    public static void drawThickLine(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        double d = Math.atan2(-(n2 - n4), n - n3) + 1.5707963267948966;
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        int n6 = (int)((double)n5 * Math.cos(d)) / 2;
        int n7 = (int)((double)n5 * Math.sin(d)) / 2;
        int n8 = (int)((double)n5 * Math.cos(d));
        int n9 = (int)((double)n5 * Math.sin(d));
        nArray[0] = n - n6;
        nArray2[0] = n2 + n7;
        nArray[1] = n3 - n6;
        nArray2[1] = n4 + n7;
        nArray[2] = nArray[1] + n8;
        nArray2[2] = nArray2[1] - n9;
        nArray[3] = nArray[0] + n8;
        nArray2[3] = nArray2[0] - n9;
        graphics.fillPolygon(nArray, nArray2, 4);
    }

    public static void drawThickRect(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        while (n6 < n5) {
            graphics.drawRect(n + n6, n2 + n6, n3 - 2 * n6, n4 - 2 * n6);
            ++n6;
        }
    }

    public static void stripeRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        while (n7 < n3 + n4) {
            int n8 = 0;
            while (n8 < n6) {
                int n9;
                int n10;
                int n11;
                int n12;
                if (n7 < n4) {
                    n12 = n;
                    n11 = n2 + n7;
                } else {
                    n12 = n + n7 - n4;
                    n11 = n2 + n4;
                }
                if (n7 < n3) {
                    n10 = n + n7;
                    n9 = n2;
                } else {
                    n10 = n + n3;
                    n9 = n2 + n7 - n3;
                }
                graphics.drawLine(n12, n11, n10, n9);
                ++n8;
                ++n7;
            }
            n7 += n5;
        }
    }

    public static void drawCentredText(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Shape shape = graphics.getClip();
        graphics.clipRect(n, n2, n3, n4);
        graphics.drawString(string, n + (n3 - fontMetrics.stringWidth(string)) / 2, n2 + (n4 + fontMetrics.getAscent()) / 2);
        graphics.setClip(shape);
    }

    public static void drawRightText(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Shape shape = graphics.getClip();
        graphics.clipRect(n, n2, n3, n4);
        graphics.drawString(string, n + n3 - fontMetrics.stringWidth(string), n2 + (n4 + fontMetrics.getAscent()) / 2);
        graphics.setClip(shape);
    }

    protected static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    public static void quicksort(Comparer comparer, Object[] objectArray, int n, int n2) {
        if (n >= n2) {
            return;
        }
        Utility.swap(objectArray, n, (n + n2) / 2);
        int n3 = n;
        int n4 = n + 1;
        while (n4 <= n2) {
            if (comparer.cmp(objectArray[n4], objectArray[n]) < 0) {
                Utility.swap(objectArray, ++n3, n4);
            }
            ++n4;
        }
        Utility.swap(objectArray, n, n3);
        Utility.quicksort(comparer, objectArray, n, n3 - 1);
        Utility.quicksort(comparer, objectArray, n3 + 1, n2);
    }

    public static String[] split(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = string.length();
        int n3 = string2.length();
        int n4 = string.lastIndexOf(string2);
        if (n3 < 1) {
            return null;
        }
        if (n4 < 0) {
            String[] stringArray = new String[]{string};
            return stringArray;
        }
        if (n2 > n4 + n3) {
            string = string + string2;
            n2 += n3;
        }
        do {
            n4 = string.indexOf(string2, n);
            vector.addElement(string.substring(n, n4));
        } while ((n = n4 + n3) < n2 && n4 != -1);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String[] splitLines(String string) {
        return string == null ? null : Utility.split(string, "\n");
    }

    public static String quoteSloshes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(string.charAt(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String quoteSpaces(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == ' ') {
                stringBuffer.append(string2);
            }
            stringBuffer.append(string.charAt(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void showClassDocumentation(String string, String string2) {
        int n;
        string = string.replace('.', '/');
        String string3 = Config.getPropString("bluej.url.javaStdLib");
        if (string3.endsWith(".html") && (n = string3.lastIndexOf(47)) != -1) {
            string3 = string3.substring(0, n + 1);
        }
        Utility.openWebBrowser(string3 + string + ".html" + string2);
    }

    public static boolean openWebBrowser(String string) {
        String string2 = System.getProperty("os.name");
        try {
            String string3 = string2 != null && string2.startsWith("Windows 9") ? Utility.mergeStrings(Config.getPropString("win9xBrowserCmd1"), string) : (string2 != null && string2.startsWith("Windows") ? Utility.mergeStrings(Config.getPropString("winBrowserCmd1"), string) : (string2 != null && string2.startsWith("Mac") ? Utility.mergeStrings(Config.getPropString("macBrowserCmd1"), string) : Utility.mergeStrings(Config.getPropString("browserCmd1"), string)));
            Process process = Runtime.getRuntime().exec(string3);
            try {
                int n = process.waitFor();
                string3 = string2 != null && string2.startsWith("Windows 9") ? Config.getPropString("win9xBrowserCmd2") : (string2 != null && string2.startsWith("Windows") ? Config.getPropString("winBrowserCmd2") : (string2 != null && string2.startsWith("Mac") ? Config.getPropString("macBrowserCmd2") : Config.getPropString("browserCmd2")));
                if (n != 0 && string3 != null && string3.length() > 0) {
                    string3 = Utility.mergeStrings(string3, string);
                    process = Runtime.getRuntime().exec(string3);
                }
            }
            catch (InterruptedException interruptedException) {
                Debug.reportError("cannot start web browser: " + string3);
                Debug.reportError("caught exc " + interruptedException);
                return false;
            }
        }
        catch (IOException iOException) {
            Debug.reportError("could not start web browser");
            Debug.reportError("caught exc " + iOException);
            return false;
        }
        return true;
    }

    public static String mergeStrings(String string, String string2) {
        int n = string.indexOf(36);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n) + string2 + string.substring(n + 1);
    }

    public static String mergeStrings(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            string = Utility.mergeStrings(string, stringArray[n]);
            ++n;
        }
        return string;
    }

    public static String convertTabsToSpaces(String string, int n) {
        if (string.indexOf(9) != -1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n2 = 0;
            while (n2 < stringBuffer.length()) {
                if (stringBuffer.charAt(n2) == '\t') {
                    stringBuffer.deleteCharAt(n2);
                    int n3 = n - n2 % n;
                    int n4 = 0;
                    while (n4 < n3) {
                        stringBuffer.insert(n2, ' ');
                        ++n4;
                    }
                }
                ++n2;
            }
            return stringBuffer.toString();
        }
        return string;
    }
}

