/*
 * Decompiled with CFR 0.152.
 */
package bluej.views;

import bluej.utility.Utility;
import bluej.views.FormattedPrintWriter;
import java.util.Properties;
import java.util.StringTokenizer;

public final class Comment {
    private String target;
    private String text;
    private String[] paramnames;

    public void load(Properties properties, String string) {
        this.target = properties.getProperty(string + ".target", "<no target>");
        this.text = properties.getProperty(string + ".text");
        String string2 = properties.getProperty(string + ".params");
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            this.paramnames = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.paramnames[n] = stringTokenizer.nextToken();
                ++n;
            }
        }
    }

    public String getTarget() {
        return this.target;
    }

    public String getText() {
        return this.text;
    }

    public String getParamName(int n) {
        if (this.paramnames != null && n >= 0 && n < this.paramnames.length) {
            return this.paramnames[n];
        }
        return null;
    }

    public int getParamCount() {
        if (this.paramnames != null) {
            return this.paramnames.length;
        }
        return 0;
    }

    public void print(FormattedPrintWriter formattedPrintWriter) {
        this.print(formattedPrintWriter, 0);
    }

    public void print(FormattedPrintWriter formattedPrintWriter, int n) {
        formattedPrintWriter.setBold(false);
        formattedPrintWriter.setItalic(true);
        if (this.text != null) {
            String[] stringArray = Utility.splitLines(this.text);
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = stringArray[n2].trim();
                ++n2;
            }
            n2 = 0;
            while (n2 < stringArray.length && stringArray[n2].length() == 0) {
                ++n2;
            }
            int n3 = stringArray.length - 1;
            while (n3 >= 0 && stringArray[n3].length() == 0) {
                --n3;
            }
            int n4 = n2;
            while (n4 <= n3) {
                int n5 = 0;
                while (n5 < n) {
                    formattedPrintWriter.indentLine();
                    ++n5;
                }
                formattedPrintWriter.println("// " + stringArray[n4]);
                ++n4;
            }
        }
    }
}

