/*
 * Decompiled with CFR 0.152.
 */
package bluej.views;

import bluej.views.Comment;
import bluej.views.FormattedPrintWriter;
import bluej.views.View;
import java.lang.reflect.Modifier;

public abstract class MemberView {
    private View view;
    private Comment comment;

    public View getDeclaringView() {
        return this.view;
    }

    public String getClassName() {
        return this.view.getQualifiedName();
    }

    public abstract int getModifiers();

    public abstract String getSignature();

    void setComment(Comment comment) {
        this.comment = comment;
    }

    public Comment getComment() {
        if (this.view != null) {
            this.view.loadComments();
        }
        return this.comment;
    }

    public abstract String getShortDesc();

    public abstract String getLongDesc();

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public void print(FormattedPrintWriter formattedPrintWriter) {
        this.print(formattedPrintWriter, 0);
    }

    public void print(FormattedPrintWriter formattedPrintWriter, int n) {
        Comment comment = this.getComment();
        if (comment != null) {
            comment.print(formattedPrintWriter, n);
        }
        formattedPrintWriter.setItalic(false);
        formattedPrintWriter.setBold(true);
        int n2 = 0;
        while (n2 < n) {
            formattedPrintWriter.indentLine();
            ++n2;
        }
        formattedPrintWriter.println(this.getLongDesc());
    }

    protected MemberView(View view) {
        if (view == null) {
            throw new NullPointerException();
        }
        this.view = view;
    }
}

