/*
 * Decompiled with CFR 0.152.
 */
package bluej.views;

import bluej.utility.Comparer;
import bluej.utility.JavaNames;
import bluej.utility.SortableVector;
import bluej.views.Comment;
import bluej.views.CommentList;
import bluej.views.ConstructorView;
import bluej.views.FieldView;
import bluej.views.FormattedPrintWriter;
import bluej.views.MemberView;
import bluej.views.MethodView;
import bluej.views.ViewFilter;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class View {
    private static Map views = new HashMap();
    protected Class cl;
    protected FieldView[] fields;
    protected FieldView[] allFields;
    protected ConstructorView[] constructors;
    protected MethodView[] methods;
    protected MethodView[] allMethods;
    protected Comment comment;
    private int instanceNum = 0;
    boolean comments_loaded = false;

    public static View getView(Class clazz) {
        if (clazz == null) {
            return null;
        }
        View view = (View)views.get(clazz);
        if (view == null) {
            view = new View(clazz);
            views.put(clazz, view);
        }
        return view;
    }

    public static void removeAll(ClassLoader classLoader) {
        Iterator iterator = views.values().iterator();
        while (iterator.hasNext()) {
            View view = (View)iterator.next();
            if (view.getClassLoader() != classLoader) continue;
            iterator.remove();
        }
    }

    private ClassLoader getClassLoader() {
        return this.cl.getClassLoader();
    }

    public String getQualifiedName() {
        return this.cl.getName();
    }

    public String getBaseName() {
        return JavaNames.getBase(this.cl.getName());
    }

    public View getSuper() {
        return View.getView(this.cl.getSuperclass());
    }

    public View[] getInterfaces() {
        Class<?>[] classArray = this.cl.getInterfaces();
        View[] viewArray = new View[classArray.length];
        int n = 0;
        while (n < classArray.length) {
            viewArray[n] = View.getView(classArray[n]);
            ++n;
        }
        return viewArray;
    }

    public final boolean isInterface() {
        return this.cl.isInterface();
    }

    public MethodView[] getAllMethods() {
        if (this.allMethods == null) {
            Hashtable hashtable = new Hashtable();
            this.getAllMethods(hashtable, 0);
            SortableVector sortableVector = new SortableVector();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                sortableVector.addElement(enumeration.nextElement());
            }
            View view = this;
            if (view == null) {
                throw null;
            }
            sortableVector.sort(view.new ElementComparer());
            int n = sortableVector.size();
            this.allMethods = new MethodView[n];
            int n2 = 0;
            while (n2 < n) {
                MemberElement memberElement = (MemberElement)sortableVector.elementAt(n2);
                this.allMethods[n2] = (MethodView)memberElement.member;
                ++n2;
            }
        }
        return this.allMethods;
    }

    public FieldView[] getAllFields() {
        if (this.allFields == null) {
            Hashtable hashtable = new Hashtable();
            this.getAllFields(hashtable, 0);
            SortableVector sortableVector = new SortableVector();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                sortableVector.addElement(enumeration.nextElement());
            }
            View view = this;
            if (view == null) {
                throw null;
            }
            sortableVector.sort(view.new ElementComparer());
            int n = sortableVector.size();
            this.allFields = new FieldView[n];
            int n2 = 0;
            while (n2 < n) {
                MemberElement memberElement = (MemberElement)sortableVector.elementAt(n2);
                this.allFields[n2] = (FieldView)memberElement.member;
                ++n2;
            }
        }
        return this.allFields;
    }

    protected int getAllMethods(Hashtable hashtable, int n) {
        if (this.allMethods != null) {
            n = this.addMembers(hashtable, this.allMethods, n);
            return n;
        }
        View view = this.getSuper();
        if (view != null) {
            n = view.getAllMethods(hashtable, n);
        }
        if (this.isInterface()) {
            View[] viewArray = this.getInterfaces();
            int n2 = 0;
            while (n2 < viewArray.length) {
                n = viewArray[n2].getAllMethods(hashtable, n);
                ++n2;
            }
        }
        n = this.addMembers(hashtable, this.getDeclaredMethods(), n);
        return n;
    }

    protected int getAllFields(Hashtable hashtable, int n) {
        if (this.allFields != null) {
            n = this.addMembers(hashtable, this.allFields, n);
            return n;
        }
        View view = this.getSuper();
        if (view != null) {
            n = view.getAllFields(hashtable, n);
        }
        View[] viewArray = this.getInterfaces();
        int n2 = 0;
        while (n2 < viewArray.length) {
            n = viewArray[n2].getAllFields(hashtable, n);
            ++n2;
        }
        n = this.addMembers(hashtable, this.getDeclaredFields(), n);
        return n;
    }

    private int addMembers(Hashtable hashtable, MemberView[] memberViewArray, int n) {
        int n2 = memberViewArray.length - 1;
        while (n2 >= 0) {
            View view = this;
            if (view == null) {
                throw null;
            }
            hashtable.put(memberViewArray[n2].toString(), view.new MemberElement(n++, memberViewArray[n2]));
            --n2;
        }
        return n;
    }

    public MethodView[] getDeclaredMethods() {
        if (this.methods == null) {
            Method[] methodArray = this.cl.getDeclaredMethods();
            this.methods = new MethodView[methodArray.length];
            int n = 0;
            while (n < this.methods.length) {
                this.methods[n] = new MethodView(this, methodArray[n]);
                ++n;
            }
        }
        return this.methods;
    }

    public FieldView[] getDeclaredFields() {
        if (this.fields == null) {
            Field[] fieldArray = this.cl.getDeclaredFields();
            this.fields = new FieldView[fieldArray.length];
            int n = 0;
            while (n < fieldArray.length) {
                this.fields[n] = new FieldView(this, fieldArray[n]);
                ++n;
            }
        }
        return this.fields;
    }

    public ConstructorView[] getConstructors() {
        if (this.constructors == null) {
            Constructor<?>[] constructorArray = this.cl.getDeclaredConstructors();
            this.constructors = new ConstructorView[constructorArray.length];
            int n = 0;
            while (n < this.constructors.length) {
                this.constructors[n] = new ConstructorView(this, constructorArray[n]);
                ++n;
            }
        }
        return this.constructors;
    }

    public Comment getComment() {
        this.loadComments();
        return this.comment;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
    }

    protected void loadComments() {
        if (this.comments_loaded) {
            return;
        }
        this.comments_loaded = true;
        Hashtable hashtable = new Hashtable();
        this.addMembers(hashtable, this.getAllFields());
        this.addMembers(hashtable, this.getConstructors());
        this.addMembers(hashtable, this.getAllMethods());
        View view = this;
        while (view != null) {
            Object object;
            CommentList commentList = null;
            String string = view.getQualifiedName().replace('.', '/') + ".ctxt";
            try {
                object = null;
                object = view.cl.getClassLoader() == null ? ClassLoader.getSystemResourceAsStream(string) : view.cl.getClassLoader().getResourceAsStream(string);
                if (object != null) {
                    commentList = new CommentList();
                    commentList.load((InputStream)object);
                    ((InputStream)object).close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (commentList != null) {
                object = commentList.getComments();
                while (object.hasMoreElements()) {
                    Comment comment = (Comment)object.nextElement();
                    if (comment.getTarget().startsWith("class ") || comment.getTarget().startsWith("interface ")) {
                        if (view != this) continue;
                        this.setComment(comment);
                        continue;
                    }
                    MemberView memberView = (MemberView)hashtable.get(comment.getTarget());
                    if (memberView == null) continue;
                    memberView.setComment(comment);
                }
            }
            view = view.getSuper();
        }
    }

    private void addMembers(Hashtable hashtable, MemberView[] memberViewArray) {
        int n = 0;
        while (n < memberViewArray.length) {
            hashtable.put(memberViewArray[n].getSignature(), memberViewArray[n]);
            ++n;
        }
    }

    public String getTypeName() {
        return View.getTypeName(this.cl);
    }

    static String getTypeName(Class clazz) {
        if (clazz.isArray()) {
            try {
                Class<?> clazz2 = clazz;
                int n = 0;
                while (clazz2.isArray()) {
                    ++n;
                    clazz2 = clazz2.getComponentType();
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(JavaNames.stripPrefix(clazz2.getName()));
                int n2 = 0;
                while (n2 < n) {
                    stringBuffer.append("[]");
                    ++n2;
                }
                return stringBuffer.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return JavaNames.stripPrefix(clazz.getName());
    }

    public int getInstanceNum() {
        return ++this.instanceNum;
    }

    public String getLongDesc() {
        String string = Modifier.toString(this.cl.getModifiers()) + " class " + this.cl.getName();
        return string;
    }

    public void print(FormattedPrintWriter formattedPrintWriter) {
        this.print(formattedPrintWriter, null);
    }

    public void print(FormattedPrintWriter formattedPrintWriter, ViewFilter viewFilter) {
        Comment comment = this.getComment();
        if (comment != null) {
            comment.print(formattedPrintWriter);
            formattedPrintWriter.println("");
        }
        formattedPrintWriter.setItalic(false);
        formattedPrintWriter.setBold(true);
        formattedPrintWriter.println(this.getLongDesc());
        formattedPrintWriter.setItalic(false);
        formattedPrintWriter.setBold(false);
        formattedPrintWriter.println("{");
        formattedPrintWriter.setItalic(true);
        formattedPrintWriter.println("fields:");
        formattedPrintWriter.setItalic(false);
        FieldView[] fieldViewArray = this.getAllFields();
        int n = 0;
        while (n < fieldViewArray.length) {
            if (viewFilter == null || viewFilter.accept(fieldViewArray[n])) {
                fieldViewArray[n].print(formattedPrintWriter, 1);
            }
            ++n;
        }
        formattedPrintWriter.println("");
        formattedPrintWriter.setItalic(true);
        formattedPrintWriter.println("constructors:");
        formattedPrintWriter.setItalic(false);
        ConstructorView[] constructorViewArray = this.getConstructors();
        int n2 = 0;
        while (n2 < constructorViewArray.length) {
            if (viewFilter == null || viewFilter.accept(constructorViewArray[n2])) {
                constructorViewArray[n2].print(formattedPrintWriter, 1);
                formattedPrintWriter.println("");
            }
            ++n2;
        }
        formattedPrintWriter.setItalic(true);
        formattedPrintWriter.println("methods:");
        formattedPrintWriter.setItalic(false);
        MethodView[] methodViewArray = this.getAllMethods();
        int n3 = methodViewArray.length - 1;
        while (n3 >= 0) {
            if (viewFilter == null || viewFilter.accept(methodViewArray[n3])) {
                methodViewArray[n3].print(formattedPrintWriter, 1);
                formattedPrintWriter.println("");
            }
            --n3;
        }
        formattedPrintWriter.setItalic(false);
        formattedPrintWriter.setBold(false);
        formattedPrintWriter.println("}");
    }

    private View(Class clazz) {
        this.cl = clazz;
    }

    class MemberElement {
        int index;
        MemberView member;

        MemberElement(int n, MemberView memberView) {
            this.index = n;
            this.member = memberView;
        }
    }

    class ElementComparer
    implements Comparer {
        public final int cmp(Object object, Object object2) {
            int n = ((MemberElement)object).index - ((MemberElement)object2).index;
            return n < 0 ? -1 : (n > 0 ? 1 : 0);
        }

        ElementComparer() {
        }
    }
}

