/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class FileChooserDemo
extends JPanel
implements ActionListener {
    static JFrame frame;
    static String metal;
    static String metalClassName;
    static String motif;
    static String motifClassName;
    static String windows;
    static String windowsClassName;
    JButton showButton;
    JButton noAllFilesFilterButton;
    JButton yesAllFilesFilterButton;
    JCheckBox useFileViewCheckBox;
    JCheckBox accessoryCheckBox;
    JCheckBox setHiddenCheckBox;
    JCheckBox showFullDescriptionCheckBox;
    JCheckBox useControlsCheckBox;
    JRadioButton singleSelectionRadioButton;
    JRadioButton multiSelectionRadioButton;
    JRadioButton addFiltersRadioButton;
    JRadioButton defaultFiltersRadioButton;
    JRadioButton openRadioButton;
    JRadioButton saveRadioButton;
    JRadioButton customButton;
    JRadioButton metalRadioButton;
    JRadioButton motifRadioButton;
    JRadioButton windowsRadioButton;
    JRadioButton justFilesRadioButton;
    JRadioButton justDirectoriesRadioButton;
    JRadioButton bothFilesAndDirectoriesRadioButton;
    JTextField customField;
    ExampleFileFilter jpgFilter;
    ExampleFileFilter gifFilter;
    ExampleFileFilter bothFilter;
    ExampleFileView fileView;
    JPanel buttonPanel;
    public static final Dimension hpad10;
    public static final Dimension vpad10;
    public static final Insets insets;
    FilePreviewer previewer;
    JFileChooser chooser;

    public FileChooserDemo() {
        this.setLayout(new BoxLayout(this, 1));
        this.chooser = new JFileChooser();
        this.previewer = new FilePreviewer(this.chooser);
        this.chooser.setAccessory(this.previewer);
        this.jpgFilter = new ExampleFileFilter("jpg", "JPEG Compressed Image Files");
        this.gifFilter = new ExampleFileFilter("gif", "GIF Image Files");
        this.bothFilter = new ExampleFileFilter(new String[]{"jpg", "gif"}, "JPEG and GIF Image Files");
        this.fileView = new ExampleFileView();
        this.fileView.putIcon("jpg", new ImageIcon("images/jpgIcon.jpg"));
        this.fileView.putIcon("gif", new ImageIcon("images/gifIcon.gif"));
        this.chooser.setAccessory(this.previewer);
        this.chooser.setFileView(this.fileView);
        OptionListener optionListener = new OptionListener();
        this.openRadioButton = new JRadioButton("Open");
        this.openRadioButton.setSelected(true);
        this.openRadioButton.addActionListener(optionListener);
        this.saveRadioButton = new JRadioButton("Save");
        this.saveRadioButton.addActionListener(optionListener);
        this.customButton = new JRadioButton("Custom");
        this.customButton.addActionListener(optionListener);
        this.customField = new JTextField(){

            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        this.customField.setText("Doit");
        this.customField.setAlignmentY(0.0f);
        this.customField.setEnabled(false);
        this.customField.addActionListener(optionListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.openRadioButton);
        buttonGroup.add(this.saveRadioButton);
        buttonGroup.add(this.customButton);
        this.noAllFilesFilterButton = new JButton("Remove \"All Files\" Filter");
        this.noAllFilesFilterButton.addActionListener(optionListener);
        this.yesAllFilesFilterButton = new JButton("Add \"All Files\" Filter");
        this.yesAllFilesFilterButton.addActionListener(optionListener);
        this.defaultFiltersRadioButton = new JRadioButton("Default Filtering");
        this.defaultFiltersRadioButton.setSelected(true);
        this.defaultFiltersRadioButton.addActionListener(optionListener);
        this.addFiltersRadioButton = new JRadioButton("Add JPG and GIF Filters");
        this.addFiltersRadioButton.addActionListener(optionListener);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.addFiltersRadioButton);
        buttonGroup2.add(this.defaultFiltersRadioButton);
        this.accessoryCheckBox = new JCheckBox("Show Preview");
        this.accessoryCheckBox.addActionListener(optionListener);
        this.accessoryCheckBox.setSelected(true);
        this.setHiddenCheckBox = new JCheckBox("Show Hidden Files");
        this.setHiddenCheckBox.addActionListener(optionListener);
        this.showFullDescriptionCheckBox = new JCheckBox("Show Extensions");
        this.showFullDescriptionCheckBox.addActionListener(optionListener);
        this.showFullDescriptionCheckBox.setSelected(true);
        this.useFileViewCheckBox = new JCheckBox("Use FileView");
        this.useFileViewCheckBox.addActionListener(optionListener);
        this.useFileViewCheckBox.setSelected(true);
        this.useControlsCheckBox = new JCheckBox("Show Control Buttons");
        this.useControlsCheckBox.addActionListener(optionListener);
        this.useControlsCheckBox.setSelected(true);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        this.justFilesRadioButton = new JRadioButton("Just Select Files");
        this.justFilesRadioButton.setSelected(true);
        buttonGroup3.add(this.justFilesRadioButton);
        this.justFilesRadioButton.addActionListener(optionListener);
        this.justDirectoriesRadioButton = new JRadioButton("Just Select Directories");
        buttonGroup3.add(this.justDirectoriesRadioButton);
        this.justDirectoriesRadioButton.addActionListener(optionListener);
        this.bothFilesAndDirectoriesRadioButton = new JRadioButton("Select Files or Directories");
        buttonGroup3.add(this.bothFilesAndDirectoriesRadioButton);
        this.bothFilesAndDirectoriesRadioButton.addActionListener(optionListener);
        this.singleSelectionRadioButton = new JRadioButton("Single Selection", true);
        this.singleSelectionRadioButton.addActionListener(optionListener);
        this.multiSelectionRadioButton = new JRadioButton("Multi Selection");
        this.multiSelectionRadioButton.addActionListener(optionListener);
        ButtonGroup buttonGroup4 = new ButtonGroup();
        buttonGroup4.add(this.singleSelectionRadioButton);
        buttonGroup4.add(this.multiSelectionRadioButton);
        this.showButton = new JButton("Show FileChooser");
        this.showButton.addActionListener(this);
        this.showButton.setMnemonic('s');
        this.metalRadioButton = new JRadioButton(metal);
        this.metalRadioButton.setMnemonic('o');
        this.metalRadioButton.setActionCommand(metalClassName);
        this.motifRadioButton = new JRadioButton(motif);
        this.motifRadioButton.setMnemonic('m');
        this.motifRadioButton.setActionCommand(motifClassName);
        this.windowsRadioButton = new JRadioButton(windows);
        this.windowsRadioButton.setMnemonic('w');
        this.windowsRadioButton.setActionCommand(windowsClassName);
        ButtonGroup buttonGroup5 = new ButtonGroup();
        buttonGroup5.add(this.metalRadioButton);
        buttonGroup5.add(this.motifRadioButton);
        buttonGroup5.add(this.windowsRadioButton);
        this.metalRadioButton.addActionListener(optionListener);
        this.motifRadioButton.addActionListener(optionListener);
        this.windowsRadioButton.addActionListener(optionListener);
        InsetPanel insetPanel = new InsetPanel(insets);
        insetPanel.setBorder(BorderFactory.createTitledBorder("Dialog Type"));
        insetPanel.setLayout(new BoxLayout(insetPanel, 1));
        insetPanel.add(Box.createRigidArea(vpad10));
        insetPanel.add(this.openRadioButton);
        insetPanel.add(Box.createRigidArea(vpad10));
        insetPanel.add(this.saveRadioButton);
        insetPanel.add(Box.createRigidArea(vpad10));
        insetPanel.add(this.customButton);
        insetPanel.add(Box.createRigidArea(vpad10));
        insetPanel.add(this.customField);
        insetPanel.add(Box.createGlue());
        InsetPanel insetPanel2 = new InsetPanel(insets);
        insetPanel2.setBorder(BorderFactory.createTitledBorder("Filter Controls"));
        insetPanel2.setLayout(new BoxLayout(insetPanel2, 1));
        insetPanel2.add(Box.createRigidArea(vpad10));
        insetPanel2.add(this.noAllFilesFilterButton);
        insetPanel2.add(Box.createRigidArea(vpad10));
        insetPanel2.add(this.yesAllFilesFilterButton);
        insetPanel2.add(Box.createRigidArea(vpad10));
        insetPanel2.add(this.defaultFiltersRadioButton);
        insetPanel2.add(Box.createRigidArea(vpad10));
        insetPanel2.add(this.addFiltersRadioButton);
        insetPanel2.add(Box.createRigidArea(vpad10));
        insetPanel2.add(Box.createGlue());
        InsetPanel insetPanel3 = new InsetPanel(insets);
        insetPanel3.setBorder(BorderFactory.createTitledBorder("Display Options"));
        insetPanel3.setLayout(new BoxLayout(insetPanel3, 1));
        insetPanel3.add(Box.createRigidArea(vpad10));
        insetPanel3.add(this.setHiddenCheckBox);
        insetPanel3.add(Box.createRigidArea(vpad10));
        insetPanel3.add(this.showFullDescriptionCheckBox);
        insetPanel3.add(Box.createRigidArea(vpad10));
        insetPanel3.add(this.useFileViewCheckBox);
        insetPanel3.add(Box.createRigidArea(vpad10));
        insetPanel3.add(this.accessoryCheckBox);
        insetPanel3.add(Box.createRigidArea(vpad10));
        insetPanel3.add(this.useControlsCheckBox);
        insetPanel3.add(Box.createRigidArea(vpad10));
        insetPanel3.add(Box.createGlue());
        InsetPanel insetPanel4 = new InsetPanel(insets);
        insetPanel4.setBorder(BorderFactory.createTitledBorder("File and Directory Options"));
        insetPanel4.setLayout(new BoxLayout(insetPanel4, 1));
        insetPanel4.add(Box.createRigidArea(vpad10));
        insetPanel4.add(this.justFilesRadioButton);
        insetPanel4.add(Box.createRigidArea(vpad10));
        insetPanel4.add(this.justDirectoriesRadioButton);
        insetPanel4.add(Box.createRigidArea(vpad10));
        insetPanel4.add(this.bothFilesAndDirectoriesRadioButton);
        insetPanel4.add(Box.createRigidArea(vpad10));
        insetPanel4.add(Box.createRigidArea(vpad10));
        insetPanel4.add(this.singleSelectionRadioButton);
        insetPanel4.add(Box.createRigidArea(vpad10));
        insetPanel4.add(this.multiSelectionRadioButton);
        insetPanel4.add(Box.createRigidArea(vpad10));
        insetPanel4.add(Box.createGlue());
        InsetPanel insetPanel5 = new InsetPanel(insets);
        insetPanel5.setLayout(new BoxLayout(insetPanel5, 0));
        insetPanel5.add(Box.createRigidArea(hpad10));
        insetPanel5.add(this.metalRadioButton);
        insetPanel5.add(Box.createRigidArea(hpad10));
        insetPanel5.add(this.motifRadioButton);
        insetPanel5.add(Box.createRigidArea(hpad10));
        insetPanel5.add(this.windowsRadioButton);
        insetPanel5.add(Box.createRigidArea(hpad10));
        insetPanel5.add(this.showButton);
        insetPanel5.add(Box.createRigidArea(hpad10));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.add(Box.createRigidArea(vpad10));
        jPanel.add(Box.createRigidArea(hpad10));
        jPanel.add(insetPanel);
        jPanel.add(Box.createRigidArea(hpad10));
        jPanel.add(insetPanel2);
        jPanel.add(Box.createRigidArea(hpad10));
        jPanel.add(insetPanel3);
        jPanel.add(Box.createRigidArea(hpad10));
        jPanel.add(insetPanel4);
        jPanel.add(Box.createRigidArea(hpad10));
        jPanel.add(Box.createRigidArea(hpad10));
        jPanel.add(insetPanel5);
        jPanel.add(Box.createRigidArea(hpad10));
        this.add(jPanel);
        this.add(Box.createRigidArea(vpad10));
        this.add(Box.createRigidArea(vpad10));
        this.add(insetPanel5);
        this.add(Box.createRigidArea(vpad10));
        this.add(Box.createRigidArea(vpad10));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.chooser.showDialog(frame, null);
        if (n == 0) {
            File file = this.chooser.getSelectedFile();
            if (file != null) {
                File[] fileArray = this.chooser.getSelectedFiles();
                if (this.chooser.isMultiSelectionEnabled() && fileArray != null && fileArray.length > 1) {
                    String string = "";
                    int n2 = 0;
                    while (n2 < fileArray.length) {
                        string = string + "\n" + fileArray[n2].getPath();
                        ++n2;
                    }
                    JOptionPane.showMessageDialog(frame, "You chose these files: \n" + string);
                } else if (file.isDirectory()) {
                    JOptionPane.showMessageDialog(frame, "You chose this directory: " + this.chooser.getSelectedFile().getPath());
                } else {
                    JOptionPane.showMessageDialog(frame, "You chose this file: " + this.chooser.getSelectedFile().getPath());
                }
                return;
            }
        } else if (n == 1) {
            JOptionPane.showMessageDialog(frame, "User cancelled operation. No file was chosen.");
        } else if (n == -1) {
            JOptionPane.showMessageDialog(frame, "An error occured. No file was chosen.");
        } else {
            JOptionPane.showMessageDialog(frame, "Unknown operation occured.");
        }
    }

    public void updateState() {
        String string = UIManager.getLookAndFeel().getClass().getName();
        if (string.indexOf(metal) >= 0) {
            this.metalRadioButton.setSelected(true);
        } else if (string.indexOf(windows) >= 0) {
            this.windowsRadioButton.setSelected(true);
        } else if (string.indexOf(motif) >= 0) {
            this.motifRadioButton.setSelected(true);
        } else {
            System.err.println("FileChooserDemo if using an unknown L&F: " + string);
        }
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Error loading L&F: " + exception);
        }
        FileChooserDemo fileChooserDemo = new FileChooserDemo();
        frame = new JFrame("FileChooserDemo");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        frame.getContentPane().add("Center", fileChooserDemo);
        frame.pack();
        ((Component)frame).setVisible(true);
        fileChooserDemo.updateState();
    }

    static {
        metal = "Metal";
        metalClassName = "javax.swing.plaf.metal.MetalLookAndFeel";
        motif = "Motif";
        motifClassName = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
        windows = "Windows";
        windowsClassName = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        hpad10 = new Dimension(10, 1);
        vpad10 = new Dimension(1, 10);
        insets = new Insets(5, 10, 0, 10);
    }

    class InsetPanel
    extends JPanel {
        Insets i;

        InsetPanel(Insets insets) {
            this.i = insets;
        }

        public Insets getInsets() {
            return this.i;
        }
    }

    class FilePreviewer
    extends JComponent
    implements PropertyChangeListener {
        ImageIcon thumbnail = null;
        File f = null;

        public FilePreviewer(JFileChooser jFileChooser) {
            this.setPreferredSize(new Dimension(100, 50));
            jFileChooser.addPropertyChangeListener(this);
        }

        public void loadImage() {
            if (this.f != null) {
                ImageIcon imageIcon = new ImageIcon(this.f.getPath());
                this.thumbnail = imageIcon.getIconWidth() > 90 ? new ImageIcon(imageIcon.getImage().getScaledInstance(90, -1, 1)) : imageIcon;
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "SelectedFileChangedProperty") {
                this.f = (File)propertyChangeEvent.getNewValue();
                if (this.isShowing()) {
                    this.loadImage();
                    this.repaint();
                }
            }
        }

        public void paint(Graphics graphics) {
            if (this.thumbnail == null) {
                this.loadImage();
            }
            if (this.thumbnail != null) {
                int n = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
                int n2 = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n < 5) {
                    n = 5;
                }
                this.thumbnail.paintIcon(this, graphics, n, n2);
            }
        }
    }

    class OptionListener
    implements ActionListener {
        OptionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            if (jComponent == FileChooserDemo.this.openRadioButton) {
                FileChooserDemo.this.chooser.setDialogType(0);
                FileChooserDemo.this.customField.setEnabled(false);
                FileChooserDemo.this.repaint();
            } else if (jComponent == FileChooserDemo.this.useControlsCheckBox) {
                boolean bl = ((JCheckBox)jComponent).isSelected();
                FileChooserDemo.this.chooser.setControlButtonsAreShown(bl);
            } else if (jComponent == FileChooserDemo.this.saveRadioButton) {
                FileChooserDemo.this.chooser.setDialogType(1);
                FileChooserDemo.this.customField.setEnabled(false);
                FileChooserDemo.this.repaint();
            } else if (jComponent == FileChooserDemo.this.customButton || jComponent == FileChooserDemo.this.customField) {
                FileChooserDemo.this.customField.setEnabled(true);
                FileChooserDemo.this.chooser.setDialogType(2);
                FileChooserDemo.this.chooser.setApproveButtonText(FileChooserDemo.this.customField.getText());
                FileChooserDemo.this.repaint();
            } else if (jComponent == FileChooserDemo.this.noAllFilesFilterButton) {
                FileChooserDemo.this.chooser.setAcceptAllFileFilterUsed(false);
            } else if (jComponent == FileChooserDemo.this.yesAllFilesFilterButton) {
                FileChooserDemo.this.chooser.setAcceptAllFileFilterUsed(true);
            } else if (jComponent == FileChooserDemo.this.defaultFiltersRadioButton) {
                FileChooserDemo.this.chooser.resetChoosableFileFilters();
            } else if (jComponent == FileChooserDemo.this.addFiltersRadioButton) {
                FileChooserDemo.this.chooser.addChoosableFileFilter(FileChooserDemo.this.bothFilter);
                FileChooserDemo.this.chooser.addChoosableFileFilter(FileChooserDemo.this.jpgFilter);
                FileChooserDemo.this.chooser.addChoosableFileFilter(FileChooserDemo.this.gifFilter);
            } else if (jComponent == FileChooserDemo.this.setHiddenCheckBox) {
                FileChooserDemo.this.chooser.setFileHidingEnabled(!FileChooserDemo.this.setHiddenCheckBox.isSelected());
            } else if (jComponent == FileChooserDemo.this.accessoryCheckBox) {
                if (FileChooserDemo.this.accessoryCheckBox.isSelected()) {
                    FileChooserDemo.this.chooser.setAccessory(FileChooserDemo.this.previewer);
                } else {
                    FileChooserDemo.this.chooser.setAccessory(null);
                }
            } else if (jComponent == FileChooserDemo.this.useFileViewCheckBox) {
                if (FileChooserDemo.this.useFileViewCheckBox.isSelected()) {
                    FileChooserDemo.this.chooser.setFileView(FileChooserDemo.this.fileView);
                } else {
                    FileChooserDemo.this.chooser.setFileView(null);
                }
            } else if (jComponent == FileChooserDemo.this.showFullDescriptionCheckBox) {
                FileChooserDemo.this.jpgFilter.setExtensionListInDescription(FileChooserDemo.this.showFullDescriptionCheckBox.isSelected());
                FileChooserDemo.this.gifFilter.setExtensionListInDescription(FileChooserDemo.this.showFullDescriptionCheckBox.isSelected());
                FileChooserDemo.this.bothFilter.setExtensionListInDescription(FileChooserDemo.this.showFullDescriptionCheckBox.isSelected());
                if (FileChooserDemo.this.addFiltersRadioButton.isSelected()) {
                    FileChooserDemo.this.chooser.resetChoosableFileFilters();
                    FileChooserDemo.this.chooser.addChoosableFileFilter(FileChooserDemo.this.bothFilter);
                    FileChooserDemo.this.chooser.addChoosableFileFilter(FileChooserDemo.this.jpgFilter);
                    FileChooserDemo.this.chooser.setFileFilter(FileChooserDemo.this.gifFilter);
                }
            } else if (jComponent == FileChooserDemo.this.justFilesRadioButton) {
                FileChooserDemo.this.chooser.setFileSelectionMode(0);
            } else if (jComponent == FileChooserDemo.this.justDirectoriesRadioButton) {
                FileChooserDemo.this.chooser.setFileSelectionMode(1);
            } else if (jComponent == FileChooserDemo.this.bothFilesAndDirectoriesRadioButton) {
                FileChooserDemo.this.chooser.setFileSelectionMode(2);
            } else if (jComponent == FileChooserDemo.this.singleSelectionRadioButton) {
                if (FileChooserDemo.this.singleSelectionRadioButton.isSelected()) {
                    FileChooserDemo.this.chooser.setMultiSelectionEnabled(false);
                }
            } else if (jComponent == FileChooserDemo.this.multiSelectionRadioButton) {
                if (FileChooserDemo.this.multiSelectionRadioButton.isSelected()) {
                    FileChooserDemo.this.chooser.setMultiSelectionEnabled(true);
                }
            } else {
                String string = actionEvent.getActionCommand();
                try {
                    UIManager.setLookAndFeel(string);
                    SwingUtilities.updateComponentTreeUI(frame);
                    if (FileChooserDemo.this.chooser != null) {
                        SwingUtilities.updateComponentTreeUI(FileChooserDemo.this.chooser);
                    }
                    frame.pack();
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
                    jRadioButton.setEnabled(false);
                    FileChooserDemo.this.updateState();
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.out.println("IllegalAccessException Error:" + illegalAccessException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.out.println("ClassNotFoundException Error:" + classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    System.out.println("InstantiateException Error:" + instantiationException);
                }
            }
        }
    }
}

