/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class Wonderland {
    DefaultStyledDocument doc;
    StyleContext styles;
    Hashtable runAttr;
    Paragraph[] data = new Paragraph[]{new Paragraph("title", new Run[]{new Run("none", "ALICE'S ADVENTURES IN WONDERLAND")}), new Paragraph("author", new Run[]{new Run("none", "Lewis Carroll")}), new Paragraph("heading", new Run[]{new Run("alice", " ")}), new Paragraph("edition", new Run[]{new Run("none", "THE MILLENNIUM FULCRUM EDITION 3.0")}), new Paragraph("heading", new Run[]{new Run("none", "CHAPTER V")}), new Paragraph("subtitle", new Run[]{new Run("none", "Advice from a Caterpillar")}), new Paragraph("normal", new Run[]{new Run("none", " ")}), new Paragraph("normal", new Run[]{new Run("none", "The Caterpillar and Alice looked at each other for some time in silence:  at last the Caterpillar took the hookah out of its mouth, and addressed her in a languid, sleepy voice.")}), new Paragraph("normal", new Run[]{new Run("cquote", "Who are YOU?  "), new Run("none", "said the Caterpillar.")}), new Paragraph("normal", new Run[]{new Run("none", "This was not an encouraging opening for a conversation.  Alice replied, rather shyly, "), new Run("aquote", "I--I hardly know, sir, just at present--at least I know who I WAS when I got up this morning, but I think I must have been changed several times since then. ")}), new Paragraph("heading", new Run[]{new Run("caterpillar", " ")}), new Paragraph("normal", new Run[]{new Run("cquote", "What do you mean by that? "), new Run("none", " said the Caterpillar sternly.  "), new Run("cquote", "Explain yourself!")}), new Paragraph("normal", new Run[]{new Run("aquote", "I can't explain MYSELF, I'm afraid, sir"), new Run("none", " said Alice, "), new Run("aquote", "because I'm not myself, you see.")}), new Paragraph("normal", new Run[]{new Run("cquote", "I don't see,"), new Run("none", " said the Caterpillar.")}), new Paragraph("normal", new Run[]{new Run("aquote", "I'm afraid I can't put it more clearly,  "), new Run("none", "Alice replied very politely, "), new Run("aquote", "for I can't understand it myself to begin with; and being so many different sizes in a day is very confusing.")}), new Paragraph("normal", new Run[]{new Run("cquote", "It isn't,  "), new Run("none", "said the Caterpillar.")}), new Paragraph("normal", new Run[]{new Run("aquote", "Well, perhaps you haven't found it so yet,"), new Run("none", " said Alice; "), new Run("aquote", "but when you have to turn into a chrysalis--you will some day, you know--and then after that into a butterfly, I should think you'll feel it a little queer, won't you?")}), new Paragraph("normal", new Run[]{new Run("cquote", "Not a bit, "), new Run("none", "said the Caterpillar.")}), new Paragraph("normal", new Run[]{new Run("aquote", "Well, perhaps your feelings may be different,"), new Run("none", " said Alice; "), new Run("aquote", "all I know is, it would feel very queer to ME.")}), new Paragraph("normal", new Run[]{new Run("cquote", "You!"), new Run("none", " said the Caterpillar contemptuously.  "), new Run("cquote", "Who are YOU?")}), new Paragraph("normal", new Run[]{new Run("normal", "Which brought them back again to the beginning of the conversation.  Alice felt a little irritated at the Caterpillar's making such VERY short remarks, and she drew herself up and said, very gravely, "), new Run("aquote", "I think, you ought to tell me who YOU are, first.")}), new Paragraph("normal", new Run[]{new Run("cquote", "Why?  "), new Run("none", "said the Caterpillar.")}), new Paragraph("heading", new Run[]{new Run("hatter", " ")}), new Paragraph("normal", new Run[]{new Run("none", " ")}), new Paragraph("normal", new Run[]{new Run("none", " ")}), new Paragraph("normal", new Run[]{new Run("none", " ")})};

    Wonderland(DefaultStyledDocument defaultStyledDocument, StyleContext styleContext) {
        this.doc = defaultStyledDocument;
        this.styles = styleContext;
        this.runAttr = new Hashtable();
    }

    void loadDocument() {
        this.createStyles();
        int n = 0;
        while (n < this.data.length) {
            Paragraph paragraph = this.data[n];
            this.addParagraph(paragraph);
            ++n;
        }
    }

    void addParagraph(Paragraph paragraph) {
        try {
            Object object;
            Style style = null;
            int n = 0;
            while (n < paragraph.data.length) {
                object = paragraph.data[n];
                style = (Style)this.runAttr.get(((Run)object).attr);
                this.doc.insertString(this.doc.getLength(), ((Run)object).content, style);
                ++n;
            }
            object = this.styles.getStyle(paragraph.logical);
            this.doc.setLogicalStyle(this.doc.getLength() - 1, (Style)object);
            this.doc.insertString(this.doc.getLength(), "\n", null);
        }
        catch (BadLocationException badLocationException) {
            System.err.println("Internal error: " + badLocationException);
        }
    }

    void createStyles() {
        Object object;
        Object object2;
        Object object3;
        Style style = this.styles.addStyle(null, null);
        this.runAttr.put("none", style);
        style = this.styles.addStyle(null, null);
        StyleConstants.setItalic(style, true);
        StyleConstants.setForeground(style, new Color(153, 153, 102));
        this.runAttr.put("cquote", style);
        style = this.styles.addStyle(null, null);
        StyleConstants.setItalic(style, true);
        StyleConstants.setForeground(style, new Color(51, 102, 153));
        this.runAttr.put("aquote", style);
        try {
            object3 = ResourceBundle.getBundle("resources.Stylepad", Locale.getDefault());
            style = this.styles.addStyle(null, null);
            object2 = new ImageIcon(((ResourceBundle)object3).getString("aliceGif"));
            StyleConstants.setIcon(style, (Icon)object2);
            this.runAttr.put("alice", style);
            style = this.styles.addStyle(null, null);
            object = new ImageIcon(((ResourceBundle)object3).getString("caterpillarGif"));
            StyleConstants.setIcon(style, (Icon)object);
            this.runAttr.put("caterpillar", style);
            style = this.styles.addStyle(null, null);
            ImageIcon imageIcon = new ImageIcon(((ResourceBundle)object3).getString("hatterGif"));
            StyleConstants.setIcon(style, imageIcon);
            this.runAttr.put("hatter", style);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        object3 = this.styles.getStyle("default");
        object2 = this.styles.addStyle("heading", (Style)object3);
        StyleConstants.setFontFamily((MutableAttributeSet)object2, "SansSerif");
        StyleConstants.setBold((MutableAttributeSet)object2, true);
        StyleConstants.setAlignment((MutableAttributeSet)object2, 1);
        StyleConstants.setSpaceAbove((MutableAttributeSet)object2, 10.0f);
        StyleConstants.setSpaceBelow((MutableAttributeSet)object2, 10.0f);
        StyleConstants.setFontSize((MutableAttributeSet)object2, 18);
        object = this.styles.addStyle("title", (Style)object2);
        StyleConstants.setFontSize((MutableAttributeSet)object, 32);
        object = this.styles.addStyle("edition", (Style)object2);
        StyleConstants.setFontSize((MutableAttributeSet)object, 16);
        object = this.styles.addStyle("author", (Style)object2);
        StyleConstants.setItalic((MutableAttributeSet)object, true);
        StyleConstants.setSpaceBelow((MutableAttributeSet)object, 25.0f);
        object = this.styles.addStyle("subtitle", (Style)object2);
        StyleConstants.setSpaceBelow((MutableAttributeSet)object, 35.0f);
        object = this.styles.addStyle("normal", (Style)object3);
        StyleConstants.setLeftIndent((MutableAttributeSet)object, 10.0f);
        StyleConstants.setRightIndent((MutableAttributeSet)object, 10.0f);
        StyleConstants.setFontFamily((MutableAttributeSet)object, "SansSerif");
        StyleConstants.setFontSize((MutableAttributeSet)object, 14);
        StyleConstants.setSpaceAbove((MutableAttributeSet)object, 4.0f);
        StyleConstants.setSpaceBelow((MutableAttributeSet)object, 4.0f);
    }

    static class Run {
        String attr;
        String content;

        Run(String string, String string2) {
            this.attr = string;
            this.content = string2;
        }
    }

    static class Paragraph {
        String logical;
        Run[] data;

        Paragraph(String string, Run[] runArray) {
            this.logical = string;
            this.data = runArray;
        }
    }
}

