/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class PerformanceMonitor
extends JPanel {
    Surface surf;

    public PerformanceMonitor() {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(new EtchedBorder(), "Performance"));
        this.surf = new Surface();
        this.add(this.surf);
    }

    public class Surface
    extends JPanel
    implements Runnable {
        public Thread thread;
        private BufferedImage bimg;
        private Font font = new Font("Times New Roman", 0, 12);
        private JPanel panel;

        public Surface() {
            this.setBackground(Color.black);
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ Surface this$1;
                {
                    this.this$1 = surface;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (this.this$1.thread == null) {
                        this.this$1.start();
                    } else {
                        this.this$1.stop();
                    }
                }
            });
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            int n = ((Component)this).getFontMetrics(this.font).getHeight();
            return new Dimension(135, 2 + n * 4);
        }

        public void paint(Graphics graphics) {
            if (this.bimg != null) {
                graphics.drawImage(this.bimg, 0, 0, this);
            }
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.setName("PerformanceMonitor");
            this.thread.start();
        }

        public synchronized void stop() {
            this.thread = null;
            this.setSurfaceState();
            this.notify();
        }

        public void setSurfaceState() {
            if (this.panel == null) {
                return;
            }
            Component[] componentArray = this.panel.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (((DemoPanel)componentArray[n]).surface != null) {
                    ((DemoPanel)componentArray[n]).surface.setMonitor(this.thread != null);
                }
                ++n;
            }
        }

        public void setPanel(JPanel jPanel) {
            this.panel = jPanel;
        }

        public void run() {
            Thread thread = Thread.currentThread();
            while (this.thread == thread && !this.isShowing() || this.getSize().width == 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            Dimension dimension = this.getSize();
            this.bimg = (BufferedImage)this.createImage(dimension.width, dimension.height);
            Graphics2D graphics2D = this.bimg.createGraphics();
            graphics2D.setFont(this.font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = fontMetrics.getAscent();
            int n2 = fontMetrics.getDescent();
            this.setSurfaceState();
            while (this.thread == thread && this.isShowing()) {
                graphics2D.setBackground(this.getBackground());
                graphics2D.clearRect(0, 0, dimension.width, dimension.height);
                if (this.panel == null) continue;
                Component[] componentArray = this.panel.getComponents();
                graphics2D.setColor(Color.green);
                int n3 = 1;
                int n4 = 0;
                while (n4 < componentArray.length) {
                    String string;
                    if (((DemoPanel)componentArray[n4]).surface != null && (string = ((DemoPanel)componentArray[n4]).surface.perfStr) != null) {
                        graphics2D.drawString(string, 4, (n3 += n) + 1);
                        n3 += n2;
                    }
                    ++n4;
                }
                this.repaint();
                try {
                    Thread.sleep(999L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            this.thread = null;
        }
    }
}

