/*
 * Decompiled with CFR 0.152.
 */
package demos.Fonts;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class Highlighting
extends AnimatingSurface {
    private static String[] text = new String[]{"HILIGHTING", "Java2D"};
    private static Color[] colors = new Color[]{Color.cyan, Color.lightGray};
    private static Font smallF = new Font("Courier", 0, 8);
    private int[] curPos;
    private TextLayout[] layouts;
    private Font[] fonts;

    public Highlighting() {
        this.setBackground(Color.white);
        this.fonts = new Font[2];
        this.layouts = new TextLayout[this.fonts.length];
        this.curPos = new int[this.fonts.length];
    }

    public void reset(int n, int n2) {
        this.fonts[0] = new Font("Courier", 0, n / text[0].length() + 8);
        this.fonts[1] = new Font("serif", 1, n / text[1].length());
        int n3 = 0;
        while (n3 < this.layouts.length) {
            this.curPos[n3] = 0;
            ++n3;
        }
    }

    public void step(int n, int n2) {
        this.setSleepAmount(900L);
        int n3 = 0;
        while (n3 < 2) {
            if (this.layouts[n3] != null) {
                int n4 = n3;
                int n5 = this.curPos[n4];
                this.curPos[n4] = n5 + 1;
                if (n5 == this.layouts[n3].getCharacterCount()) {
                    this.curPos[n3] = 0;
                }
            }
            ++n3;
        }
    }

    public void render(int n, int n2, Graphics2D graphics2D) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        int n3 = 0;
        while (n3 < 2) {
            this.layouts[n3] = new TextLayout(text[n3], this.fonts[n3], fontRenderContext);
            float f = (float)((double)(n / 2) - this.layouts[n3].getBounds().getWidth() / 2.0);
            float f2 = n3 == 0 ? (float)(n2 / 3) : (float)n2 * 0.75f;
            float f3 = (float)this.layouts[n3].getBounds().getWidth();
            float f4 = (float)this.layouts[n3].getBounds().getHeight();
            Shape shape = this.layouts[n3].getLogicalHighlightShape(0, this.curPos[n3]);
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
            shape = affineTransform.createTransformedShape(shape);
            float f5 = (float)shape.getBounds().getY();
            float f6 = (float)shape.getBounds().getHeight();
            graphics2D.setColor(colors[n3]);
            graphics2D.fill(shape);
            Shape[] shapeArray = this.layouts[n3].getCaretShapes(this.curPos[n3]);
            Shape shape2 = affineTransform.createTransformedShape(shapeArray[0]);
            graphics2D.setColor(Color.black);
            this.layouts[n3].draw(graphics2D, f, f2);
            graphics2D.draw(shape2);
            graphics2D.draw(new Rectangle2D.Float(f, f5, f3, f6));
            int n4 = 0;
            while (n4 <= this.layouts[n3].getCharacterCount()) {
                float[] fArray = this.layouts[n3].getCaretInfo(TextHitInfo.leading(n4));
                String string = String.valueOf((int)fArray[0]);
                TextLayout textLayout = new TextLayout(string, smallF, fontRenderContext);
                textLayout.draw(graphics2D, f + fArray[0], f5 + f6 + textLayout.getAscent() + 1.0f);
                ++n4;
            }
            ++n3;
        }
    }

    public static void main(String[] stringArray) {
        Surface.createDemoFrame(new Highlighting());
    }
}

