/*
 * Decompiled with CFR 0.152.
 */
package demos.Paint;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;

public class TextureAnim
extends AnimatingControlsSurface {
    public static final Color colorblend = new Color(0.0f, 0.0f, 1.0f, 0.5f);
    protected static BufferedImage textureImg;
    protected int bNum;
    protected int tilesize;
    private boolean newtexture;
    private TexturePaint texture;
    private Rectangle tilerect;
    private boolean bouncesize = false;
    private boolean bouncerect = true;
    private boolean rotate = false;
    private boolean shearx = false;
    private boolean sheary = false;
    private boolean showanchor = true;
    private boolean quality = false;
    private AnimVal w;
    private AnimVal h;
    private AnimVal x;
    private AnimVal y;
    private AnimVal rot;
    private AnimVal shx;
    private AnimVal shy;
    private static Image[] img;

    public TextureAnim() {
        TextureAnim.img[0] = this.getImage("duke.gif");
        TextureAnim.img[1] = this.getImage("duke.png");
        textureImg = this.makeImage(32, 0);
        this.tilesize = textureImg.getWidth();
        this.w = new AnimVal(0, 200, 3, 10, this.tilesize);
        this.h = new AnimVal(0, 200, 3, 10, this.tilesize);
        this.x = new AnimVal(0, 200, 3, 10, 0);
        this.y = new AnimVal(0, 200, 3, 10, 0);
        this.rot = new AnimVal(-360, 360, 5, 15, 0);
        this.shx = new AnimVal(-50, 50, 3, 10, 0);
        this.shy = new AnimVal(-50, 50, 3, 10, 0);
        this.tilerect = new Rectangle(this.x.getInt(), this.y.getInt(), this.w.getInt(), this.h.getInt());
        this.texture = new TexturePaint(textureImg, this.tilerect);
        this.setControls(new Component[]{new DemoControls(this)});
    }

    protected BufferedImage makeImage(int n, int n2) {
        this.newtexture = true;
        this.bNum = n2;
        switch (this.bNum) {
            case 0: {
                return this.makeBGRImage(n);
            }
            case 1: {
                return this.makeGIFImage(n);
            }
            case 2: {
                return this.makePNGImage(n);
            }
        }
        return null;
    }

    private BufferedImage makeBGRImage(int n) {
        BufferedImage bufferedImage = new BufferedImage(n, n, 4);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n, n);
        int n2 = 0;
        while (n2 < n) {
            float f = (float)n2 / (float)n;
            int n3 = 0;
            while (n3 < n) {
                float f2 = (float)n3 / (float)n;
                graphics2D.setColor(new Color(1.0f - f, 1.0f - f2, 0.0f, 1.0f));
                graphics2D.drawLine(n3, n2, n3, n2);
                ++n3;
            }
            ++n2;
        }
        return bufferedImage;
    }

    private BufferedImage makeGIFImage(int n) {
        BufferedImage bufferedImage = new BufferedImage(n, n, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(img[0], 0, 0, n, n, new Color(204, 204, 255), null);
        return bufferedImage;
    }

    private BufferedImage makePNGImage(int n) {
        BufferedImage bufferedImage = new BufferedImage(n, n, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(img[1], 0, 0, n, n, Color.lightGray, null);
        return bufferedImage;
    }

    public void reset(int n, int n2) {
        this.x.newlimits(-n / 4, n / 4 - this.w.getInt());
        this.y.newlimits(-n2 / 4, n2 / 4 - this.h.getInt());
    }

    public void step(int n, int n2) {
        if (this.tilesize != textureImg.getWidth()) {
            this.tilesize = textureImg.getWidth();
        }
        if (this.bouncesize) {
            this.w.anim();
            this.h.anim();
            this.x.newlimits(-n / 4, n / 4 - this.w.getInt());
            this.y.newlimits(-n2 / 4, n2 / 4 - this.h.getInt());
        } else {
            if (this.w.getInt() != this.tilesize) {
                this.w.set(this.tilesize);
                this.x.newlimits(-n / 4, n / 4 - this.w.getInt());
            }
            if (this.h.getInt() != this.tilesize) {
                this.h.set(this.tilesize);
                this.y.newlimits(-n2 / 4, n2 / 4 - this.h.getInt());
            }
        }
        if (this.bouncerect) {
            this.x.anim();
            this.y.anim();
        }
        if (this.newtexture || this.x.getInt() != this.tilerect.x || this.y.getInt() != this.tilerect.y || this.w.getInt() != this.tilerect.width || this.h.getInt() != this.tilerect.height) {
            this.newtexture = false;
            int n3 = this.x.getInt();
            int n4 = this.y.getInt();
            int n5 = this.w.getInt();
            int n6 = this.h.getInt();
            this.tilerect = new Rectangle(n3, n4, n5, n6);
            this.texture = new TexturePaint(textureImg, this.tilerect);
        }
    }

    public void render(int n, int n2, Graphics2D graphics2D) {
        graphics2D.translate(n / 2, n2 / 2);
        if (this.rotate) {
            this.rot.anim();
            graphics2D.rotate(Math.toRadians(this.rot.getFlt()));
        } else {
            this.rot.set(0.0f);
        }
        if (this.shearx) {
            this.shx.anim();
            graphics2D.shear(this.shx.getFlt() / 100.0f, 0.0);
        } else {
            this.shx.set(0.0f);
        }
        if (this.sheary) {
            this.shy.anim();
            graphics2D.shear(0.0, this.shy.getFlt() / 100.0f);
        } else {
            this.shy.set(0.0f);
        }
        graphics2D.setPaint(this.texture);
        graphics2D.fillRect(-1000, -1000, 2000, 2000);
        if (this.showanchor) {
            graphics2D.setColor(Color.black);
            graphics2D.setColor(colorblend);
            graphics2D.fill(this.tilerect);
        }
    }

    public static void main(String[] stringArray) {
        Surface.createDemoFrame(new TextureAnim());
    }

    static {
        img = new Image[2];
    }

    class DemoControls
    extends CustomControls
    implements ActionListener {
        TextureAnim demo;
        JToolBar toolbar;
        JComboBox combo;
        JMenu menu;
        JMenuItem[] menuitems;
        int iconSize = 20;

        public DemoControls(TextureAnim textureAnim2) {
            super(textureAnim2.name);
            this.demo = textureAnim2;
            this.menuitems = new JMenuItem[3];
            this.setBackground(Color.gray);
            this.toolbar = new JToolBar();
            this.add(this.toolbar);
            this.toolbar.setFloatable(false);
            this.addTool("BO", "bounce", true);
            this.addTool("SA", "show anchor", true);
            this.addTool("RS", "resize", false);
            this.addTool("RO", "rotate", false);
            this.addTool("SX", "shear x", false);
            this.addTool("SY", "shear y", false);
            this.combo = new JComboBox();
            this.add(this.combo);
            this.combo.addActionListener(this);
            this.combo.addItem("8");
            this.combo.addItem("16");
            this.combo.addItem("32");
            this.combo.addItem("64");
            this.combo.addItem("80");
            this.combo.setSelectedIndex(2);
            JMenuBar jMenuBar = new JMenuBar();
            this.menu = jMenuBar.add(new JMenu());
            int n = 0;
            while (n < 3) {
                BufferedImage bufferedImage = textureAnim2.makeImage(this.iconSize, n);
                TexturedIcon texturedIcon = new TexturedIcon(bufferedImage);
                this.menuitems[n] = this.menu.add(new JMenuItem(texturedIcon));
                this.menuitems[n].addActionListener(this);
                ++n;
            }
            this.menu.setIcon(this.menuitems[0].getIcon());
            this.add(jMenuBar);
            textureAnim2.bNum = 0;
        }

        public void addTool(String string, String string2, boolean bl) {
            JButton jButton = (JButton)this.toolbar.add(new JButton(string));
            jButton.setBackground(bl ? Color.green : Color.lightGray);
            jButton.setSelected(bl);
            jButton.setToolTipText(string2);
            jButton.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JComboBox) {
                int n = Integer.parseInt((String)this.combo.getSelectedItem());
                textureImg = this.demo.makeImage(n, this.demo.bNum);
            } else if (object instanceof JMenuItem) {
                int n = 0;
                while (n < this.menuitems.length) {
                    if (object.equals(this.menuitems[n])) {
                        textureImg = this.demo.makeImage(this.demo.tilesize, n);
                        this.menu.setIcon(this.menuitems[n].getIcon());
                        break;
                    }
                    ++n;
                }
            } else {
                JButton jButton;
                jButton.setSelected(!(jButton = (JButton)object).isSelected());
                jButton.setBackground(jButton.isSelected() ? Color.green : Color.lightGray);
                if (jButton.getText().equals("BO")) {
                    this.demo.bouncerect = jButton.isSelected();
                } else if (jButton.getText().equals("SA")) {
                    this.demo.showanchor = jButton.isSelected();
                } else if (jButton.getText().equals("RS")) {
                    this.demo.bouncesize = jButton.isSelected();
                } else if (jButton.getText().equals("RO")) {
                    this.demo.rotate = jButton.isSelected();
                } else if (jButton.getText().equals("SX")) {
                    this.demo.shearx = jButton.isSelected();
                } else if (jButton.getText().equals("SY")) {
                    this.demo.sheary = jButton.isSelected();
                }
            }
            if (this.demo.animating.thread == null) {
                this.demo.repaint();
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(200, 37);
        }

        public void run() {
            Thread thread = Thread.currentThread();
            while (this.thread == thread) {
                int n = 2;
                while (n < this.toolbar.getComponentCount()) {
                    try {
                        Thread.sleep(4444L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    ((JButton)this.toolbar.getComponentAtIndex(n)).doClick();
                    ++n;
                }
            }
            this.thread = null;
        }

        class TexturedIcon
        implements Icon {
            BufferedImage bi;

            public TexturedIcon(BufferedImage bufferedImage) {
                this.bi = bufferedImage;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Rectangle rectangle = new Rectangle(n, n2, DemoControls.this.iconSize, DemoControls.this.iconSize);
                graphics2D.setPaint(new TexturePaint(this.bi, rectangle));
                graphics2D.fillRect(n, n2, DemoControls.this.iconSize, DemoControls.this.iconSize);
                graphics2D.setColor(Color.gray);
                graphics2D.draw3DRect(n, n2, DemoControls.this.iconSize - 1, DemoControls.this.iconSize - 1, true);
            }

            public int getIconWidth() {
                return DemoControls.this.iconSize;
            }

            public int getIconHeight() {
                return DemoControls.this.iconSize;
            }
        }
    }

    static class AnimVal {
        float curval;
        float lowval;
        float highval;
        float currate;
        float lowrate;
        float highrate;

        public AnimVal(int n, int n2, int n3, int n4) {
            this.lowval = n;
            this.highval = n2;
            this.lowrate = n3;
            this.highrate = n4;
            this.curval = this.randval(n, n2);
            this.currate = this.randval(n3, n4);
        }

        public AnimVal(int n, int n2, int n3, int n4, int n5) {
            this(n, n2, n3, n4);
            this.set(n5);
        }

        public float randval(float f, float f2) {
            return (float)((double)f + Math.random() * (double)(f2 - f));
        }

        public float getFlt() {
            return this.curval;
        }

        public int getInt() {
            return (int)this.curval;
        }

        public void anim() {
            this.curval += this.currate;
            this.clip();
        }

        public void set(float f) {
            this.curval = f;
            this.clip();
        }

        public void clip() {
            if (this.curval > this.highval) {
                this.curval = this.highval - (this.curval - this.highval);
                if (this.curval < this.lowval) {
                    this.curval = this.highval;
                }
                this.currate = -this.randval(this.lowrate, this.highrate);
            } else if (this.curval < this.lowval) {
                this.curval = this.lowval + (this.lowval - this.curval);
                if (this.curval > this.highval) {
                    this.curval = this.lowval;
                }
                this.currate = this.randval(this.lowrate, this.highrate);
            }
        }

        public void newlimits(int n, int n2) {
            this.lowval = n;
            this.highval = n2;
            this.clip();
        }
    }
}

