/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.extension;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import sun.misc.ExtensionInfo;
import sun.misc.ExtensionInstallationException;
import sun.misc.ExtensionInstallationProvider;
import sun.plugin.AppletViewer;
import sun.plugin.extension.ExtensionInstaller;
import sun.plugin.extension.ExtensionUtils;
import sun.plugin.extension.JavaExtensionInstaller;
import sun.plugin.extension.NativeExtensionInstaller;
import sun.plugin.extension.RawExtensionInstaller;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.security.TrustDecider;
import sun.plugin.usability.DialogFactory;
import sun.plugin.usability.Trace;
import sun.security.action.GetPropertyAction;

public class ExtensionInstallationImpl
implements ExtensionInstallationProvider {
    public boolean installExtension(final ExtensionInfo extensionInfo, final ExtensionInfo extensionInfo2) throws ExtensionInstallationException {
        Trace.extPrintln("Optional Package to be installed " + extensionInfo);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, ExtensionInstallationException, CertificateException, CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, KeyStoreException, NoSuchAlgorithmException, IOException, InterruptedException {
                    String string = ExtensionUtils.makePlatformDependent(ExtensionUtils.extractJarFileName(extensionInfo.url));
                    String string2 = ExtensionUtils.makePlatformDependent(extensionInfo.url);
                    if (!ExtensionInstallationImpl.this.askUserForAcknowledgment(extensionInfo, extensionInfo2)) {
                        throw new ExtensionInstallationException("User denied installation of " + string2);
                    }
                    URL uRL = new URL(string2);
                    URLConnection uRLConnection = uRL.openConnection();
                    InputStream inputStream = uRLConnection.getInputStream();
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                    String string3 = ExtensionUtils.getTempDir() + File.separator + string;
                    File file = new File(string3);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    ExtensionUtils.copy(bufferedInputStream, bufferedOutputStream);
                    bufferedInputStream.close();
                    inputStream.close();
                    bufferedOutputStream.close();
                    fileOutputStream.close();
                    ExtensionInstallationImpl.this.verifyJar(string2, string3);
                    ExtensionInstallationImpl.this.installJarFile(string2, string3);
                    if (file.exists()) {
                        file.delete();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            String string = null;
            string = exception instanceof CertificateExpiredException ? ResourceHandler.getMessage("optpkg.cert_expired") : (exception instanceof CertificateNotYetValidException ? ResourceHandler.getMessage("optpkg.cert_notyieldvalid") : (exception instanceof CertificateException ? ResourceHandler.getMessage("optpkg.cert_notverify") : ResourceHandler.getMessage("optpkg.general_error")));
            Trace.extPrintException(exception, string, ResourceHandler.getMessage("optpkg.caption"));
            Trace.extPrintln("Optional Package Installation failed.");
            return false;
        }
        Trace.extPrintln("Optional Package Installation succeeded.");
        return true;
    }

    private void verifyJar(String string, String string2) throws ExtensionInstallationException, CertificateException, CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, KeyStoreException, NoSuchAlgorithmException, IOException {
        try {
            Object object;
            Cloneable cloneable;
            boolean bl = false;
            JarFile jarFile = new JarFile(string2, true);
            Vector<JarEntry> vector = new Vector<JarEntry>();
            byte[] byArray = new byte[8192];
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                int n;
                cloneable = enumeration.nextElement();
                vector.addElement((JarEntry)cloneable);
                object = jarFile.getInputStream((ZipEntry)cloneable);
                while ((n = ((InputStream)object).read(byArray, 0, byArray.length)) != -1) {
                }
                ((InputStream)object).close();
            }
            jarFile.close();
            cloneable = jarFile.getManifest();
            if (cloneable != null) {
                object = new HashMap();
                Enumeration enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    CodeSource codeSource;
                    JarEntry jarEntry = (JarEntry)enumeration2.nextElement();
                    String string3 = jarEntry.getName();
                    Certificate[] certificateArray = jarEntry.getCertificates();
                    boolean bl2 = certificateArray != null && certificateArray.length > 0;
                    bl |= bl2;
                    if (!bl2 || (codeSource = (CodeSource)((HashMap)object).get(certificateArray)) != null) continue;
                    codeSource = new CodeSource(new URL(string), certificateArray);
                    ((HashMap)object).put(certificateArray, codeSource);
                    if (TrustDecider.isAllPermissionGranted(codeSource)) continue;
                    throw new ExtensionInstallationException("User deny optional package installer to be launched.");
                }
            }
            if (cloneable == null) {
                throw new ExtensionInstallationException("No manifest in the optional package installer.");
            }
            if (!bl) {
                throw new ExtensionInstallationException("Optional package installer is unsigned. (signatures missing or not parsable)");
            }
        }
        catch (IOException iOException) {
            throw new ExtensionInstallationException("IO Error. Unable to verify optional package installer.");
        }
    }

    private boolean askUserForAcknowledgment(ExtensionInfo extensionInfo, ExtensionInfo extensionInfo2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (extensionInfo2 != null) {
            int n = extensionInfo2.isCompatibleWith(extensionInfo);
            switch (n) {
                case 1: {
                    stringBuffer.append(ResourceHandler.getMessage("optpkg.prompt_user.new_spec.text0"));
                    stringBuffer.append(extensionInfo.specVersion);
                    stringBuffer.append(ResourceHandler.getMessage("optpkg.prompt_user.new_spec.text1"));
                    stringBuffer.append(extensionInfo2.title);
                    break;
                }
                case 2: {
                    stringBuffer.append(ResourceHandler.getMessage("optpkg.prompt_user.new_impl.text0"));
                    stringBuffer.append(extensionInfo.implementationVersion);
                    stringBuffer.append(ResourceHandler.getMessage("optpkg.prompt_user.new_impl.text1"));
                    stringBuffer.append(extensionInfo2.title);
                    break;
                }
                case 3: {
                    stringBuffer.append(ResourceHandler.getMessage("optpkg.prompt_user.new_vendor.text0"));
                    stringBuffer.append(extensionInfo.vendor);
                    stringBuffer.append(ResourceHandler.getMessage("optpkg.prompt_user.new_vendor.text1"));
                    stringBuffer.append(extensionInfo.vendorId);
                    stringBuffer.append(ResourceHandler.getMessage("optpkg.prompt_user.new_vendor.text2"));
                    stringBuffer.append(extensionInfo2.title);
                    break;
                }
                default: {
                    stringBuffer.append(ResourceHandler.getMessage("optpkg.prompt_user.default.text"));
                    stringBuffer.append(extensionInfo.name);
                    break;
                }
            }
        } else {
            stringBuffer.append(ResourceHandler.getMessage("optpkg.prompt_user.default.text"));
            stringBuffer.append(extensionInfo.name);
        }
        stringBuffer.append(ResourceHandler.getMessage("optpkg.prompt_user.end"));
        stringBuffer.append(ExtensionUtils.makePlatformDependent(extensionInfo.url));
        Object[] objectArray = new Object[]{ExtensionInstallationImpl.getMessage("security_dialog.buttonYes"), ExtensionInstallationImpl.getMessage("security_dialog.buttonNo"), ExtensionInstallationImpl.getMessage("security_dialog.buttonAlways")};
        int n = 0;
        if (!Trace.isAutomationEnabled()) {
            n = DialogFactory.showOptionDialog(stringBuffer, ExtensionInstallationImpl.getMessage("security_dialog.caption"), objectArray, objectArray[0]);
        } else {
            Trace.extPrintln("Automation: Accept optional package installation", 2);
            n = 0;
        }
        if (n == 0) {
            Trace.extPrintln("Optional package download granted by user, download from " + extensionInfo.url);
        } else {
            Trace.extPrintln("Optional package download not granted by user");
        }
        return n == 0;
    }

    private void installJarFile(String string, String string2) throws ExtensionInstallationException, IOException, InterruptedException {
        Trace.extPrintln("Starting the installation of " + string2);
        JarFile jarFile = new JarFile(string2);
        Manifest manifest = jarFile.getManifest();
        if (manifest != null) {
            String string3 = AccessController.doPrivileged(new GetPropertyAction("java.ext.dirs"));
            StringTokenizer stringTokenizer = new StringTokenizer(string3, File.pathSeparator);
            String string4 = stringTokenizer.nextToken();
            Attributes attributes = manifest.getMainAttributes();
            ExtensionInstaller extensionInstaller = new RawExtensionInstaller();
            if (attributes != null) {
                if (attributes.getValue(Attributes.Name.MAIN_CLASS) != null) {
                    extensionInstaller = new JavaExtensionInstaller();
                } else if (attributes.getValue(Attributes.Name.EXTENSION_INSTALLATION) != null) {
                    extensionInstaller = new NativeExtensionInstaller();
                }
            }
            jarFile = null;
            extensionInstaller.install(string, string2, string4);
        }
    }

    private static String getMessage(String string) {
        return AppletViewer.getMessage(string);
    }
}

