/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.PropertyPermission;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import sun.applet.AppletClassLoader;
import sun.misc.Resource;
import sun.misc.URLClassPath;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.security.TrustDecider;
import sun.plugin.usability.Trace;

public class PluginClassLoader
extends AppletClassLoader {
    private static RuntimePermission usePolicyPermission;
    private URL base;
    private URLClassPath cachedUCP;
    private Vector cachedJarFiles;
    private String className;

    public PluginClassLoader(URL uRL) {
        super(uRL);
        this.base = uRL;
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        permissionCollection.add(new PropertyPermission("browser", "read"));
        permissionCollection.add(new PropertyPermission("browser.version", "read"));
        permissionCollection.add(new PropertyPermission("browser.vendor", "read"));
        permissionCollection.add(new PropertyPermission("http.agent", "read"));
        permissionCollection.add(new PropertyPermission("javaplugin.version", "read"));
        permissionCollection.add(new PropertyPermission("javaplugin.proxy.config.type", "read"));
        permissionCollection.add(new PropertyPermission("javaplugin.proxy.config.list", "read"));
        permissionCollection.add(new PropertyPermission("javaplugin.proxy.config.bypass", "read"));
        if (usePolicyPermission == null) {
            usePolicyPermission = new RuntimePermission("usePolicy");
        }
        if (!permissionCollection.implies(usePolicyPermission) && codeSource.getCertificates() != null) {
            try {
                if (TrustDecider.isAllPermissionGranted(codeSource)) {
                    permissionCollection.add(new AllPermission());
                }
            }
            catch (CertificateExpiredException certificateExpiredException) {
                Trace.securityPrintException(certificateExpiredException, ResourceHandler.getMessage("rsa.cert_expired"), ResourceHandler.getMessage("security_dialog.caption"));
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                Trace.securityPrintException(certificateNotYetValidException, ResourceHandler.getMessage("rsa.cert_notyieldvalid"), ResourceHandler.getMessage("security_dialog.caption"));
            }
            catch (Exception exception) {
                Trace.securityPrintException(exception, ResourceHandler.getMessage("rsa.general_error"), ResourceHandler.getMessage("security_dialog.caption"));
            }
        }
        if (this.cachedUCP != null) {
            URL[] uRLArray = this.cachedUCP.getURLs();
            int n = 0;
            while (n < uRLArray.length) {
                permissionCollection.add(new FilePermission(uRLArray[n].getFile(), "read"));
                ++n;
            }
        }
        return permissionCollection;
    }

    private ProtectionDomain getProtectionDomain(CodeSource codeSource) {
        if (codeSource == null) {
            return null;
        }
        ProtectionDomain protectionDomain = new ProtectionDomain(codeSource, this.getPermissions(codeSource));
        return protectionDomain;
    }

    public void addMyJar(URL uRL, String string) {
        URL uRL2;
        try {
            uRL2 = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("name");
        }
        ((URLClassLoader)((Object)this)).addURL(uRL2);
    }

    public synchronized void addCacheJar(Vector vector) {
        if (vector == null) {
            return;
        }
        if (vector.isEmpty()) {
            return;
        }
        if (null == this.cachedUCP) {
            this.cachedUCP = new URLClassPath(new URL[0]);
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            try {
                URL[] uRLArray = this.cachedUCP.getURLs();
                boolean bl = false;
                URL uRL = ((File)enumeration.nextElement()).toURL();
                int n = 0;
                while (n < uRLArray.length && !bl) {
                    bl = uRLArray[n].equals(uRL);
                    ++n;
                }
                if (bl) continue;
                this.cachedUCP.addURL(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("Plugin cache corrupted, using remote copy");
                return;
            }
        }
    }

    protected Class findClass(final String string) throws ClassNotFoundException {
        if (null == this.cachedUCP) {
            return super.findClass(string);
        }
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    String string2 = string.replace('.', '/').concat(".class");
                    Resource resource = PluginClassLoader.this.cachedUCP.getResource(string2, false);
                    if (resource != null) {
                        try {
                            return PluginClassLoader.this.defineClass(string, resource);
                        }
                        catch (IOException iOException) {
                            throw new ClassNotFoundException(string, iOException);
                        }
                    }
                    return PluginClassLoader.super.findClass(string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (ClassNotFoundException)privilegedActionException.getException();
        }
    }

    private Class defineClass(String string, Resource resource) throws IOException {
        Object object;
        Certificate[] certificateArray;
        Object object2;
        int n = string.lastIndexOf(46);
        URL uRL = resource.getCodeSourceURL();
        if (n != -1) {
            object2 = string.substring(0, n);
            certificateArray = ((ClassLoader)((Object)this)).getPackage((String)object2);
            object = resource.getManifest();
            if (certificateArray != null) {
                boolean bl;
                if (certificateArray.isSealed()) {
                    bl = certificateArray.isSealed(uRL);
                } else {
                    boolean bl2 = bl = object == null || !this.isSealed((String)object2, (Manifest)object);
                }
                if (!bl) {
                    throw new SecurityException("sealing violation");
                }
            } else if (object != null) {
                ((URLClassLoader)((Object)this)).definePackage((String)object2, (Manifest)object, uRL);
            } else {
                ((ClassLoader)((Object)this)).definePackage((String)object2, null, null, null, null, null, null, null);
            }
        }
        object2 = resource.getBytes();
        certificateArray = resource.getCertificates();
        object = new CodeSource(this.base, certificateArray);
        return ((ClassLoader)((Object)this)).defineClass(string, (byte[])object2, 0, ((byte[])object2).length, this.getProtectionDomain((CodeSource)object));
    }

    private boolean isSealed(String string, Manifest manifest) {
        String string2 = string.replace('.', '/').concat("/");
        Attributes attributes = manifest.getAttributes(string2);
        String string3 = null;
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if (string3 == null && (attributes = manifest.getMainAttributes()) != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(string3);
    }

    public URL findResource(String string) {
        Resource resource = null;
        if (null != this.cachedUCP) {
            resource = this.cachedUCP.getResource(string, false);
        }
        return resource != null ? resource.getURL() : super.findResource(string);
    }

    public Enumeration findResources(String string) throws IOException {
        if (null != this.cachedUCP) {
            final Enumeration enumeration = this.cachedUCP.getResources(string, true);
            final Enumeration enumeration2 = this.findResourcesByURLPath(string);
            return new Enumeration(){

                public Object nextElement() {
                    if (enumeration != null && enumeration.hasMoreElements()) {
                        return ((Resource)enumeration.nextElement()).getURL();
                    }
                    if (enumeration2 != null && enumeration2.hasMoreElements()) {
                        return ((Resource)enumeration2.nextElement()).getURL();
                    }
                    throw new NoSuchElementException();
                }

                public boolean hasMoreElements() {
                    return enumeration != null && enumeration.hasMoreElements() || enumeration2 != null && enumeration2.hasMoreElements();
                }
            };
        }
        return this.findResourcesByURLPath(string);
    }

    private Enumeration findResourcesByURLPath(String string) throws IOException {
        if (string != null && string.indexOf("META-INF/services/javax.sound") != -1) {
            return new Enumeration(){

                public Object nextElement() {
                    throw new NoSuchElementException();
                }

                public boolean hasMoreElements() {
                    return false;
                }
            };
        }
        return super.findResources(string);
    }

    public void finalize() {
        Trace.println("Classloader [" + this.base + "] is finalized.", 2);
    }
}

