/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.DefaultDesktopManager;
import javax.swing.JInternalFrame;

public class WindowsDesktopManager
extends DefaultDesktopManager
implements Serializable {
    JInternalFrame currentFrame;
    JInternalFrame initialFrame;
    Vector childFrames = new Vector(1);

    public void closeFrame(JInternalFrame jInternalFrame) {
        if (jInternalFrame == this.currentFrame) {
            this.activateNextFrame();
        }
        this.childFrames.removeElement(jInternalFrame);
        super.closeFrame(jInternalFrame);
    }

    public void activateFrame(JInternalFrame jInternalFrame) {
        try {
            super.activateFrame(jInternalFrame);
            if (this.childFrames.indexOf(jInternalFrame) == -1) {
                this.childFrames.addElement(jInternalFrame);
            }
            if (this.currentFrame != null && jInternalFrame != this.currentFrame) {
                if (this.currentFrame.isMaximum()) {
                    this.currentFrame.setMaximum(false);
                    jInternalFrame.setMaximum(true);
                }
                if (this.currentFrame.isSelected()) {
                    this.currentFrame.setSelected(false);
                }
            }
            if (!jInternalFrame.isSelected()) {
                jInternalFrame.setSelected(true);
            }
            this.currentFrame = jInternalFrame;
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void switchFrame(boolean bl) {
        int n;
        if (this.currentFrame == null) {
            if (this.initialFrame != null) {
                this.activateFrame(this.initialFrame);
            }
            return;
        }
        int n2 = this.childFrames.size();
        if (n2 <= 1) {
            return;
        }
        int n3 = this.childFrames.indexOf(this.currentFrame);
        if (n3 == -1) {
            return;
        }
        if (bl) {
            n = n3 + 1;
            if (n == n2) {
                n = 0;
            }
        } else {
            n = n3 - 1;
            if (n == -1) {
                n = n2 - 1;
            }
        }
        JInternalFrame jInternalFrame = (JInternalFrame)this.childFrames.elementAt(n);
        this.activateFrame(jInternalFrame);
        this.currentFrame = jInternalFrame;
    }

    public void activateNextFrame() {
        this.switchFrame(true);
    }

    public void activateNextFrame(JInternalFrame jInternalFrame) {
        this.initialFrame = jInternalFrame;
        this.switchFrame(true);
    }

    public void activatePreviousFrame() {
        this.switchFrame(false);
    }
}

