// Package consoleInput developed for console input of integers,
// floating-point values, characters, and strings.
// July 23, 2001 - Y. Uckan
// Any class that uses the class consoleIO in this package must be
// a derivation of the class ConsoleInput.

package consoleInput;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;

public class ConsoleInput {

	private static int integer;
	private static double real;
	private static String input;
	private static char character;

	public static int getInteger() {
		try {	InputStreamReader reader = new InputStreamReader(System.in);
				BufferedReader console = new BufferedReader(reader);

				input = console.readLine();
				integer = Integer.parseInt(input);
			} // end try
		catch(IOException e) {	
				System.out.println(e);
				System.exit(1);
		} // end catch
		return integer;
	} // end getInteger

	public static double getDouble() {
		try {	InputStreamReader reader = new InputStreamReader(System.in);
				BufferedReader console = new BufferedReader(reader);

				input = console.readLine();
				real = Double.parseDouble(input);
			} // end try
		catch(IOException e) {	
				System.out.println(e);
				System.exit(1);
		} // end catch
		return real;
	} // end getDouble

	public static String getString() {
		try {	InputStreamReader reader = new InputStreamReader(System.in);
				BufferedReader console = new BufferedReader(reader);

				input = console.readLine();
			} // end try
		catch(IOException e) {	
				System.out.println(e);
				System.exit(1);
		} // end catch
		return input;
	} // end getString

	public static char getCharacter() {
		try {	character = (char) System.in.read();
				System.in.skip(1);
			} // end try
		catch(IOException e) {	
				System.out.println(e);
				System.exit(1);
		} // end catch
		return character;
	} // end getCharacter

} // end class ConsoleInput