package simpleIO;
import java.awt.*;
import java.awt.event.*;

public class BailDialog extends ModalDialog {


	private Button quit, accept;
    private boolean bailOut = false;
    private String defaultValue;
	
	public BailDialog(SimpleDialog dialog, String message) {
		// Instantiate object
		super(dialog);
		defaultValue = message;
		buildDialog("Quit or Return " + defaultValue);
	}
	
	
	protected void addPanel() {
		// make a button panel
		Panel p = new Panel();
		quit = new Button("Quit");
		accept = new Button("Return " + defaultValue);
		
		p.add(quit);
		p.add(accept);
		add(p,BorderLayout.SOUTH);
		
		quit.addActionListener(this);
		accept.addActionListener(this);
	}
	
	public boolean reallyBail() {
		return bailOut;
	}
	
	
	public void actionPerformed(ActionEvent e) {
		bailOut = (e.getSource() == quit);
	    dispose();
	}
	
} // BailDialog
		
