package simpleIO;
import java.awt.*;
import java.awt.event.*;

public class CharDialog extends TextDialog {


	private char result, rangeMin, rangeMax;

	
	public CharDialog(SimpleGUI frame, String prompt, char min, char max) {
		// Instantiate object
		super(frame,prompt);
		rangeMin = min;
		rangeMax = max;	
		setUpDialog();
	}
	
	public char getResult() {
		return result;
	}
	
	// Need to actually handle bad data.
	protected boolean validateResponse(String text) {
		char r;
	
		if (text.length() != 1) { 
			ErrDialog errBox = 
				new ErrDialog(this,"Your input is not a single character");
			return false;
		}
		else { 
			result = text.charAt(0);
			if ((result >= rangeMin) && (result <= rangeMax)) 
				return true;
		
			else { 
				ErrDialog errBox = 
					new ErrDialog(this, "Input outside the range " 
									+ rangeMin + " to " + rangeMax);
				return false;
			}
		}
	}
				
	protected String getDefault() 
		{return "BLANK";}
		
	protected void setDefault()
		{result = ' ';}

} // IntDialog
		
