package simpleIO;
import java.awt.*;
import java.awt.event.*;


public class CheckBoxDialog extends SimpleDialog {

	protected Checkbox box;
//	protected SimpleGUI parent;

	private boolean response;
	
	public CheckBoxDialog(SimpleGUI frame, String prompt) {
		super(frame,prompt);
		setUpDialog();
	}
	
	protected void setUpDialog(){
		box = new Checkbox(promptString,true);

		buildDialogPicture(box);
		addListeners();

		waitForGoodInput();
		dispose();
		removeListeners();
	}	
		
		// set up checkbox group
	
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == accept) {
			response = box.getState();
		   wakeMasterThread(); 
		}
        else if (e.getSource() == retry)
        {	box.setState(true);
        }
        else // cancel! set a sub dialog
           { BailDialog b = new BailDialog(this,getDefault());
             if (b.reallyBail()) 
             	quit = true;
             else 
             	setDefault();
		     wakeMasterThread();
		   }
	}
	
	protected String getDefault() {
		return "true";
	}
	protected void setDefault() {
		response = true;
	}
	
	public boolean getResult() {
		return response;
	}

} // CheckBoxDialog
		
