package simpleIO;
import java.awt.*;
import java.awt.event.*;

public class CheckGroupDialog extends SimpleDialog  {

	protected CheckboxGroup group = new CheckboxGroup();

	protected Checkbox trueBox, falseBox;

	private String trueMessage;
	private String falseMessage;
	private boolean response;
	
	public CheckGroupDialog(SimpleGUI frame, String prompt, String truePrompt, String falsePrompt) {
		// Instantiate object
		super(frame,prompt);
		trueMessage = truePrompt;
		falseMessage = falsePrompt;
		setUpDialog();
	}
	
	protected void setUpDialog() {
		
		// Set up prompt label
		Label l = new Label(promptString);

		
		// set up checkbox group
	
		Panel p = new Panel();
		
		trueBox = new Checkbox(trueMessage,group,true);
		p.add(trueBox);
		
		falseBox = new Checkbox(falseMessage,group,false);
		p.add(falseBox);


		
		buildDialogPicture(p,l);
		addListeners();

		waitForGoodInput();
		dispose();
		removeListeners();
	}

	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == accept) {
			response = (group.getSelectedCheckbox() == trueBox);
		    wakeMasterThread();
		}
        else if (e.getSource() == retry)
        {	group.setSelectedCheckbox(trueBox);
        }
        else // cancel! set a sub dialog
           { BailDialog b = new BailDialog(this,getDefault());
             if (b.reallyBail()) 
             	quit=true;
             else 
             	setDefault();
		   	wakeMasterThread();
		   }
	}
	
	protected String getDefault() {
		return trueMessage;
	}
	protected void setDefault() {
		response = true;
	}
	
	public boolean getResult() {
		return response;
	}

} // CheckGroupDialog
		
