package simpleIO;
import java.awt.*;
import java.awt.event.*;

public class DoubleDialog extends TextDialog {


	private double result, rangeMin, rangeMax;
	
	
	public DoubleDialog(SimpleGUI frame, String prompt, double min, double max) {
		// Instantiate object
		
		super(frame,prompt);
 
		rangeMin = min;
		rangeMax = max;	

		setUpDialog();
		
	}
	
	public double getResult() {
		return result;
	}
	
	// Need to actually handle bad data.
	protected boolean validateResponse(String text) {
		Double r;
		
		try {
			  r = Double.valueOf(text);
		} 
		catch(NumberFormatException e) {
			ErrDialog errBox = 
				new ErrDialog(this, "Your input was not a real number");
			return false;
		}
		result = r.doubleValue();
		// might want to check for Double.MIN_VALUE (very tiny fractions)
		// eventually do this with a class exception.
		if ((result >= rangeMin) && (result <= rangeMax)) 
			return true;
		else { ErrDialog errBox = 
				new ErrDialog(this, "Input outside the range " 
										 + rangeMin + " to " + rangeMax);
			   return false;
		} // else
	}
				
	protected String getDefault() 
		{return "0";}
		
	protected void setDefault()
		{result = 0;}

} // DoubleDialog
		
