package simpleIO;
import java.awt.*;
import java.awt.event.*;

public class IntDialog extends TextDialog {


	private int result, rangeMin, rangeMax;

	
	public IntDialog(SimpleGUI frame, String prompt, int min, int max) {
		// Instantiate object
		super(frame,prompt);
		rangeMin = min;
		rangeMax = max;	
		
		setUpDialog();
	}
	
	public int getResult() {
		return result;
	}
	
	// Need to actually handle bad data.
	protected boolean validateResponse(String text) {
		Integer r;
		
		try {
			  r = Integer.valueOf(text);
		} 
		catch(NumberFormatException e) {
			ErrDialog errBox = 
				new ErrDialog(this, "Your input was not an integer");
			return false;
		}
		result = r.intValue();
		// might want to check for Double.MIN_VALUE (very tiny fractions)
		// eventually do this with a class exception.
		if ((result >= rangeMin) && (result <= rangeMax)) 
			return true;
		else { ErrDialog errBox = 
				new ErrDialog(this, "Input outside the range " 
										 + rangeMin + " to " + rangeMax);
			   return false;
		} // else
	}
				
	protected String getDefault() 
		{return "0";}
		
	protected void setDefault()
		{result = 0;}

} // IntDialog
		
