package simpleIO;
import java.awt.*;
import java.awt.event.*;


public class MenuDialog extends SimpleDialog {

	protected Choice menu;

	private int response;
	
	public MenuDialog(SimpleGUI frame, String prompt, Choice m) {
		// Instantiate object
		super(frame,prompt);
		menu = m;
		setUpDialog();
	}
	
	protected void setUpDialog() {
		// set up label
		Label l = new Label(promptString);

		// set up menu
		buildDialogPicture(menu,l);
		addListeners();

		waitForGoodInput();
		dispose();
		removeListeners();
	}

	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == accept) {
			response = menu.getSelectedIndex();
		   wakeMasterThread();
		}
        else if (e.getSource() == retry)
        {	menu.select(0);
        }
        else // cancel! set a sub dialog
           { BailDialog b = new BailDialog(this,getDefault());
             if (b.reallyBail()) 
             	quit = true;
             else 
             	setDefault();
			wakeMasterThread();
		   }
	}
	
	protected String getDefault() {
		return menu.getItem(0);
	}
	protected void setDefault() {
		response = 0;
	}
	
	public int getResult() {
		return response;
	}

} // MenuDialog
		
