package simpleIO;
import java.awt.*;
import java.awt.event.*;

abstract public class ModalDialog extends Dialog implements ActionListener {
	
	protected SimpleDialog dialog;
	
	public ModalDialog(SimpleDialog d) {
		// Instantiate object
		super(d.parent,true);
		dialog = d;
	}
	
	public void buildDialog(String message) {	
		// Set up prompt label
		Label l = new Label( message);
		add(l, BorderLayout.CENTER);
		addPanel();
		//   		setResizable(false);
 		
// !!! Does this work on the sun?
   		pack();
   		verifyVisibility(dialog);
   		show();	
	}
	
	abstract protected void addPanel();
	
	private void verifyVisibility(SimpleDialog dialog) {
	
		Rectangle dialogBounds = dialog.getBounds();
   		setLocation(dialogBounds.x, dialogBounds.y + dialogBounds.height + 10);
   		
   	
   		Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
   		// off the left size
   		if (getBounds().x < 0) {
   			
   			setLocation(10, getBounds().y);
   		};
   			
   		if (getBounds().x + getBounds().width >= screenDim.width) {
   			
   			setLocation(screenDim.width - getBounds().width - 20, getBounds().y);
   		};
   		
   		if (getBounds().y + getBounds().height >= screenDim.height) {
   			
   			setLocation(getBounds().x, screenDim.height - getBounds().height - 20);
   		};
   		
   		if (getBounds().y < 0) {
   			
   			setLocation(getBounds().x, 10);
   		};
   	
	}
	
} // ModalDialog
		
